/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.projectiles;

import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class SlimeballEntity
extends DamagingProjectileEntity
implements IRendersAsItem {
    private static final DataParameter<ItemStack> STACK = EntityDataManager.func_187226_a(SlimeballEntity.class, (IDataSerializer)DataSerializers.field_187196_f);

    public SlimeballEntity(World worldIn) {
        super((EntityType)ModEntityTypes.SLIMEBALL.get(), worldIn);
    }

    public SlimeballEntity(EntityType<? extends SlimeballEntity> entityType, World world) {
        super(entityType, world);
    }

    public SlimeballEntity(World world, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super((EntityType)ModEntityTypes.SLIMEBALL.get(), x, y, z, accelX, accelY, accelZ, world);
    }

    public SlimeballEntity(World world, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super((EntityType)ModEntityTypes.SLIMEBALL.get(), shooter, accelX, accelY, accelZ, world);
    }

    public void setStack(ItemStack stack) {
        if (stack.func_77973_b() != Items.field_151123_aH || stack.func_77942_o()) {
            this.func_184212_Q().func_187227_b(STACK, Util.func_200696_a((Object)stack.func_77946_l(), itemStack -> itemStack.func_190920_e(1)));
        }
    }

    protected ItemStack getStack() {
        return (ItemStack)this.func_184212_Q().func_187225_a(STACK);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_184543_l() {
        ItemStack itemstack = this.getStack();
        return itemstack.func_190926_b() ? new ItemStack((IItemProvider)Items.field_151123_aH) : itemstack;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(STACK, (Object)ItemStack.field_190927_a);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        ItemStack itemstack = this.getStack();
        if (!itemstack.func_190926_b()) {
            compound.func_218657_a("Item", (INBT)itemstack.func_77955_b(new CompoundNBT()));
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        ItemStack itemstack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Item"));
        this.setStack(itemstack);
    }

    protected boolean func_184564_k() {
        return false;
    }

    protected IParticleData func_195057_f() {
        return ParticleTypes.field_197592_C;
    }

    protected void func_213868_a(EntityRayTraceResult rayTraceResult) {
        super.func_213868_a(rayTraceResult);
        Entity entity = rayTraceResult.func_216348_a();
        int attackDamage = 3;
        if (!(entity instanceof SlimeEntity)) {
            entity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_234616_v_()), (float)attackDamage);
        }
    }

    protected void func_70227_a(RayTraceResult result) {
        super.func_70227_a(result);
        if (result instanceof EntityRayTraceResult) {
            EntityRayTraceResult entityRayTraceResult = (EntityRayTraceResult)result;
            if (!(entityRayTraceResult.func_216348_a() instanceof SlimeEntity) && !this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        } else {
            this.removeIfWorldNotRemote();
        }
    }

    private void removeIfWorldNotRemote() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

