/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.redstone;

import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import java.util.EnumSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;

public class RedstoneCubeEntity
extends MonsterEntity {
    protected int rollingDuration;
    private static final DataParameter<Boolean> IS_ROLLING = EntityDataManager.func_187226_a(RedstoneCubeEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public RedstoneCubeEntity(World worldIn) {
        super((EntityType)ModEntityTypes.REDSTONE_CUBE.get(), worldIn);
    }

    public RedstoneCubeEntity(EntityType<? extends RedstoneCubeEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new MoveHelperController(this);
        this.field_70138_W = 1.0f;
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 16.0).func_233815_a_(Attributes.field_233821_d_, 0.30000000447034836).func_233815_a_(Attributes.field_233823_f_, 4.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_ROLLING, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new AttackGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FaceRandomGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, entity -> Math.abs(entity.func_226278_cu_() - this.func_226278_cu_()) <= 4.0));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    public void func_70108_f(Entity entityIn) {
        super.func_70108_f(entityIn);
        if (entityIn instanceof IronGolemEntity && this.canDamagePlayer()) {
            this.dealDamage((LivingEntity)((IronGolemEntity)entityIn));
        }
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        if (this.canDamagePlayer()) {
            this.dealDamage((LivingEntity)entityIn);
        }
    }

    protected void dealDamage(LivingEntity entityIn) {
        if (this.func_70089_S()) {
            int i = 2;
            if (this.func_70068_e((Entity)entityIn) < 0.6 * (double)i * 0.6 * (double)i && this.func_70685_l((Entity)entityIn) && entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), this.getAttackDamageAmount())) {
                this.func_184185_a(SoundEvents.field_187843_fX, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                this.func_174815_a((LivingEntity)this, (Entity)entityIn);
            }
        }
    }

    protected float getAttackDamageAmount() {
        return (float)this.func_233637_b_(Attributes.field_233823_f_);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.625f * sizeIn.field_220316_b;
    }

    protected boolean canDamagePlayer() {
        return this.func_70613_aW();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187843_fX;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187835_fT;
    }

    public int func_70646_bf() {
        return 0;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.isRolling() && this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, this.func_226282_d_(0.5) + 1.0, this.func_226279_cv_() - 0.25 + 1.0, this.func_226287_g_(0.5) + 1.0, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
        }
        if (this.rollingDuration > 0) {
            --this.rollingDuration;
            this.updateRoll();
        } else {
            this.stopRolling();
        }
    }

    public void startRolling(int timeIn) {
        this.rollingDuration = timeIn;
        if (!this.field_70170_p.field_72995_K) {
            this.setIsRolling(true);
        }
    }

    public void stopRolling() {
        this.rollingDuration = 0;
        if (!this.field_70170_p.field_72995_K) {
            this.setIsRolling(false);
        }
    }

    public boolean shouldRoll() {
        return this.func_233570_aj_() || this.func_70090_H();
    }

    protected void updateRoll() {
        if (!this.shouldRoll()) {
            this.rollingDuration = 0;
        }
        if (!this.field_70170_p.field_72995_K && this.rollingDuration <= 0) {
            this.setIsRolling(false);
        }
    }

    public void setIsRolling(boolean isRolling) {
        this.field_70180_af.func_187227_b(IS_ROLLING, (Object)isRolling);
    }

    public boolean isRolling() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_ROLLING);
    }

    static class MoveHelperController
    extends MovementController {
        private float yRot;
        private final RedstoneCubeEntity redstoneCubeEntity;
        private boolean isAggressive;

        public MoveHelperController(RedstoneCubeEntity cubeIn) {
            super((MobEntity)cubeIn);
            this.redstoneCubeEntity = cubeIn;
            this.yRot = 180.0f * cubeIn.field_70177_z / (float)Math.PI;
        }

        public void setDirection(float yRotIn, boolean aggressive) {
            this.yRot = yRotIn;
            this.isAggressive = aggressive;
        }

        public void setSpeed(double speedIn) {
            this.field_75645_e = speedIn;
            this.field_188491_h = MovementController.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.yRot, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h == MovementController.Action.WAIT) {
                this.field_75648_a.func_191989_p(0.0f);
            } else if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                this.field_188491_h = MovementController.Action.WAIT;
                if (this.field_75648_a.func_233570_aj_() || this.field_75648_a.func_70090_H()) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_233637_b_(Attributes.field_233821_d_)));
                    if (!this.redstoneCubeEntity.isRolling() && this.redstoneCubeEntity.shouldRoll()) {
                        this.redstoneCubeEntity.startRolling(20);
                    }
                }
            }
        }
    }

    static class FaceRandomGoal
    extends Goal {
        private final RedstoneCubeEntity redstoneCubeEntity;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public FaceRandomGoal(RedstoneCubeEntity cubeIn) {
            this.redstoneCubeEntity = cubeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return this.redstoneCubeEntity.func_70638_az() == null && (this.redstoneCubeEntity.func_233570_aj_() || this.redstoneCubeEntity.func_70090_H() || this.redstoneCubeEntity.func_180799_ab() || this.redstoneCubeEntity.func_70644_a(Effects.field_188424_y));
        }

        public void func_75246_d() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.redstoneCubeEntity.func_70681_au().nextInt(60);
                this.chosenDegrees = this.redstoneCubeEntity.func_70681_au().nextInt(360);
            }
            ((MoveHelperController)this.redstoneCubeEntity.func_70605_aq()).setDirection(this.chosenDegrees, false);
        }
    }

    static class AttackGoal
    extends Goal {
        private final RedstoneCubeEntity redstoneCubeEntity;
        private int growTieredTimer;

        AttackGoal(RedstoneCubeEntity cubeIn) {
            this.redstoneCubeEntity = cubeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = this.redstoneCubeEntity.func_70638_az();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.func_70089_S()) {
                return false;
            }
            return !(livingentity instanceof PlayerEntity) || !((PlayerEntity)livingentity).field_71075_bZ.field_75102_a;
        }

        public void func_75249_e() {
            this.growTieredTimer = 300;
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            LivingEntity livingentity = this.redstoneCubeEntity.func_70638_az();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.func_70089_S()) {
                return false;
            }
            if (livingentity instanceof PlayerEntity && ((PlayerEntity)livingentity).field_71075_bZ.field_75102_a) {
                return false;
            }
            return --this.growTieredTimer > 0;
        }

        public void func_75246_d() {
            this.redstoneCubeEntity.func_70625_a((Entity)this.redstoneCubeEntity.func_70638_az(), 10.0f, 10.0f);
            ((MoveHelperController)this.redstoneCubeEntity.func_70605_aq()).setDirection(this.redstoneCubeEntity.field_70177_z, this.redstoneCubeEntity.canDamagePlayer());
        }
    }
}

