/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.redstone;

import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public class RedstoneMineEntity
extends Entity {
    private static final int LIFE_TICKS = 160;
    private int lifeTicks;
    private LivingEntity caster;
    private UUID casterUuid;
    private float explosionRadius = 3.0f;

    public RedstoneMineEntity(World worldIn) {
        super((EntityType)ModEntityTypes.REDSTONE_MINE.get(), worldIn);
    }

    public RedstoneMineEntity(EntityType<? extends RedstoneMineEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public RedstoneMineEntity(World worldIn, double x, double y, double z, LivingEntity casterIn) {
        this((EntityType<? extends RedstoneMineEntity>)((EntityType)ModEntityTypes.REDSTONE_MINE.get()), worldIn);
        this.setCaster(casterIn);
        this.func_70107_b(x, y, z);
        this.lifeTicks = 160;
    }

    public void setCaster(@Nullable LivingEntity livingEntity) {
        this.caster = livingEntity;
        this.casterUuid = livingEntity == null ? null : livingEntity.func_110124_au();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    public boolean func_70075_an() {
        return false;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    @Nullable
    public AxisAlignedBB getCollisionBoundingBox() {
        return this.func_174813_aQ();
    }

    public boolean func_70067_L() {
        return true;
    }

    private void explode() {
        this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226283_e_(0.0625), this.func_226281_cx_(), this.explosionRadius, Explosion.Mode.NONE);
        this.func_70106_y();
    }

    public void handleExistence() {
        this.func_233566_aG_();
    }

    public void handleExpiration() {
        this.func_70106_y();
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            --this.lifeTicks;
            if (this.lifeTicks <= 0) {
                this.handleExpiration();
            }
        } else {
            this.handleExistence();
        }
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        if (entityIn != this.getCaster()) {
            this.explode();
        }
    }

    private void checkCollisions() {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(0.2, 0.2, 0.2));
        for (Entity entity : list) {
            if (entity.field_70128_L || this.field_70128_L || entity == this.getCaster()) continue;
            this.explode();
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setLifeTicks(compound.func_74762_e("LifeTicks"));
        if (compound.func_186855_b("Owner")) {
            this.casterUuid = compound.func_186857_a("Owner");
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("LifeTicks", this.getLifeTicks());
        if (this.casterUuid != null) {
            compound.func_186854_a("Owner", this.casterUuid);
        }
    }

    public int getLifeTicks() {
        return this.lifeTicks;
    }

    public void setLifeTicks(int lifeTicksIn) {
        this.lifeTicks = lifeTicksIn;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

