/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.slime;

import com.infamous.dungeons_mobs.entities.projectiles.SlimeballEntity;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ConjuredSlimeEntity
extends SlimeEntity
implements IRangedAttackMob {
    public ConjuredSlimeEntity(World worldIn) {
        super((EntityType)ModEntityTypes.CONJURED_SLIME.get(), worldIn);
    }

    public ConjuredSlimeEntity(EntityType<? extends ConjuredSlimeEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new MoveHelperController(this);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MonsterEntity.func_234295_eP_();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new ImmobileRangedAttackGoal(40, 10.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new FaceRandomGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, this::canSlimeReach));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    private boolean canSlimeReach(LivingEntity target) {
        return Math.abs(target.func_226278_cu_() - this.func_226278_cu_()) <= 4.0;
    }

    public EntityType<? extends ConjuredSlimeEntity> func_200600_R() {
        return (EntityType)ModEntityTypes.CONJURED_SLIME.get();
    }

    public void func_70108_f(Entity entityIn) {
        double d1;
        double d0;
        double d2;
        if (!(this.func_70608_bn() || this.func_184223_x(entityIn) || entityIn.field_70145_X || this.field_70145_X || !((d2 = MathHelper.func_76132_a((double)(d0 = entityIn.func_226277_ct_() - this.func_226277_ct_()), (double)(d1 = entityIn.func_226281_cx_() - this.func_226281_cx_()))) >= (double)0.01f))) {
            d2 = MathHelper.func_76133_a((double)d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            d0 *= (double)(1.0f - this.field_70144_Y);
            d1 *= (double)(1.0f - this.field_70144_Y);
            if (!this.func_184207_aI()) {
                this.func_70024_g(-d0, 0.0, -d1);
            }
            if (!entityIn.func_184207_aI()) {
                entityIn.func_70024_g(d0, 0.0, d1);
            }
        }
    }

    public void func_70100_b_(PlayerEntity entityIn) {
    }

    protected void func_175451_e(LivingEntity entityIn) {
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.625f * sizeIn.field_220316_b;
    }

    protected boolean func_70800_m() {
        return this.func_70613_aW();
    }

    protected void func_70664_aZ() {
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        double squareDistanceToTarget = this.func_70068_e((Entity)target);
        double xDifference = target.func_226277_ct_() - this.func_226277_ct_();
        double yDifference = target.func_226283_e_(0.5) - this.func_226283_e_(0.5);
        double zDifference = target.func_226281_cx_() - this.func_226281_cx_();
        float f = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)squareDistanceToTarget)) * 0.5f;
        SlimeballEntity slimeballEntity = new SlimeballEntity(this.field_70170_p, (LivingEntity)this, xDifference * (double)f, yDifference, zDifference * (double)f);
        slimeballEntity.func_70107_b(slimeballEntity.func_226277_ct_(), this.func_226283_e_(0.25), slimeballEntity.func_226281_cx_());
        this.field_70170_p.func_217376_c((Entity)slimeballEntity);
    }

    static class MoveHelperController
    extends MovementController {
        private float yRot;
        private final ConjuredSlimeEntity slime;

        public MoveHelperController(ConjuredSlimeEntity slimeIn) {
            super((MobEntity)slimeIn);
            this.slime = slimeIn;
            this.yRot = 180.0f * slimeIn.field_70177_z / (float)Math.PI;
        }

        public void setDirection(float yRotIn) {
            this.yRot = yRotIn;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.yRot, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
        }
    }

    static class FaceRandomGoal
    extends Goal {
        private final ConjuredSlimeEntity slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public FaceRandomGoal(ConjuredSlimeEntity slimeIn) {
            this.slime = slimeIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return this.slime.func_70638_az() == null && (this.slime.field_70122_E || this.slime.func_70090_H() || this.slime.func_180799_ab() || this.slime.func_70644_a(Effects.field_188424_y)) && this.slime.func_70605_aq() instanceof MoveHelperController;
        }

        public void func_75246_d() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.slime.func_70681_au().nextInt(60);
                this.chosenDegrees = this.slime.func_70681_au().nextInt(360);
            }
            ((MoveHelperController)this.slime.func_70605_aq()).setDirection(this.chosenDegrees);
        }
    }

    class ImmobileRangedAttackGoal
    extends Goal {
        private final int minRangedAttackInterval;
        private final int maxRangedAttackTime;
        private final float attackRadius;
        private final float maxAttackDistance;
        private int rangedAttackTime = -1;
        private int seeTime;
        private int growTieredTimer;

        public ImmobileRangedAttackGoal(int maxAttackTimeIn, float maxAttackDistanceIn) {
            this.minRangedAttackInterval = maxAttackTimeIn;
            this.maxRangedAttackTime = maxAttackTimeIn;
            this.attackRadius = maxAttackDistanceIn;
            this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = ConjuredSlimeEntity.this.func_70638_az();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.func_70089_S()) {
                return false;
            }
            return (!(livingentity instanceof PlayerEntity) || !((PlayerEntity)livingentity).field_71075_bZ.field_75102_a) && ConjuredSlimeEntity.this.func_70605_aq() instanceof MoveHelperController;
        }

        public void func_75249_e() {
            this.growTieredTimer = 300;
            super.func_75249_e();
        }

        public void func_75251_c() {
            this.seeTime = 0;
            this.rangedAttackTime = -1;
        }

        public boolean func_75253_b() {
            LivingEntity livingentity = ConjuredSlimeEntity.this.func_70638_az();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.func_70089_S()) {
                return false;
            }
            if (livingentity instanceof PlayerEntity && ((PlayerEntity)livingentity).field_71075_bZ.field_75102_a) {
                return false;
            }
            return --this.growTieredTimer > 0;
        }

        public void func_75246_d() {
            LivingEntity attackTarget = ConjuredSlimeEntity.this.func_70638_az();
            if (attackTarget != null) {
                double distanceSqToTarget = ConjuredSlimeEntity.this.func_70092_e(attackTarget.func_226277_ct_(), attackTarget.func_226278_cu_(), attackTarget.func_226281_cx_());
                boolean canSeeTarget = ConjuredSlimeEntity.this.func_70635_at().func_75522_a((Entity)attackTarget);
                this.seeTime = canSeeTarget ? ++this.seeTime : 0;
                ConjuredSlimeEntity.this.func_70625_a((Entity)ConjuredSlimeEntity.this.func_70638_az(), 10.0f, 10.0f);
                ((MoveHelperController)ConjuredSlimeEntity.this.func_70605_aq()).setDirection(ConjuredSlimeEntity.this.field_70177_z);
                if (--this.rangedAttackTime == 0) {
                    if (!canSeeTarget) {
                        return;
                    }
                    float f = MathHelper.func_76133_a((double)distanceSqToTarget) / this.attackRadius;
                    float clamp = MathHelper.func_76131_a((float)f, (float)0.1f, (float)1.0f);
                    ConjuredSlimeEntity.this.func_82196_d(attackTarget, clamp);
                    this.rangedAttackTime = MathHelper.func_76141_d((float)(f * (float)(this.maxRangedAttackTime - this.minRangedAttackInterval) + (float)this.minRangedAttackInterval));
                } else if (this.rangedAttackTime < 0) {
                    float f2 = MathHelper.func_76133_a((double)distanceSqToTarget) / this.attackRadius;
                    this.rangedAttackTime = MathHelper.func_76141_d((float)(f2 * (float)(this.maxRangedAttackTime - this.minRangedAttackInterval) + (float)this.minRangedAttackInterval));
                }
            }
        }
    }
}

