/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.summonables;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class ConstructEntity
extends Entity {
    private int lifeTicks;
    private LivingEntity caster;
    private UUID casterUuid;

    protected ConstructEntity(EntityType<? extends ConstructEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    protected ConstructEntity(EntityType<? extends ConstructEntity> entityTypeIn, World worldIn, double x, double y, double z, LivingEntity casterIn, int lifeTicksIn) {
        this(entityTypeIn, worldIn);
        this.setLifeTicks(lifeTicksIn);
        this.setCaster(casterIn);
        this.func_70107_b(x, y, z);
    }

    public void func_70088_a() {
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_241845_aY() {
        return this.func_70089_S();
    }

    public void setCaster(@Nullable LivingEntity caster) {
        this.caster = caster;
        this.casterUuid = caster == null ? null : caster.func_110124_au();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    public void faceDirection(Direction directionToFace) {
        float currentRotationYaw = this.field_70177_z;
        Direction currentDirection = this.func_184172_bi();
        float rotationAmount = 0.0f;
        while (currentDirection != directionToFace) {
            currentDirection = currentDirection.func_176746_e();
            rotationAmount += 90.0f;
        }
        this.field_70177_z = currentRotationYaw + rotationAmount;
    }

    public boolean func_70075_an() {
        return false;
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setLifeTicks(compound.func_74762_e("LifeTicks"));
        if (compound.func_186855_b("Owner")) {
            this.casterUuid = compound.func_186857_a("Owner");
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("LifeTicks", this.getLifeTicks());
        if (this.casterUuid != null) {
            compound.func_186854_a("Owner", this.casterUuid);
        }
    }

    public int getLifeTicks() {
        return this.lifeTicks;
    }

    public void setLifeTicks(int lifeTicksIn) {
        this.lifeTicks = lifeTicksIn;
    }

    public void handleExistence() {
        this.func_233566_aG_();
    }

    public void handleExpiration() {
        this.func_70106_y();
    }

    public void func_70071_h_() {
        --this.lifeTicks;
        if (!this.field_70170_p.func_201670_d() && this.lifeTicks <= 0) {
            this.handleExpiration();
        } else {
            this.handleExistence();
        }
    }
}

