/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.undead;

import com.infamous.dungeons_mobs.capabilities.teamable.TeamableHelper;
import com.infamous.dungeons_mobs.config.DungeonsMobsConfig;
import com.infamous.dungeons_mobs.entities.magic.MagicType;
import com.infamous.dungeons_mobs.entities.projectiles.LaserOrbEntity;
import com.infamous.dungeons_mobs.entities.undead.WraithEntity;
import com.infamous.dungeons_mobs.goals.SimpleRangedAttackGoal;
import com.infamous.dungeons_mobs.goals.magic.UseMagicGoal;
import com.infamous.dungeons_mobs.goals.magic.UsingMagicGoal;
import com.infamous.dungeons_mobs.interfaces.IMagicUser;
import com.infamous.dungeons_mobs.items.NecromancerStaffItem;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.FleeSunGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RestrictSunGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class NecromancerEntity
extends AbstractSkeletonEntity
implements IMagicUser {
    private static final DataParameter<Byte> MAGIC = EntityDataManager.func_187226_a(WraithEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    public static final Predicate<Item> STAFF_PREDICATE = item -> item instanceof NecromancerStaffItem;
    private int magicUseTicks;
    private MagicType activeMagic = MagicType.NONE;

    public NecromancerEntity(World worldIn) {
        super((EntityType)ModEntityTypes.NECROMANCER.get(), worldIn);
    }

    public NecromancerEntity(EntityType<? extends NecromancerEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new UsingNecromancy());
        this.field_70714_bg.func_75776_a(2, (Goal)new RestrictSunGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FleeSunGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new UseNecromancy());
        this.field_70714_bg.func_75776_a(5, new SimpleRangedAttackGoal<NecromancerEntity>(this, STAFF_PREDICATE, NecromancerEntity::performRangedAttack, 1.25, 20, 20.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, WolfEntity.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, TurtleEntity.class, 10, true, false, TurtleEntity.field_203029_bx));
    }

    protected boolean func_204609_dp() {
        return false;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ModItems.NECROMANCER_STAFF.get()));
    }

    protected void func_180483_b(DifficultyInstance difficulty) {
    }

    public void func_85036_m() {
    }

    private static void performRangedAttack(LivingEntity shooter, LivingEntity target) {
        shooter.func_184609_a(ProjectileHelper.getWeaponHoldingHand((LivingEntity)shooter, STAFF_PREDICATE));
        double scale = 1.0;
        Vector3d viewVector = shooter.func_70676_i(1.0f);
        double xAccel = target.func_226277_ct_() - (shooter.func_226277_ct_() + viewVector.field_72450_a * scale);
        double yAccel = target.func_226283_e_(0.5) - (0.5 + shooter.func_226283_e_(0.5));
        double zAccel = target.func_226281_cx_() - (shooter.func_226281_cx_() + viewVector.field_72449_c * scale);
        float euclidDist = MathHelper.func_76133_a((double)(xAccel * xAccel + yAccel * yAccel + zAccel * zAccel));
        LaserOrbEntity laserOrb = new LaserOrbEntity(shooter.field_70170_p, shooter, 0.0, 0.0, 0.0);
        laserOrb.func_70107_b(shooter.func_226277_ct_() + viewVector.field_72450_a * scale, shooter.func_226283_e_(0.5) + 0.5, laserOrb.func_226281_cx_() + viewVector.field_72449_c * scale);
        laserOrb.func_70186_c(xAccel, yAccel, zAccel, euclidDist, 0.0f);
        shooter.field_70170_p.func_217376_c((Entity)laserOrb);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        boolean wearingHalloweenPumpkin;
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.func_98053_h(false);
        boolean bl = wearingHalloweenPumpkin = this.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == Blocks.field_196628_cT.func_199767_j() || this.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == Blocks.field_196625_cS.func_199767_j();
        if (wearingHalloweenPumpkin) {
            LocalDate localdate = LocalDate.now();
            int i = localdate.get(ChronoField.DAY_OF_MONTH);
            int j = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j == 10 && i == 31) {
                this.func_184201_a(EquipmentSlotType.HEAD, ItemStack.field_190927_a);
            }
        }
        return spawnDataIn;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187854_fc;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187864_fh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187856_fd;
    }

    protected SoundEvent func_190727_o() {
        return SoundEvents.field_187868_fj;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MAGIC, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        IMagicUser.spawnMagicParticles(this);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.magicUseTicks > 0) {
            --this.magicUseTicks;
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.magicUseTicks = compound.func_74762_e("MagicUseTicks");
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("MagicUseTicks", this.magicUseTicks);
    }

    @Override
    public boolean isUsingMagic() {
        if (this.field_70170_p.field_72995_K) {
            return (Byte)this.field_70180_af.func_187225_a(MAGIC) > 0;
        }
        return this.magicUseTicks > 0;
    }

    @Override
    public int getMagicUseTicks() {
        return this.magicUseTicks;
    }

    @Override
    public void setMagicUseTicks(int magicUseTicksIn) {
        this.magicUseTicks = magicUseTicksIn;
    }

    @Override
    public MagicType getMagicType() {
        return !this.field_70170_p.field_72995_K ? this.activeMagic : MagicType.getFromId(((Byte)this.field_70180_af.func_187225_a(MAGIC)).byteValue());
    }

    @Override
    public void setMagicType(MagicType magicType) {
        this.activeMagic = magicType;
        this.field_70180_af.func_187227_b(MAGIC, (Object)((byte)magicType.getId()));
    }

    @Override
    public SoundEvent getMagicSound() {
        return SoundEvents.field_191244_bn;
    }

    class UseNecromancy
    extends UseMagicGoal<NecromancerEntity> {
        private final EntityPredicate entityPredicate;

        UseNecromancy() {
            super(NecromancerEntity.this);
            this.entityPredicate = new EntityPredicate().func_221013_a(16.0).func_221014_c().func_221010_e().func_221008_a().func_221011_b();
        }

        @Override
        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            int i = NecromancerEntity.this.field_70170_p.func_217374_a(ZombieEntity.class, this.entityPredicate, (LivingEntity)NecromancerEntity.this, NecromancerEntity.this.func_174813_aQ().func_186662_g(16.0)).size();
            return NecromancerEntity.this.field_70146_Z.nextInt(16) + 1 > i;
        }

        @Override
        public boolean func_75253_b() {
            LivingEntity targetEntity = NecromancerEntity.this.func_70638_az();
            if (targetEntity == null) {
                return false;
            }
            boolean canTargetBeSeen = NecromancerEntity.this.func_70685_l((Entity)targetEntity);
            if (canTargetBeSeen && targetEntity.func_70089_S()) {
                return super.func_75253_b();
            }
            return false;
        }

        @Override
        protected void useMagic() {
            LivingEntity targetEntity = NecromancerEntity.this.func_70638_az();
            if (targetEntity != null) {
                this.summonUndead();
            }
        }

        private void summonUndead() {
            int difficultyAsInt = NecromancerEntity.this.field_70170_p.func_175659_aa().func_151525_a();
            int mobsToSummon = difficultyAsInt * 2;
            for (int i = 0; i < mobsToSummon; ++i) {
                BlockPos blockpos = NecromancerEntity.this.func_233580_cy_().func_177982_a(-2 + NecromancerEntity.this.field_70146_Z.nextInt(5), 1, -2 + NecromancerEntity.this.field_70146_Z.nextInt(5));
                boolean summonedMobFromConfig = this.summonMobFromConfig(blockpos);
                if (summonedMobFromConfig) continue;
                this.summonZombie(blockpos);
            }
        }

        private boolean summonMobFromConfig(BlockPos blockpos) {
            List necromancerMobSummons = (List)DungeonsMobsConfig.Common.NECROMANCER_MOB_SUMMONS.get();
            if (necromancerMobSummons.isEmpty()) {
                return false;
            }
            Collections.shuffle(necromancerMobSummons);
            int randomIndex = NecromancerEntity.this.func_70681_au().nextInt(necromancerMobSummons.size());
            String randomMobID = (String)necromancerMobSummons.get(randomIndex);
            EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(randomMobID));
            if (entityType == null) {
                return false;
            }
            Entity entity = entityType.func_200721_a(NecromancerEntity.this.field_70170_p);
            if (!(entity instanceof MobEntity)) {
                return false;
            }
            MobEntity mobEntity = (MobEntity)entity;
            DifficultyInstance difficultyForLocation = NecromancerEntity.this.field_70170_p.func_175649_E(blockpos);
            mobEntity.func_174828_a(blockpos, 0.0f, 0.0f);
            ModifiableAttributeInstance spawnReinforcementsAttribute = mobEntity.func_110148_a(Attributes.field_233829_l_);
            if (spawnReinforcementsAttribute != null) {
                spawnReinforcementsAttribute.func_111128_a(0.0);
            }
            mobEntity.func_213386_a((IServerWorld)NecromancerEntity.this.field_70170_p, difficultyForLocation, SpawnReason.MOB_SUMMONED, (ILivingEntityData)null, (CompoundNBT)null);
            TeamableHelper.makeTeammates(mobEntity, (MobEntity)NecromancerEntity.this);
            return NecromancerEntity.this.field_70170_p.func_217376_c((Entity)mobEntity);
        }

        private void summonZombie(BlockPos blockpos) {
            ZombieEntity zombieEntity = (ZombieEntity)EntityType.field_200725_aD.func_200721_a(NecromancerEntity.this.field_70170_p);
            if (zombieEntity != null) {
                DifficultyInstance difficultyForLocation = NecromancerEntity.this.field_70170_p.func_175649_E(blockpos);
                zombieEntity.func_174828_a(blockpos, 0.0f, 0.0f);
                ModifiableAttributeInstance spawnReinforcementsAttribute = zombieEntity.func_110148_a(Attributes.field_233829_l_);
                if (spawnReinforcementsAttribute != null) {
                    spawnReinforcementsAttribute.func_111128_a(0.0);
                }
                zombieEntity.func_213386_a((IServerWorld)NecromancerEntity.this.field_70170_p, difficultyForLocation, SpawnReason.MOB_SUMMONED, (ILivingEntityData)null, (CompoundNBT)null);
                TeamableHelper.makeTeammates((MobEntity)zombieEntity, (MobEntity)NecromancerEntity.this);
                NecromancerEntity.this.field_70170_p.func_217376_c((Entity)zombieEntity);
            }
        }

        @Override
        protected int getMagicUseTime() {
            return 100;
        }

        @Override
        protected int getMagicUseInterval() {
            return 340;
        }

        @Override
        @Nullable
        protected SoundEvent getMagicPrepareSound() {
            return SoundEvents.field_187855_gD;
        }

        @Override
        protected MagicType getMagicType() {
            return MagicType.SUMMON_UNDEAD;
        }
    }

    class UsingNecromancy
    extends UsingMagicGoal<NecromancerEntity> {
        UsingNecromancy() {
            super(NecromancerEntity.this);
        }
    }
}

