/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.goals.switchcombat;

import com.infamous.dungeons_mobs.interfaces.IShieldUser;
import com.infamous.dungeons_mobs.tags.CustomTags;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.util.Hand;

public class ShieldAndMeleeAttackGoal<T extends CreatureEntity>
extends MeleeAttackGoal {
    private final T hostCreature;
    private final int maxCloseQuartersShieldUseTime;
    private final int attackWindowTime;
    private int seeTime;
    private int closeQuartersShieldUseCounter;
    private final double closeQuartersRangeSq;

    public ShieldAndMeleeAttackGoal(T creatureEntity, double speedTowardsTarget, boolean useLongMemory, double closeQuartersRange, int maxCloseQuartersShieldUseTime, int attackWindowTime) {
        super(creatureEntity, speedTowardsTarget, useLongMemory);
        this.hostCreature = creatureEntity;
        this.closeQuartersRangeSq = closeQuartersRange * closeQuartersRange;
        this.maxCloseQuartersShieldUseTime = maxCloseQuartersShieldUseTime;
        this.attackWindowTime = attackWindowTime;
        this.closeQuartersShieldUseCounter = 0;
    }

    private boolean hasShieldInOffhand() {
        return this.hostCreature.func_184592_cb().isShield(this.hostCreature);
    }

    private void useShield() {
        if (this.hasShieldInOffhand() && !((IShieldUser)this.hostCreature).isShieldDisabled()) {
            this.hostCreature.func_184598_c(Hand.OFF_HAND);
        }
    }

    private void stopUsingShield() {
        if (this.hostCreature.func_184585_cz()) {
            this.hostCreature.func_184597_cx();
        }
    }

    public boolean func_75250_a() {
        if (this.hasShieldInOffhand() && !((IShieldUser)this.hostCreature).isShieldDisabled()) {
            LivingEntity attackTarget = this.hostCreature.func_70638_az();
            return attackTarget != null && attackTarget.func_70089_S();
        }
        return super.func_75250_a();
    }

    public void func_75249_e() {
        super.func_75249_e();
    }

    public boolean func_75253_b() {
        if (this.hasShieldInOffhand() && !((IShieldUser)this.hostCreature).isShieldDisabled()) {
            return this.func_75250_a();
        }
        return super.func_75253_b();
    }

    public void func_75251_c() {
        if (this.hasShieldInOffhand() && this.hostCreature.func_184585_cz()) {
            this.seeTime = 0;
            this.closeQuartersShieldUseCounter = 0;
            this.stopUsingShield();
        }
        super.func_75251_c();
    }

    public void func_75246_d() {
        LivingEntity attackTarget = this.hostCreature.func_70638_az();
        boolean dontShieldAgainst = attackTarget != null && attackTarget.func_200600_R().func_220341_a(CustomTags.DONT_SHIELD_AGAINST);
        boolean shieldDisabled = ((IShieldUser)this.hostCreature).isShieldDisabled();
        boolean hasShield = this.hasShieldInOffhand();
        if (hasShield && !shieldDisabled && attackTarget != null && !dontShieldAgainst) {
            boolean closeQuarters;
            double hostDistanceSq = this.hostCreature.func_70092_e(attackTarget.func_226277_ct_(), attackTarget.func_226278_cu_(), attackTarget.func_226281_cx_());
            double detectRange = this.hostCreature.func_233637_b_(Attributes.field_233819_b_);
            double detectRangeSq = detectRange * detectRange;
            boolean canSee = this.hostCreature.func_70635_at().func_75522_a((Entity)attackTarget);
            this.seeTime = canSee ? ++this.seeTime : 0;
            if (hostDistanceSq <= detectRangeSq && this.seeTime >= 5) {
                this.hostCreature.func_70661_as().func_75499_g();
            }
            boolean bl = closeQuarters = hostDistanceSq <= this.closeQuartersRangeSq;
            if (closeQuarters && this.hostCreature.func_184585_cz()) {
                ++this.closeQuartersShieldUseCounter;
            }
            if (this.closeQuartersShieldUseCounter >= this.maxCloseQuartersShieldUseTime) {
                this.closeQuartersShieldUseCounter = 0;
                this.stopUsingShield();
                ((IShieldUser)this.hostCreature).setShieldCooldownTime(this.attackWindowTime);
                return;
            }
            this.hostCreature.func_70671_ap().func_75651_a((Entity)attackTarget, 30.0f, 30.0f);
            if (!canSee) {
                this.stopUsingShield();
                return;
            }
            if (!this.hostCreature.func_184585_cz()) {
                this.useShield();
            }
        } else if (attackTarget != null) {
            this.closeQuartersShieldUseCounter = 0;
            super.func_75246_d();
        }
    }
}

