/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.goals.switchcombat;

import java.util.EnumSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.item.EggItem;
import net.minecraft.item.SnowballItem;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;

public class ThrowAndMeleeAttackGoal<T extends CreatureEntity>
extends MeleeAttackGoal {
    private final T hostCreature;
    private int rangedAttackTime = -1;
    private final double entityMoveSpeed;
    private int seeTime;
    private final int attackIntervalMin;
    private final int maxRangedAttackTime;
    private final float attackRadius;
    private final float maxAttackDistance;

    public ThrowAndMeleeAttackGoal(T rangedAttackMob, double speedAmplifier, int attackInterval, float maxDistance, boolean useLongMemory) {
        super(rangedAttackMob, speedAmplifier, useLongMemory);
        this.hostCreature = rangedAttackMob;
        this.entityMoveSpeed = speedAmplifier;
        this.attackIntervalMin = attackInterval;
        this.maxRangedAttackTime = attackInterval;
        this.attackRadius = maxDistance;
        this.maxAttackDistance = maxDistance * maxDistance;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        if (this.hasThrowableItemInMainhand()) {
            LivingEntity attackTarget = this.hostCreature.func_70638_az();
            return attackTarget != null && attackTarget.func_70089_S();
        }
        return super.func_75250_a();
    }

    private boolean hasThrowableItemInMainhand() {
        return this.hostCreature.func_184614_ca().func_77973_b() instanceof SnowballItem | this.hostCreature.func_184614_ca().func_77973_b() instanceof EggItem;
    }

    public boolean func_75253_b() {
        if (this.hasThrowableItemInMainhand()) {
            return this.func_75250_a() || !this.hostCreature.func_70661_as().func_75500_f();
        }
        return super.func_75253_b();
    }

    public void func_75251_c() {
        if (this.hasThrowableItemInMainhand()) {
            this.seeTime = 0;
            this.rangedAttackTime = -1;
        } else {
            super.func_75251_c();
        }
    }

    public void func_75246_d() {
        LivingEntity attackTarget = this.hostCreature.func_70638_az();
        if (this.hasThrowableItemInMainhand() && attackTarget != null) {
            double hostDistanceSq = this.hostCreature.func_70092_e(attackTarget.func_226277_ct_(), attackTarget.func_226278_cu_(), attackTarget.func_226281_cx_());
            boolean canSee = this.hostCreature.func_70635_at().func_75522_a((Entity)attackTarget);
            this.seeTime = canSee ? ++this.seeTime : 0;
            if (hostDistanceSq <= (double)this.maxAttackDistance && this.seeTime >= 5) {
                this.hostCreature.func_70661_as().func_75499_g();
            } else {
                this.hostCreature.func_70661_as().func_75497_a((Entity)attackTarget, this.entityMoveSpeed);
            }
            this.hostCreature.func_70671_ap().func_75651_a((Entity)attackTarget, 30.0f, 30.0f);
            if (--this.rangedAttackTime == 0) {
                if (!canSee) {
                    return;
                }
                float distanceOverAttackRadius = MathHelper.func_76133_a((double)hostDistanceSq) / this.attackRadius;
                float clampedDistanceOverAttackRadius = MathHelper.func_76131_a((float)distanceOverAttackRadius, (float)0.1f, (float)1.0f);
                if (this.hasThrowableItemInMainhand()) {
                    this.hostCreature.func_184609_a(Hand.MAIN_HAND);
                }
                ((IRangedAttackMob)this.hostCreature).func_82196_d(attackTarget, clampedDistanceOverAttackRadius);
                this.rangedAttackTime = MathHelper.func_76141_d((float)(distanceOverAttackRadius * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            } else if (this.rangedAttackTime < 0) {
                float distanceOverAttackRadius = MathHelper.func_76133_a((double)hostDistanceSq) / this.attackRadius;
                this.rangedAttackTime = MathHelper.func_76141_d((float)(distanceOverAttackRadius * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            }
        } else if (attackTarget != null) {
            super.func_75246_d();
        }
    }
}

