/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.items;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public abstract class AbstractStaffItem
extends Item {
    private static final double RAYTRACE_DISTANCE = 256.0;

    public AbstractStaffItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        BlockRayTraceResult blockRTR = (BlockRayTraceResult)player.func_213324_a(256.0, 1.0f, false);
        Vector3d eyeVector = player.func_174824_e(1.0f);
        Vector3d lookVector = player.func_70676_i(1.0f);
        Vector3d rayTraceVector = eyeVector.func_72441_c(lookVector.field_72450_a * 256.0, lookVector.field_72448_b * 256.0, lookVector.field_72449_c * 256.0);
        AxisAlignedBB rayTraceBoundingBox = player.func_174813_aQ().func_216361_a(lookVector.func_186678_a(256.0)).func_72314_b(1.0, 1.0, 1.0);
        EntityRayTraceResult entityRTR = ProjectileHelper.func_221269_a((World)world, (Entity)player, (Vector3d)eyeVector, (Vector3d)rayTraceVector, (AxisAlignedBB)rayTraceBoundingBox, entity -> entity instanceof LivingEntity && !entity.func_175149_v() && entity.func_70067_L());
        world.func_184133_a(player, player.func_233580_cy_(), SoundEvents.field_191244_bn, SoundCategory.PLAYERS, 1.0f, 1.0f);
        if (!world.func_201670_d()) {
            if (entityRTR != null) {
                Entity target = entityRTR.func_216348_a();
                this.activateStaff(player, target, itemStack, hand);
            } else {
                BlockPos pos = blockRTR.func_216350_a();
                this.activateStaff(player, pos, itemStack, hand);
            }
        }
        return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
    }

    protected abstract void activateStaff(PlayerEntity var1, Entity var2, ItemStack var3, Hand var4);

    protected abstract void activateStaff(PlayerEntity var1, BlockPos var2, ItemStack var3, Hand var4);

    public Rarity func_77613_e(ItemStack itemStack) {
        return Rarity.RARE;
    }
}

