/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.infamous.dungeons_mobs.mixin.BrainAccessor;
import com.mojang.datafixers.util.Pair;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.task.Task;

public class BrainHelper {
    public static <E extends LivingEntity> ImmutableList<? extends Pair<Integer, ? extends Task<? super E>>> createPriorityPairs(int priorityStart, ImmutableList<? extends Task<? super E>> tasks) {
        int priorityIndex = priorityStart;
        ImmutableList.Builder priorityPairs = ImmutableList.builder();
        for (Task task : tasks) {
            priorityPairs.add((Object)Pair.of((Object)priorityIndex++, (Object)task));
        }
        return priorityPairs.build();
    }

    public static <E extends LivingEntity> void addPrioritizedBehaviors(Activity activity, ImmutableList<? extends Pair<Integer, ? extends Task<? super E>>> prioritizedTasks, Brain<E> brain) {
        BrainAccessor<E> brainAccessor = BrainHelper.castToAccessor(brain);
        for (Pair pair : prioritizedTasks) {
            brainAccessor.getAvailableBehaviorsByPriority().computeIfAbsent((Integer)pair.getFirst(), p -> Maps.newHashMap()).computeIfAbsent(activity, a -> Sets.newLinkedHashSet()).add(pair.getSecond());
        }
    }

    public static <E extends LivingEntity> BrainAccessor<E> castToAccessor(Brain<E> brain) {
        return (BrainAccessor)brain;
    }
}

