/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus;

import com.legacy.dungeons_plus.DPConfig;
import com.legacy.dungeons_plus.DungeonsPlus;
import com.legacy.structure_gel.access_helpers.SpawnerAccessHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.Property;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.registries.ForgeRegistries;

public class DPUtil {
    public static void createChest(ICreateChest chestCreator, IServerWorld world, MutableBoundingBox bounds, Random rand, BlockPos pos, ResourceLocation lootTable, Rotation rotation, String[] data) {
        Direction facing;
        Direction direction = facing = data.length > 1 ? Direction.func_176739_a((String)data[1]) : Direction.NORTH;
        ChestType chestType = data.length > 2 ? (data[2].equals(ChestType.LEFT.func_176610_l()) ? ChestType.LEFT : (data[2].equals(ChestType.RIGHT.func_176610_l()) ? ChestType.RIGHT : ChestType.SINGLE)) : ChestType.SINGLE;
        DPUtil.createChest(chestCreator, world, bounds, rand, pos, lootTable, rotation, facing, chestType);
    }

    public static void createChest(ICreateChest chestCreator, IServerWorld world, MutableBoundingBox bounds, Random rand, BlockPos pos, ResourceLocation lootTable, Rotation rotation, Direction facing, ChestType chestType) {
        boolean waterlog = world.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a;
        BlockState chest = ((BlockState)((BlockState)((BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((Property)ChestBlock.field_176459_a, (Comparable)facing)).func_206870_a((Property)ChestBlock.field_196314_b, (Comparable)chestType)).func_206870_a((Property)ChestBlock.field_204511_c, (Comparable)Boolean.valueOf(waterlog))).rotate((IWorld)world, pos, rotation);
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        chestCreator.createChest(world, bounds, rand, pos, lootTable, chest);
        if (DungeonsPlus.isLootrLoaded) {
            LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)rand, (BlockPos)pos, (ResourceLocation)lootTable);
        }
    }

    public static void placeSpawner(String entity, IWorld world, BlockPos pos) {
        DPUtil.placeSpawner((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entity)), world, pos);
    }

    public static void placeSpawner(EntityType<?> entity, IWorld world, BlockPos pos) {
        DPUtil.placeSpawner(SpawnerAccessHelper.createSpawnerEntity(entity), world, pos);
    }

    public static void placeSpawner(WeightedSpawnerEntity spawnerEntity, IWorld world, BlockPos pos) {
        DPUtil.placeSpawner(Arrays.asList(spawnerEntity), world, pos);
    }

    public static void placeSpawner(List<WeightedSpawnerEntity> spawnerEntities, IWorld world, BlockPos pos) {
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        world.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 3);
        if (world.func_175625_s(pos) instanceof MobSpawnerTileEntity) {
            SpawnerAccessHelper.setSpawnPotentials((MobSpawnerTileEntity)((MobSpawnerTileEntity)world.func_175625_s(pos)), spawnerEntities);
        }
    }

    public static void placeMonsterBox(IServerWorld world, BlockPos pos, Random rand) {
        ResourceLocation boxLocation;
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        if (DungeonsPlus.isQuarkLoaded && rand.nextInt(100) < (Integer)DPConfig.COMMON.biggerDungeonMonsterBoxChance.get() && ForgeRegistries.BLOCKS.containsKey(boxLocation = new ResourceLocation("quark", "monster_box"))) {
            try {
                BlockState monsterBox = ((Block)ForgeRegistries.BLOCKS.getValue(boxLocation)).func_176223_P();
                world.func_180501_a(pos, monsterBox, 2);
            }
            catch (Throwable t) {
                DungeonsPlus.LOGGER.error(String.format("Failed to place monster box at (%d, %d, %d)", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
                DungeonsPlus.LOGGER.error((Object)t);
            }
        }
    }

    public static void placeWaystone(IServerWorld world, BlockPos pos, Random rand, @Nullable Block defaultBlock) {
        if (DungeonsPlus.isWaystonesLoaded && rand.nextInt(100) < (Integer)DPConfig.COMMON.towerWaystoneChance.get()) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            ResourceLocation waystoneLocation = new ResourceLocation("waystones", "waystone");
            if (ForgeRegistries.FEATURES.containsKey(waystoneLocation)) {
                try {
                    if (world instanceof ISeedReader) {
                        world.func_180501_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 2);
                        Feature waystoneFeature = (Feature)ForgeRegistries.FEATURES.getValue(waystoneLocation);
                        waystoneFeature.func_241855_a((ISeedReader)world, world.func_201672_e().func_72863_F().func_201711_g(), rand, pos, (IFeatureConfig)NoFeatureConfig.field_236559_b_);
                    }
                    return;
                }
                catch (Throwable t) {
                    DungeonsPlus.LOGGER.error(String.format("Failed to place waystone at (%d, %d, %d)", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
                    DungeonsPlus.LOGGER.error((Object)t);
                }
            }
        }
        world.func_180501_a(pos, (defaultBlock != null ? defaultBlock : Blocks.field_150350_a).func_176223_P(), 2);
    }

    public static interface ICreateChest {
        public boolean createChest(IServerWorld var1, MutableBoundingBox var2, Random var3, BlockPos var4, ResourceLocation var5, @Nullable BlockState var6);
    }
}

