/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.pieces;

import com.google.common.collect.ImmutableList;
import com.legacy.dungeons_plus.DPLoot;
import com.legacy.dungeons_plus.DPUtil;
import com.legacy.dungeons_plus.DungeonsPlus;
import com.legacy.structure_gel.access_helpers.SpawnerAccessHelper;
import com.legacy.structure_gel.worldgen.GelPlacementSettings;
import com.legacy.structure_gel.worldgen.processors.RandomBlockSwapProcessor;
import com.legacy.structure_gel.worldgen.structure.GelTemplateStructurePiece;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.RuleEntry;
import net.minecraft.world.gen.feature.template.RuleStructureProcessor;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class WarpedGardenPieces {
    private static final ResourceLocation[] FLOWERY = new ResourceLocation[]{WarpedGardenPieces.locate("flower_0"), WarpedGardenPieces.locate("flower_1"), WarpedGardenPieces.locate("flower_2"), WarpedGardenPieces.locate("flower_3")};
    private static final ResourceLocation[] LOOT = new ResourceLocation[]{WarpedGardenPieces.locate("portal"), WarpedGardenPieces.locate("ship"), WarpedGardenPieces.locate("nylium"), WarpedGardenPieces.locate("volcano")};
    private static final List<WeightedSpawnerEntity> SPAWNER_SPAWNS = new ArrayList<WeightedSpawnerEntity>();

    public static void assemble(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> structurePieces, Random rand) {
        structurePieces.add((StructurePiece)new Piece(templateManager, LOOT[rand.nextInt(LOOT.length)], pos.func_177982_a(rand.nextInt(3) - 1, 0, rand.nextInt(3) - 1), rotation));
        int offset = 20;
        List<BlockPos> positions = Arrays.asList(pos.func_177982_a(-offset, 0, rand.nextInt(7) - 3), pos.func_177982_a(offset, 0, rand.nextInt(7) - 3), pos.func_177982_a(rand.nextInt(7) - 3, 0, offset), pos.func_177982_a(rand.nextInt(7) - 3, 0, -offset));
        positions.forEach(p -> structurePieces.add((StructurePiece)new Piece(templateManager, WarpedGardenPieces.getRandomPiece(rand), (BlockPos)p, rotation)));
    }

    private static ResourceLocation locate(String name) {
        return DungeonsPlus.locate("warped_garden/" + name);
    }

    private static ResourceLocation getRandomPiece(Random rand) {
        int i = rand.nextInt(FLOWERY.length + LOOT.length);
        return i < FLOWERY.length ? FLOWERY[i] : LOOT[i - FLOWERY.length];
    }

    public static class Piece
    extends GelTemplateStructurePiece {
        public Piece(TemplateManager templateManager, ResourceLocation location, BlockPos pos, Rotation rotation) {
            super(DungeonsPlus.Structures.WARPED_GARDEN.getPieceType(), location, 0);
            this.field_186178_c = pos;
            this.field_186169_c = rotation;
            this.setupTemplate(templateManager);
        }

        public Piece(TemplateManager templateManager, CompoundNBT nbtCompound) {
            super(DungeonsPlus.Structures.WARPED_GARDEN.getPieceType(), nbtCompound);
            this.setupTemplate(templateManager);
        }

        public PlacementSettings createPlacementSettings(TemplateManager templateManager) {
            BlockPos sizePos = templateManager.func_200219_b(this.name).func_186259_a();
            BlockPos centerPos = new BlockPos(sizePos.func_177958_n() / 2, 0, sizePos.func_177952_p() / 2);
            return new GelPlacementSettings().setMaintainWater(false).func_186220_a(this.field_186169_c).func_186214_a(Mirror.NONE).func_207665_a(centerPos);
        }

        public void addProcessors(TemplateManager templateManager, PlacementSettings placementSettings) {
            super.addProcessors(templateManager, placementSettings);
            placementSettings.func_215222_a((StructureProcessor)new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_196820_gu), (RuleTest)new BlockMatchRuleTest(Blocks.field_150355_j), Blocks.field_150355_j.func_176223_P()))));
            placementSettings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(Blocks.field_196820_gu, Blocks.field_150350_a));
            placementSettings.func_215222_a((StructureProcessor)new RandomBlockSwapProcessor(Blocks.field_150343_Z, 0.35f, Blocks.field_235399_ni_));
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager structureManager, ChunkGenerator chunkGen, Random rand, MutableBoundingBox bounds, ChunkPos chunkPos, BlockPos pos) {
            int y = world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, this.field_186178_c.func_177958_n() + 6, this.field_186178_c.func_177952_p() + 6);
            this.field_186178_c = new BlockPos(this.field_186178_c.func_177958_n(), y, this.field_186178_c.func_177952_p());
            if (this.field_186178_c.func_177956_o() + this.field_186176_a.func_186259_a().func_177956_o() > 60) {
                this.field_186178_c = new BlockPos(this.field_186178_c.func_177958_n(), 60 - this.field_186176_a.func_186259_a().func_177956_o(), this.field_186178_c.func_177952_p());
            }
            return super.func_230383_a_(world, structureManager, chunkGen, rand, bounds, chunkPos, pos);
        }

        protected void func_186175_a(String key, BlockPos pos, IServerWorld world, Random rand, MutableBoundingBox bounds) {
            if (key.contains("chest")) {
                String[] data = key.split("-");
                DPUtil.createChest((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ((Piece)this).func_191080_a(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5), world, bounds, rand, pos, DPLoot.WarpedGarden.CHEST_COMMON, this.field_186169_c, data);
            }
            if (key.equals("spawner")) {
                if (SPAWNER_SPAWNS.isEmpty()) {
                    CompoundNBT goldAxeNBT = new ItemStack((IItemProvider)Items.field_151006_E).func_77955_b(new CompoundNBT());
                    goldAxeNBT.func_74768_a("Damage", 10);
                    for (Block coral : BlockTags.field_205598_B.func_230236_b_()) {
                        CompoundNBT entityNBT = new CompoundNBT();
                        ListNBT handItems = new ListNBT();
                        handItems.add((Object)goldAxeNBT);
                        handItems.add((Object)new ItemStack((IItemProvider)coral).func_77955_b(new CompoundNBT()));
                        entityNBT.func_218657_a("HandItems", (INBT)handItems);
                        ListNBT handDropChances = new ListNBT();
                        handDropChances.add((Object)FloatNBT.func_229689_a_((float)0.085f));
                        handDropChances.add((Object)FloatNBT.func_229689_a_((float)1.0f));
                        entityNBT.func_218657_a("HandDropChances", (INBT)handDropChances);
                        SPAWNER_SPAWNS.add(SpawnerAccessHelper.createSpawnerEntity((int)1, (EntityType)EntityType.field_204724_o, (CompoundNBT)entityNBT));
                    }
                    CompoundNBT entityNBT = new CompoundNBT();
                    ListNBT handItems = new ListNBT();
                    handItems.add((Object)goldAxeNBT);
                    entityNBT.func_218657_a("HandItems", (INBT)handItems);
                    int coralCount = BlockTags.field_205598_B.func_230236_b_().size();
                    SPAWNER_SPAWNS.add(SpawnerAccessHelper.createSpawnerEntity((int)(coralCount == 0 ? 1 : coralCount * 5), (EntityType)EntityType.field_204724_o, (CompoundNBT)entityNBT));
                }
                Collections.shuffle(SPAWNER_SPAWNS, rand);
                DPUtil.placeSpawner(SPAWNER_SPAWNS, (IWorld)world, pos);
            }
            if (key.equals("drowned")) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                DrownedEntity drowned = (DrownedEntity)EntityType.field_204724_o.func_200721_a((World)world.func_201672_e());
                ItemStack goldAxe = new ItemStack((IItemProvider)Items.field_151006_E);
                goldAxe.func_196085_b(10);
                drowned.func_184201_a(EquipmentSlotType.MAINHAND, goldAxe);
                drowned.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)Items.field_190931_a));
                drowned.func_110163_bv();
                drowned.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                world.func_217376_c((Entity)drowned);
            }
        }
    }
}

