/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.event;

import baguchan.earthmobsmod.EarthConfig;
import baguchan.earthmobsmod.init.EarthBlocks;
import baguchan.earthmobsmod.init.EarthEntitys;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="earthmobsmod")
public class BiomeLoadHandler {
    public static final ConfiguredFeature<?, ?> LAKE_MUD = BiomeLoadHandler.register("earthmobsmod:mud_lake", Feature.field_202289_ai.func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(EarthBlocks.MUDWATER.func_176223_P())).func_227228_a_(Placement.field_215006_E.func_227446_a_((IPlacementConfig)new ChanceConfig(4))));

    private static <FC extends IFeatureConfig> ConfiguredFeature<FC, ?> register(String key, ConfiguredFeature<FC, ?> configuredFeature) {
        return (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)key, configuredFeature);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void loadingBiome(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        RegistryKey biome = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)event.getName());
        if (event.getName().toString().contains("minecraft:flower_forest") && EarthConfig.spawnEarthMobsMoobloom && !ModList.get().isLoaded("buzzier_bees")) {
            event.getSpawns().getSpawner(EntityClassification.CREATURE).add(new MobSpawnInfo.Spawners(EarthEntitys.MOOBLOOM, 10, 2, 3));
        }
        if (event.getName().toString().contains("minecraft:mushroom_fields")) {
            event.getSpawns().getSpawner(EntityClassification.CREATURE).add(new MobSpawnInfo.Spawners(EarthEntitys.CLUCKSHROOM, 8, 2, 3));
        }
        if (BiomeDictionary.hasType((RegistryKey)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OVERWORLD) && !BiomeDictionary.hasType((RegistryKey)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
            if (BiomeDictionary.hasType((RegistryKey)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.LAKES, LAKE_MUD);
                event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners(EarthEntitys.LOBBER_ZOMBIE, 25, 2, 4));
            } else {
                event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners(EarthEntitys.LOBBER_ZOMBIE, 5, 2, 4));
            }
            if (BiomeDictionary.hasType((RegistryKey)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN)) {
                event.getSpawns().getSpawner(EntityClassification.CREATURE).add(new MobSpawnInfo.Spawners(EarthEntitys.WOOLY_COW, 10, 2, 3));
                event.getSpawns().getSpawner(EntityClassification.CREATURE).add(new MobSpawnInfo.Spawners(EarthEntitys.HORNED_SHEEP, 10, 2, 3));
                event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners(EarthEntitys.BOULDERING_ZOMBIE, 5, 2, 4));
            }
            if (BiomeDictionary.hasType((RegistryKey)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) && BiomeDictionary.hasType((RegistryKey)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
                event.getSpawns().getSpawner(EntityClassification.CREATURE).add(new MobSpawnInfo.Spawners(EarthEntitys.JOLLY_LLAMA, 6, 3, 4));
            }
            if (BiomeDictionary.hasType((RegistryKey)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY)) {
                event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners(EarthEntitys.BONE_SPIDER, 40, 2, 3));
            }
        }
    }
}

