/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.common.blocks;

import com.google.common.collect.Maps;
import com.minecraftabnormals.endergetic.common.blocks.CorrockBlock;
import com.minecraftabnormals.endergetic.common.blocks.CorrockCrownBlock;
import com.minecraftabnormals.endergetic.core.events.EntityEvents;
import com.minecraftabnormals.endergetic.core.registry.EEBlocks;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;

public class CorrockCrownStandingBlock
extends CorrockCrownBlock {
    private static final Map<DimensionType, Supplier<CorrockCrownBlock>> CONVERSIONS = (Map)Util.func_200696_a((Object)Maps.newHashMap(), conversions -> {
        conversions.put(CorrockBlock.DimensionTypeAccessor.OVERWORLD, EEBlocks.CORROCK_CROWN_OVERWORLD_STANDING);
        conversions.put(CorrockBlock.DimensionTypeAccessor.THE_NETHER, EEBlocks.CORROCK_CROWN_NETHER_STANDING);
        conversions.put(CorrockBlock.DimensionTypeAccessor.THE_END, EEBlocks.CORROCK_CROWN_END_STANDING);
    });
    public static final IntegerProperty ROTATION = BlockStateProperties.field_208138_am;
    public static final BooleanProperty UPSIDE_DOWN = BooleanProperty.func_177716_a((String)"upside_down");

    public CorrockCrownStandingBlock(AbstractBlock.Properties properties, boolean petrified) {
        super(properties, petrified);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(0))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (Boolean)state.func_177229_b((Property)UPSIDE_DOWN) != false ? Block.func_208617_a((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0) : Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (this.shouldConvert((IWorld)world)) {
            world.func_175656_a(pos, (BlockState)((BlockState)((CorrockCrownBlock)((Object)((Supplier)CONVERSIONS.getOrDefault(world.func_230315_m_(), (Supplier<CorrockCrownBlock>)EEBlocks.CORROCK_CROWN_OVERWORLD_STANDING)).get())).func_176223_P().func_206870_a((Property)ROTATION, world.func_180495_p(pos).func_177229_b((Property)ROTATION))).func_206870_a((Property)UPSIDE_DOWN, world.func_180495_p(pos).func_177229_b((Property)UPSIDE_DOWN)));
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)UPSIDE_DOWN) != false ? worldIn.func_180495_p(pos.func_177984_a()).func_224755_d((IBlockReader)worldIn, pos.func_177984_a(), Direction.DOWN) : worldIn.func_180495_p(pos.func_177977_b()).func_224755_d((IBlockReader)worldIn, pos.func_177977_b(), Direction.UP);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
            if (!this.petrified) {
                return EntityEvents.convertCorrockBlock(stateIn);
            }
        }
        if (this.shouldConvert(worldIn)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 60 + worldIn.func_201674_k().nextInt(40));
        }
        return this.func_196260_a(stateIn, (IWorldReader)worldIn, currentPos) ? stateIn : Blocks.field_150350_a.func_176223_P();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        Direction direction = context.func_196000_l();
        if (this.shouldConvert((IWorld)context.func_195991_k())) {
            context.func_195991_k().func_205220_G_().func_205360_a(context.func_195995_a(), (Object)this, 60 + context.func_195991_k().func_201674_k().nextInt(40));
        }
        if (context.func_195991_k().func_180495_p(context.func_195995_a().func_177977_b()).func_177230_c() instanceof CorrockCrownStandingBlock) {
            return null;
        }
        return direction == Direction.UP ? (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(MathHelper.func_76128_c((double)((double)((180.0f + context.func_195990_h()) * 16.0f / 360.0f) + 0.5)) & 0xF))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206884_a((ITag)FluidTags.field_206959_a) && ifluidstate.func_206882_g() >= 8)) : (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(MathHelper.func_76128_c((double)((double)((180.0f + context.func_195990_h()) * 16.0f / 360.0f) + 0.5)) & 0xF))).func_206870_a((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206884_a((ITag)FluidTags.field_206959_a) && ifluidstate.func_206882_g() >= 8));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(rot.func_185833_a(((Integer)state.func_177229_b((Property)ROTATION)).intValue(), 16)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return (BlockState)state.func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(mirrorIn.func_185802_a(((Integer)state.func_177229_b((Property)ROTATION)).intValue(), 16)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{ROTATION, WATERLOGGED, UPSIDE_DOWN});
    }

    private boolean shouldConvert(IWorld world) {
        return !this.petrified && ((Supplier)CONVERSIONS.getOrDefault(world.func_230315_m_(), (Supplier<CorrockCrownBlock>)EEBlocks.CORROCK_CROWN_OVERWORLD_STANDING)).get() != this;
    }
}

