/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.common.world.features.corrock;

import com.minecraftabnormals.endergetic.common.blocks.CorrockCrownBlock;
import com.minecraftabnormals.endergetic.common.blocks.CorrockPlantBlock;
import com.minecraftabnormals.endergetic.common.world.features.corrock.AbstractCorrockFeature;
import com.minecraftabnormals.endergetic.core.registry.EEBlocks;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import org.apache.commons.lang3.ArrayUtils;

public class CorrockShelfFeature
extends AbstractCorrockFeature<ProbabilityConfig> {
    private static final Direction[] DIRECTIONS = CorrockShelfFeature.getDirections(false);
    private static final Direction[] DIRECTIONS_REVERSED = CorrockShelfFeature.getDirections(true);

    public CorrockShelfFeature(Codec<ProbabilityConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, ProbabilityConfig config) {
        if (world.func_175623_d(pos) && world.func_180495_p(pos.func_177984_a()).func_177230_c() != CORROCK_BLOCK_BLOCK && CorrockShelfFeature.isTouchingWall(world, pos)) {
            int size = rand.nextBoolean() ? 3 : 4;
            int edgeBias = 10;
            CorrockShelfFeature.generateShelf(world, rand, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), size, edgeBias, rand.nextInt(2) + 2, rand.nextInt(2) + 2, config.field_203622_a);
            BlockPos.Mutable mutable = new BlockPos.Mutable();
            BlockState corrockState = (BlockState)CORROCK_STATE.func_179281_c();
            for (int i = 0; i < 16; ++i) {
                if (!(rand.nextFloat() < 0.4f) || !world.func_175623_d((BlockPos)mutable.func_239621_a_((Vector3i)pos, rand.nextInt(size) - rand.nextInt(size), 1, rand.nextInt(size) - rand.nextInt(size))) || world.func_180495_p(mutable.func_177977_b()).func_177230_c() != CORROCK_BLOCK_BLOCK) continue;
                world.func_180501_a((BlockPos)mutable, corrockState, 2);
            }
            return true;
        }
        return false;
    }

    private static Direction[] getDirections(boolean reversed) {
        Object[] directions = (Direction[])Direction.Plane.HORIZONTAL.func_239636_a_().toArray(Direction[]::new);
        if (reversed) {
            ArrayUtils.reverse((Object[])directions);
        }
        return directions;
    }

    private static boolean isTouchingWall(ISeedReader world, BlockPos origin) {
        for (Direction direction : DIRECTIONS) {
            if (!CorrockShelfFeature.searchForWall(world, origin.func_239590_i_(), direction) || !CorrockShelfFeature.searchForWall(world, origin.func_239590_i_().func_189536_c(direction.func_176746_e()), direction) || !CorrockShelfFeature.searchForWall(world, origin.func_239590_i_().func_189536_c(direction.func_176735_f()), direction)) continue;
            return true;
        }
        return false;
    }

    private static boolean searchForWall(ISeedReader world, BlockPos.Mutable mutable, Direction facing) {
        for (int i = 0; i < 2; ++i) {
            Block block = world.func_180495_p((BlockPos)mutable.func_189536_c(facing)).func_177230_c();
            if (block != Blocks.field_150377_bs && block != CORROCK_BLOCK_BLOCK && block != EEBlocks.EUMUS.get()) continue;
            return true;
        }
        return false;
    }

    private static void generateShelf(ISeedReader world, Random rand, int originX, int originY, int originZ, int size, int edgeBias, float underXDistance, float underZDistance, float crownChance) {
        int min = -(size / edgeBias + size);
        int max = size / edgeBias + size;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        BlockState corrockBlockState = (BlockState)CORROCK_BLOCK_STATE.func_179281_c();
        ArrayList<BlockPos> wallCrowns = new ArrayList<BlockPos>();
        for (int x = min; x <= max; ++x) {
            for (int z = min; z <= max; ++z) {
                double radiusMinusOne;
                BlockPos down;
                double radius;
                int distance;
                mutable.func_181079_c(originX + x, originY, originZ + z);
                if (!CorrockShelfFeature.canReplace(world, (BlockPos)mutable) || !((double)(distance = x * x + z * z) < (radius = (Math.cos(4.0 * Math.atan2(z, x)) / (double)edgeBias + 1.0) * (double)size) * radius)) continue;
                world.func_180501_a((BlockPos)mutable, corrockBlockState, 2);
                if ((double)(x * x) < (radius - (double)underXDistance) * (radius - (double)underXDistance) && (double)(z * z) < (radius - (double)underZDistance) * (radius - (double)underZDistance) && CorrockShelfFeature.canReplace(world, down = mutable.func_177977_b())) {
                    world.func_180501_a(down, corrockBlockState, 2);
                }
                if (!(rand.nextFloat() < crownChance) || !((double)distance > (radiusMinusOne = radius - 1.0) * radiusMinusOne)) continue;
                if (rand.nextBoolean()) {
                    BlockPos up = mutable.func_177984_a();
                    if (!CorrockShelfFeature.canReplace(world, up)) continue;
                    world.func_180501_a(up, CorrockShelfFeature.getCorrockCrownStanding(rand.nextInt(16)), 2);
                    continue;
                }
                wallCrowns.add(mutable.func_185334_h());
            }
        }
        block2: for (BlockPos pos : wallCrowns) {
            Direction[] directions;
            int crownsPlaced = 0;
            for (Direction direction : directions = rand.nextBoolean() ? DIRECTIONS : DIRECTIONS_REVERSED) {
                BlockPos offset = pos.func_177972_a(direction);
                if (!CorrockShelfFeature.canReplace(world, offset)) continue;
                world.func_180501_a(offset, CorrockShelfFeature.getCorrockCrownWall(direction), 2);
                if (rand.nextFloat() > crownChance || crownsPlaced++ == 1) continue block2;
            }
        }
    }

    private static boolean canReplace(ISeedReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_185904_a().func_76222_j() || state.func_177230_c() instanceof CorrockPlantBlock || state.func_177230_c() instanceof CorrockCrownBlock;
    }
}

