/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.common.world.features.corrock.tower;

import com.minecraftabnormals.abnormals_core.core.util.GenerationPiece;
import com.minecraftabnormals.endergetic.common.world.features.corrock.AbstractCorrockFeature;
import com.minecraftabnormals.endergetic.core.registry.EEBlocks;
import com.mojang.serialization.Codec;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ProbabilityConfig;

public final class SmallCorrockTowerFeature
extends AbstractCorrockFeature<ProbabilityConfig> {
    public SmallCorrockTowerFeature(Codec<ProbabilityConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, ProbabilityConfig config) {
        GenerationPiece base;
        Block belowBlock = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (world.func_175623_d(pos) && belowBlock == EEBlocks.CORROCK_END_BLOCK.get() && (base = SmallCorrockTowerFeature.getBase((IWorld)world, pos, rand)) != null) {
            float crownChance = config.field_203622_a;
            BlockState corrockBlockState = (BlockState)CORROCK_BLOCK_STATE.func_179281_c();
            GenerationPiece topPiece = new GenerationPiece((w, p) -> w.func_175623_d(p.pos));
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    BlockPos placingPos = pos.func_177982_a(x, 1, z);
                    topPiece.addBlockPiece(corrockBlockState, placingPos);
                    if (!(rand.nextFloat() < crownChance)) continue;
                    topPiece.addBlockPiece(SmallCorrockTowerFeature.getCorrockCrownStanding(rand.nextInt(16)), placingPos.func_177984_a());
                }
            }
            float increasedCrownChance = crownChance + 0.05f;
            for (Direction horizontal : Direction.Plane.HORIZONTAL) {
                BlockPos sidePos = pos.func_177981_b(2).func_177967_a(horizontal, 2);
                BlockPos rightPos = sidePos.func_177972_a(horizontal.func_176746_e());
                BlockPos leftPos = sidePos.func_177972_a(horizontal.func_176735_f());
                topPiece.addBlockPiece(corrockBlockState, sidePos);
                if (rand.nextFloat() < increasedCrownChance) {
                    topPiece.addBlockPiece(SmallCorrockTowerFeature.getCorrockCrownStanding(rand.nextInt(16)), sidePos.func_177984_a());
                }
                topPiece.addBlockPiece(corrockBlockState, rightPos);
                if (rand.nextFloat() < increasedCrownChance) {
                    topPiece.addBlockPiece(SmallCorrockTowerFeature.getCorrockCrownStanding(rand.nextInt(16)), rightPos.func_177984_a());
                }
                topPiece.addBlockPiece(corrockBlockState, leftPos);
                if (!(rand.nextFloat() < increasedCrownChance)) continue;
                topPiece.addBlockPiece(SmallCorrockTowerFeature.getCorrockCrownStanding(rand.nextInt(16)), leftPos.func_177984_a());
            }
            if (topPiece.canPlace((IWorld)world)) {
                base.place((IWorld)world);
                topPiece.place((IWorld)world);
                world.func_180501_a(pos, corrockBlockState, 2);
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static GenerationPiece getBase(IWorld world, BlockPos pos, Random rand) {
        int successfulSides = 0;
        GenerationPiece piece = new GenerationPiece((w, p) -> w.func_175623_d(p.pos) && Block.func_220064_c((IBlockReader)w, (BlockPos)p.pos.func_177977_b()));
        BlockState corrockBlockState = (BlockState)CORROCK_BLOCK_STATE.func_179281_c();
        for (Direction horizontal : Direction.Plane.HORIZONTAL) {
            BlockPos offset;
            int length = 0;
            for (int i = 1; i < 3 && world.func_175623_d(offset = pos.func_177967_a(horizontal, i)) && Block.func_220064_c((IBlockReader)world, (BlockPos)offset.func_177977_b()); ++i) {
                ++length;
            }
            if (length <= 0) continue;
            for (int i2 = 1; i2 < length + 1; ++i2) {
                piece.addBlockPiece(corrockBlockState, pos.func_177967_a(horizontal, i2));
            }
            ++successfulSides;
        }
        return successfulSides >= 2 ? piece : null;
    }
}

