/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.core.events;

import com.google.common.collect.Maps;
import com.minecraftabnormals.abnormals_core.client.ClientInfo;
import com.minecraftabnormals.abnormals_core.core.util.EntityUtil;
import com.minecraftabnormals.endergetic.common.advancement.EECriteriaTriggers;
import com.minecraftabnormals.endergetic.common.blocks.CorrockBlock;
import com.minecraftabnormals.endergetic.common.blocks.CorrockCrownBlock;
import com.minecraftabnormals.endergetic.common.blocks.CorrockCrownStandingBlock;
import com.minecraftabnormals.endergetic.common.blocks.CorrockCrownWallBlock;
import com.minecraftabnormals.endergetic.common.blocks.CorrockPlantBlock;
import com.minecraftabnormals.endergetic.common.entities.bolloom.BolloomBalloonEntity;
import com.minecraftabnormals.endergetic.common.items.BolloomBalloonItem;
import com.minecraftabnormals.endergetic.common.network.entity.S2CUpdateBalloonsMessage;
import com.minecraftabnormals.endergetic.core.EndergeticExpansion;
import com.minecraftabnormals.endergetic.core.interfaces.BalloonHolder;
import com.minecraftabnormals.endergetic.core.registry.EEBlocks;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShovelItem;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="endergetic")
public final class EntityEvents {
    private static final AttributeModifier SLOW_BALLOON = new AttributeModifier(UUID.fromString("eb2242e0-d3be-11ea-87d0-0242ac130003"), "Slow falling acceleration reduction", -0.07, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier SUPER_SLOW_BALLOON = new AttributeModifier(UUID.fromString("b5c9b111-62b3-40da-b396-f90a138583ad"), "Super slow falling acceleration reduction", -0.075, AttributeModifier.Operation.ADDITION);
    public static final Map<Supplier<Block>, Supplier<Block>> PETRIFICATION_MAP = (Map)Util.func_200696_a((Object)Maps.newHashMap(), petrifications -> {
        petrifications.put(EEBlocks.CORROCK_END, EEBlocks.PETRIFIED_CORROCK_END);
        petrifications.put(EEBlocks.CORROCK_NETHER, EEBlocks.PETRIFIED_CORROCK_NETHER);
        petrifications.put(EEBlocks.CORROCK_OVERWORLD, EEBlocks.PETRIFIED_CORROCK_OVERWORLD);
        petrifications.put(EEBlocks.CORROCK_END_BLOCK, EEBlocks.PETRIFIED_CORROCK_END_BLOCK);
        petrifications.put(EEBlocks.CORROCK_NETHER_BLOCK, EEBlocks.PETRIFIED_CORROCK_NETHER_BLOCK);
        petrifications.put(EEBlocks.CORROCK_OVERWORLD_BLOCK, EEBlocks.PETRIFIED_CORROCK_OVERWORLD_BLOCK);
        petrifications.put(() -> EEBlocks.CORROCK_CROWN_END_STANDING.get(), () -> EEBlocks.PETRIFIED_CORROCK_CROWN_END_STANDING.get());
        petrifications.put(() -> EEBlocks.CORROCK_CROWN_NETHER_STANDING.get(), () -> EEBlocks.PETRIFIED_CORROCK_CROWN_NETHER_STANDING.get());
        petrifications.put(() -> EEBlocks.CORROCK_CROWN_OVERWORLD_STANDING.get(), () -> EEBlocks.PETRIFIED_CORROCK_CROWN_OVERWORLD_STANDING.get());
        petrifications.put(() -> EEBlocks.CORROCK_CROWN_END_WALL.get(), () -> EEBlocks.PETRIFIED_CORROCK_CROWN_END_WALL.get());
        petrifications.put(() -> EEBlocks.CORROCK_CROWN_NETHER_WALL.get(), () -> EEBlocks.PETRIFIED_CORROCK_CROWN_NETHER_WALL.get());
        petrifications.put(() -> EEBlocks.CORROCK_CROWN_OVERWORLD_WALL.get(), () -> EEBlocks.PETRIFIED_CORROCK_CROWN_OVERWORLD_WALL.get());
    });

    @SubscribeEvent
    public static void onThrowableImpact(ProjectileImpactEvent.Throwable event) {
        ThrowableEntity projectileEntity = event.getThrowable();
        if (projectileEntity instanceof PotionEntity) {
            PotionEntity potionEntity = (PotionEntity)projectileEntity;
            ItemStack itemstack = potionEntity.func_184543_l();
            Potion potion = PotionUtils.func_185191_c((ItemStack)itemstack);
            List list = PotionUtils.func_185189_a((ItemStack)itemstack);
            if (potion == Potions.field_185230_b && list.isEmpty() && event.getRayTraceResult() instanceof BlockRayTraceResult) {
                World world = potionEntity.field_70170_p;
                BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)event.getRayTraceResult();
                Direction direction = blockraytraceresult.func_216354_b();
                BlockPos blockpos = blockraytraceresult.func_216350_a().func_177972_a(Direction.DOWN).func_177972_a(direction);
                EntityEvents.tryToConvertCorrockBlock(world, blockpos);
                EntityEvents.tryToConvertCorrockBlock(world, blockpos.func_177972_a(direction.func_176734_d()));
                for (Direction horizontals : Direction.Plane.HORIZONTAL) {
                    EntityEvents.tryToConvertCorrockBlock(world, blockpos.func_177972_a(horizontals));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (!entity.field_70170_p.field_72995_K) {
            boolean isFalling;
            boolean hasABalloon;
            int balloonCount = ((BalloonHolder)entity).getBalloons().size();
            ModifiableAttributeInstance gravity = entity.func_110148_a((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            boolean bl = hasABalloon = balloonCount > 0;
            if (hasABalloon) {
                entity.field_70143_R = 0.0f;
            }
            boolean bl2 = isFalling = entity.func_213322_ci().field_72448_b <= 0.0;
            if (isFalling && balloonCount < 3 && hasABalloon) {
                if (!gravity.func_180374_a(SLOW_BALLOON)) {
                    gravity.func_233767_b_(SLOW_BALLOON);
                }
            } else if (gravity.func_180374_a(SLOW_BALLOON)) {
                gravity.func_111124_b(SLOW_BALLOON);
            }
            if (isFalling && balloonCount == 3) {
                if (!gravity.func_180374_a(SUPER_SLOW_BALLOON)) {
                    gravity.func_233767_b_(SUPER_SLOW_BALLOON);
                }
            } else if (gravity.func_180374_a(SUPER_SLOW_BALLOON)) {
                gravity.func_111124_b(SUPER_SLOW_BALLOON);
            }
            if (balloonCount > 3) {
                entity.func_195064_c(new EffectInstance(Effects.field_188424_y, 2, balloonCount - 4, false, false, false));
                if (entity instanceof ServerPlayerEntity) {
                    EECriteriaTriggers.UP_UP_AND_AWAY.trigger((ServerPlayerEntity)entity);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityTracked(PlayerEvent.StartTracking event) {
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        Entity trackingEntity = event.getTarget();
        if (trackingEntity instanceof BolloomBalloonEntity) {
            BolloomBalloonEntity balloon = (BolloomBalloonEntity)trackingEntity;
            Entity attachedEntity = balloon.getAttachedEntity();
            if (attachedEntity != null) {
                EndergeticExpansion.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CUpdateBalloonsMessage(attachedEntity));
            }
        } else {
            EndergeticExpansion.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CUpdateBalloonsMessage(trackingEntity));
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        BalloonHolder holder = (BalloonHolder)event.getPlayer();
        if (!holder.getBalloons().isEmpty()) {
            holder.detachBalloons();
        }
    }

    @SubscribeEvent
    public static void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        BlockState state = world.func_180495_p(pos);
        PlayerEntity player = event.getPlayer();
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        Hand hand = event.getHand();
        if (event.getFace() != Direction.DOWN && item instanceof ShovelItem && !player.func_175149_v()) {
            BlockState newState;
            Object object = state.func_203425_a((Block)EEBlocks.POISMOSS.get()) ? ((Block)EEBlocks.POISMOSS_PATH.get()).func_176223_P() : (newState = state.func_203425_a((Block)EEBlocks.EUMUS_POISMOSS.get()) ? ((Block)EEBlocks.EUMUS_POISMOSS_PATH.get()).func_176223_P() : null);
            if (newState != null && world.func_175623_d(pos.func_177984_a())) {
                world.func_184133_a(player, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                world.func_180501_a(pos, newState, 11);
                event.getItemStack().func_222118_a(1, (LivingEntity)player, damage -> damage.func_213334_d(hand));
                event.setCancellationResult(ActionResultType.func_233537_a_((boolean)world.func_201670_d()));
                event.setCanceled(true);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onPlayerSwing(InputEvent.ClickInputEvent event) {
        if (event.isAttack()) {
            List<BolloomBalloonEntity> balloons;
            ClientPlayerEntity player = ClientInfo.getClientPlayer();
            if (player.field_70125_A > -25.0f) {
                return;
            }
            Entity ridingEntity = player.func_184187_bx();
            if (ridingEntity instanceof BoatEntity && BolloomBalloonItem.hasNoEntityTarget((PlayerEntity)player) && EntityUtil.rayTrace((Entity)player, (double)BolloomBalloonItem.getPlayerReach((PlayerEntity)player), (float)1.0f).func_216346_c() == RayTraceResult.Type.MISS && !(balloons = ((BalloonHolder)ridingEntity).getBalloons()).isEmpty()) {
                Minecraft.func_71410_x().field_71442_b.func_78764_a((PlayerEntity)player, (Entity)balloons.get(player.func_70681_au().nextInt(balloons.size())));
                event.setSwingHand(true);
            }
        }
    }

    private static void tryToConvertCorrockBlock(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof CorrockPlantBlock && !((CorrockPlantBlock)block).petrified || block instanceof CorrockBlock && !((CorrockBlock)block).petrified || block instanceof CorrockCrownBlock && !((CorrockCrownBlock)block).petrified) {
            world.func_175656_a(pos, EntityEvents.convertCorrockBlock(state));
        }
    }

    public static BlockState convertCorrockBlock(BlockState state) {
        Block block = state.func_177230_c();
        for (Map.Entry<Supplier<Block>, Supplier<Block>> entries : PETRIFICATION_MAP.entrySet()) {
            Block petrifiedBlock = entries.getValue().get();
            if (entries.getKey().get() != block) continue;
            if (block instanceof CorrockPlantBlock) {
                return (BlockState)petrifiedBlock.func_176223_P().func_206870_a((Property)CorrockPlantBlock.WATERLOGGED, state.func_177229_b((Property)CorrockPlantBlock.WATERLOGGED));
            }
            if (block instanceof CorrockBlock) {
                return petrifiedBlock.func_176223_P();
            }
            if (block instanceof CorrockCrownStandingBlock) {
                return (BlockState)((BlockState)((BlockState)petrifiedBlock.func_176223_P().func_206870_a((Property)CorrockCrownStandingBlock.ROTATION, state.func_177229_b((Property)CorrockCrownStandingBlock.ROTATION))).func_206870_a((Property)CorrockCrownStandingBlock.UPSIDE_DOWN, state.func_177229_b((Property)CorrockCrownStandingBlock.UPSIDE_DOWN))).func_206870_a((Property)CorrockCrownStandingBlock.WATERLOGGED, state.func_177229_b((Property)CorrockCrownStandingBlock.WATERLOGGED));
            }
            return (BlockState)((BlockState)petrifiedBlock.func_176223_P().func_206870_a((Property)CorrockCrownWallBlock.WATERLOGGED, state.func_177229_b((Property)CorrockCrownWallBlock.WATERLOGGED))).func_206870_a((Property)CorrockCrownWallBlock.FACING, state.func_177229_b((Property)CorrockCrownWallBlock.FACING));
        }
        return null;
    }
}

