/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.core.mixin;

import com.minecraftabnormals.endergetic.common.entities.bolloom.BolloomBalloonEntity;
import com.minecraftabnormals.endergetic.common.network.entity.S2CUpdateBalloonsMessage;
import com.minecraftabnormals.endergetic.core.EndergeticExpansion;
import com.minecraftabnormals.endergetic.core.interfaces.BalloonHolder;
import java.io.File;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.PlayerData;
import net.minecraftforge.fml.network.PacketDistributor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerList.class})
public final class PlayerListMixin {
    @Shadow
    @Final
    private PlayerData field_72412_k;
    @Shadow
    @Final
    private MinecraftServer field_72400_f;

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;save(Lnet/minecraft/entity/player/ServerPlayerEntity;)V", shift=At.Shift.AFTER)}, method={"remove"})
    private void removeBalloons(ServerPlayerEntity player, CallbackInfo info) {
        List<BolloomBalloonEntity> balloons = ((BalloonHolder)player).getBalloons();
        if (!balloons.isEmpty()) {
            ServerWorld serverWorld = (ServerWorld)player.field_70170_p;
            for (BolloomBalloonEntity balloon : balloons) {
                serverWorld.func_217467_h((Entity)balloon);
                balloon.field_70128_L = true;
            }
            serverWorld.func_212866_a_(player.field_70176_ah, player.field_70164_aj).func_76630_e();
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"placeNewPlayer"})
    private void spawnBalloons(NetworkManager netManager, ServerPlayerEntity player, CallbackInfo info) {
        ListNBT balloonsTag;
        ServerWorld serverWorld = (ServerWorld)player.field_70170_p;
        CompoundNBT compound = this.field_72400_f.func_240793_aU_().func_230416_x_();
        if (compound == null || !player.func_200200_C_().getString().equals(this.field_72400_f.func_71214_G())) {
            try {
                File playerDataFile = new File(this.field_72412_k.getPlayerDataFolder(), player.func_189512_bd() + ".dat");
                if (playerDataFile.exists() && playerDataFile.isFile()) {
                    compound = CompressedStreamTools.func_244263_a((File)playerDataFile);
                }
            }
            catch (Exception exception) {
                EndergeticExpansion.LOGGER.warn("Failed to load player data for {}", (Object)player.func_200200_C_().getString());
            }
        }
        if (compound != null && compound.func_150297_b("Balloons", 9) && !(balloonsTag = compound.func_150295_c("Balloons", 10)).isEmpty()) {
            for (int i = 0; i < balloonsTag.size(); ++i) {
                Entity entity = EntityType.func_220335_a((CompoundNBT)balloonsTag.func_150305_b(i), (World)serverWorld, balloon -> !serverWorld.func_217470_d(balloon) ? null : balloon);
                if (!(entity instanceof BolloomBalloonEntity)) continue;
                ((BolloomBalloonEntity)entity).attachToEntity((Entity)player);
                EndergeticExpansion.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new S2CUpdateBalloonsMessage((Entity)player));
            }
        }
    }
}

