/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials;

import com.google.common.collect.ImmutableSet;
import corgitaco.enhancedcelestials.api.EnhancedCelestialsRegistry;
import corgitaco.enhancedcelestials.api.client.ColorSettings;
import corgitaco.enhancedcelestials.api.lunarevent.LunarMobSpawnInfo;
import corgitaco.enhancedcelestials.api.lunarevent.LunarTextComponents;
import corgitaco.enhancedcelestials.core.ECSounds;
import corgitaco.enhancedcelestials.lunarevent.BloodMoon;
import corgitaco.enhancedcelestials.lunarevent.BlueMoon;
import corgitaco.enhancedcelestials.lunarevent.HarvestMoon;
import corgitaco.enhancedcelestials.lunarevent.client.MoonClientSettings;
import corgitaco.enhancedcelestials.network.NetworkHandler;
import corgitaco.enhancedcelestials.util.CustomTranslationTextComponent;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="enhancedcelestials")
public class Main {
    public static final String MOD_ID = "enhancedcelestials";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Path CONFIG_PATH = new File(String.valueOf(FMLPaths.CONFIGDIR.get().resolve("enhancedcelestials"))).toPath();

    public Main() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonSetup);
    }

    public void commonSetup(FMLCommonSetupEvent commonSetupEvent) {
        NetworkHandler.init();
        Main.registerDefaults();
    }

    public static void registerDefaults() {
        Registry.func_218322_a(EnhancedCelestialsRegistry.LUNAR_EVENT, (ResourceLocation)new ResourceLocation(MOD_ID, "blood_moon"), BloodMoon.CODEC);
        Registry.func_218322_a(EnhancedCelestialsRegistry.LUNAR_EVENT, (ResourceLocation)new ResourceLocation(MOD_ID, "blue_moon"), BlueMoon.CODEC);
        Registry.func_218322_a(EnhancedCelestialsRegistry.LUNAR_EVENT, (ResourceLocation)new ResourceLocation(MOD_ID, "harvest_moon"), HarvestMoon.CODEC);
        Registry.func_218322_a(EnhancedCelestialsRegistry.LUNAR_CLIENT_EVENT_SETTINGS, (ResourceLocation)new ResourceLocation(MOD_ID, "default"), MoonClientSettings.CODEC);
        ImmutableSet defaultMoonPhases = ImmutableSet.of((Object)0, (Object)1, (Object)2, (Object)3, (Object)5, (Object)6, (Object[])new Integer[]{7});
        ImmutableSet defaultSuperMoonPhases = ImmutableSet.of((Object)0);
        EnhancedCelestialsRegistry.DEFAULT_EVENTS.put(new ResourceLocation(MOD_ID, "blood_moon"), new BloodMoon(new MoonClientSettings(new ColorSettings("FF0000", 0.6, "FF0000", 0.4), 20.0f, ECSounds.BLOOD_MOON), 4, 0.07, (Collection<Integer>)defaultMoonPhases, new LunarTextComponents(new CustomTranslationTextComponent("enhancedcelestials.name.blood_moon", new CustomTranslationTextComponent[0]), new CustomTranslationTextComponent("enhancedcelestials.notification.blood_moon.rise", Style.field_240709_b_.func_240721_b_(TextFormatting.RED), new CustomTranslationTextComponent[0]), new CustomTranslationTextComponent("enhancedcelestials.notification.blood_moon.set", new CustomTranslationTextComponent[0])), true, (Map)Util.func_200696_a((Object)new Object2DoubleArrayMap(), map -> map.put((Object)EntityClassification.MONSTER, 3.0)), new LunarMobSpawnInfo(true, true, new MobSpawnInfo.Builder().func_242577_b())));
        EnhancedCelestialsRegistry.DEFAULT_EVENTS.put(new ResourceLocation(MOD_ID, "super_blood_moon"), new BloodMoon(new MoonClientSettings(new ColorSettings("FF0000", 1.0, "FF0000", 1.0), 40.0f, ECSounds.BLOOD_MOON), 20, 0.0175, (Collection<Integer>)defaultSuperMoonPhases, new LunarTextComponents(new CustomTranslationTextComponent("enhancedcelestials.name.super_blood_moon", new CustomTranslationTextComponent[0]), new CustomTranslationTextComponent("enhancedcelestials.notification.super_blood_moon.rise", Style.field_240709_b_.func_240721_b_(TextFormatting.RED).func_240721_b_(TextFormatting.BOLD), new CustomTranslationTextComponent[0]), new CustomTranslationTextComponent("enhancedcelestials.notification.blood_moon.set", new CustomTranslationTextComponent[0])), true, (Map)Util.func_200696_a((Object)new Object2DoubleArrayMap(), map -> map.put((Object)EntityClassification.MONSTER, 4.5)), new LunarMobSpawnInfo(true, true, new MobSpawnInfo.Builder().func_242577_b())));
        EnhancedCelestialsRegistry.DEFAULT_EVENTS.put(new ResourceLocation(MOD_ID, "harvest_moon"), new HarvestMoon(new MoonClientSettings(new ColorSettings("FFDB63", 0.6, "FFDB63", 0.4), 20.0f, ECSounds.HARVEST_MOON), 4, 0.035, (Collection<Integer>)defaultMoonPhases, new LunarTextComponents(new CustomTranslationTextComponent("enhancedcelestials.name.harvest_moon", new CustomTranslationTextComponent[0]), new CustomTranslationTextComponent("enhancedcelestials.notification.harvest_moon.rise", Style.field_240709_b_.func_240721_b_(TextFormatting.YELLOW), new CustomTranslationTextComponent[0]), new CustomTranslationTextComponent("enhancedcelestials.notification.harvest_moon.set", new CustomTranslationTextComponent[0])), false, (Collection<ResourceLocation>)ImmutableSet.of((Object)new ResourceLocation("forge", "item_tag_crops")), 2.0, false));
        EnhancedCelestialsRegistry.DEFAULT_EVENTS.put(new ResourceLocation(MOD_ID, "super_harvest_moon"), new HarvestMoon(new MoonClientSettings(new ColorSettings("FFDB63", 1.0, "FFDB63", 1.0), 40.0f, ECSounds.HARVEST_MOON), 20, 0.0175, (Collection<Integer>)defaultSuperMoonPhases, new LunarTextComponents(new CustomTranslationTextComponent("enhancedcelestials.name.super_harvest_moon", new CustomTranslationTextComponent[0]), new CustomTranslationTextComponent("enhancedcelestials.notification.super_harvest_moon.rise", Style.field_240709_b_.func_240721_b_(TextFormatting.YELLOW).func_240721_b_(TextFormatting.BOLD), new CustomTranslationTextComponent[0]), new CustomTranslationTextComponent("enhancedcelestials.notification.super_harvest_moon.set", new CustomTranslationTextComponent[0])), false, (Collection<ResourceLocation>)ImmutableSet.of((Object)new ResourceLocation("forge", "item_tag_crops")), 4.0, false));
        EnhancedCelestialsRegistry.DEFAULT_EVENTS.put(new ResourceLocation(MOD_ID, "blue_moon"), new BlueMoon(new MoonClientSettings(new ColorSettings("00ffff", 0.6, "00ffff", 0.4), 20.0f, ECSounds.BLUE_MOON), 4, 0.02, (Collection<Integer>)defaultMoonPhases, new LunarTextComponents(new CustomTranslationTextComponent("enhancedcelestials.name.blue_moon", new CustomTranslationTextComponent[0]), new CustomTranslationTextComponent("enhancedcelestials.notification.blue_moon.rise", Style.field_240709_b_.func_240721_b_(TextFormatting.AQUA), new CustomTranslationTextComponent[0]), new CustomTranslationTextComponent("enhancedcelestials.notification.blue_moon.set", new CustomTranslationTextComponent[0])), false, 1));
        EnhancedCelestialsRegistry.DEFAULT_EVENTS.put(new ResourceLocation(MOD_ID, "super_blue_moon"), new BlueMoon(new MoonClientSettings(new ColorSettings("00ffff", 1.0, "00ffff", 1.0), 40.0f, ECSounds.BLUE_MOON), 20, 0.01, (Collection<Integer>)defaultSuperMoonPhases, new LunarTextComponents(new CustomTranslationTextComponent("enhancedcelestials.name.super_blue_moon", new CustomTranslationTextComponent[0]), new CustomTranslationTextComponent("enhancedcelestials.notification.super_blue_moon.rise", Style.field_240709_b_.func_240721_b_(TextFormatting.AQUA).func_240721_b_(TextFormatting.BOLD), new CustomTranslationTextComponent[0]), new CustomTranslationTextComponent("enhancedcelestials.notification.super_blue_moon.set", new CustomTranslationTextComponent[0])), false, 5));
    }
}

