/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.mixin;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import corgitaco.enhancedcelestials.Main;
import corgitaco.enhancedcelestials.mixin.access.JsonReloadListenerAccess;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.loot.LootTableManager;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LootTableManager.class})
public abstract class MixinLootTableManager
extends JsonReloadListener {
    public MixinLootTableManager(Gson gson, String string) {
        super(gson, string);
    }

    @Inject(method={"apply"}, at={@At(value="HEAD")})
    private void appendTables(Map<ResourceLocation, JsonElement> values, IResourceManager resourceManager, IProfiler p_212853_3_, CallbackInfo ci) {
        String appendTablesDir = "append_loot_tables";
        Collection resourceLocations = resourceManager.func_199003_a(appendTablesDir, key -> key.endsWith(".json"));
        for (ResourceLocation resourceLocation : resourceLocations) {
            ResourceLocation key2 = new ResourceLocation(resourceLocation.func_110623_a().replace(appendTablesDir + "/", "").replaceFirst("/", ":").replace(".json", ""));
            if (!values.containsKey(key2)) continue;
            values.get(key2).getAsJsonObject().getAsJsonArray("pools").addAll(this.extractPools(resourceManager, resourceLocation));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonArray extractPools(IResourceManager resourceManager, ResourceLocation location) {
        try (IResource appendedTable = resourceManager.func_199002_a(location);){
            InputStream inputstream = appendedTable.func_199027_b();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
            JsonElement appendedElement = (JsonElement)JSONUtils.func_193839_a((Gson)((JsonReloadListenerAccess)((Object)this)).getGson(), (Reader)reader, JsonElement.class);
            JsonArray jsonArray = appendedElement.getAsJsonObject().getAsJsonArray("pools");
            return jsonArray;
        }
        catch (IOException e) {
            Main.LOGGER.error("Could not read appended table:" + location.toString());
            e.printStackTrace();
            return new JsonArray();
        }
    }
}

