/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.network.packet;

import corgitaco.enhancedcelestials.EnhancedCelestialsWorldData;
import corgitaco.enhancedcelestials.LunarContext;
import corgitaco.enhancedcelestials.LunarForecast;
import java.io.IOException;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class LunarForecastChangedPacket {
    private final LunarForecast lunarForecast;

    public LunarForecastChangedPacket(LunarForecast lunarForecast) {
        this.lunarForecast = lunarForecast;
    }

    public static void writeToPacket(LunarForecastChangedPacket packet, PacketBuffer buf) {
        try {
            buf.func_240629_a_(LunarForecast.CODEC, (Object)packet.lunarForecast);
        }
        catch (IOException e) {
            throw new IllegalStateException("Lunar Forecast packet could not be written to. This is really really bad...\n\n" + e.getMessage());
        }
    }

    public static LunarForecastChangedPacket readFromPacket(PacketBuffer buf) {
        try {
            return new LunarForecastChangedPacket((LunarForecast)buf.func_240628_a_(LunarForecast.CODEC));
        }
        catch (IOException e) {
            throw new IllegalStateException("Lunar Forecast packet could not be read. This is really really bad...\n\n" + e.getMessage());
        }
    }

    public static void handle(LunarForecastChangedPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                LunarContext lunarContext;
                Minecraft minecraft = Minecraft.func_71410_x();
                ClientWorld world = minecraft.field_71441_e;
                if (world != null && minecraft.field_71439_g != null && (lunarContext = ((EnhancedCelestialsWorldData)world).getLunarContext()) != null) {
                    lunarContext.getLunarForecast().getForecast().clear();
                    lunarContext.getLunarForecast().getForecast().addAll(message.lunarForecast.getForecast());
                    lunarContext.getLunarForecast().setLastCheckedGameTime(message.lunarForecast.getLastCheckedGameTime());
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

