/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import corgitaco.enhancedcelestials.EnhancedCelestialsWorldData;
import corgitaco.enhancedcelestials.LunarContext;
import corgitaco.enhancedcelestials.LunarEventInstance;
import corgitaco.enhancedcelestials.save.LunarEventSavedData;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;

public class SetLunarEventCommand {
    public static final String EC_NOT_ENABLED = "null";

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return Commands.func_197057_a((String)"setLunarEvent").then(Commands.func_197056_a((String)"lunarEvent", (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> {
            LunarContext lunarEventContext = ((EnhancedCelestialsWorldData)((CommandSource)ctx.getSource()).func_197023_e()).getLunarContext();
            return ISuggestionProvider.func_197013_a(lunarEventContext != null ? lunarEventContext.getLunarEvents().keySet().stream() : Arrays.stream(new String[]{EC_NOT_ENABLED}), (SuggestionsBuilder)sb);
        }).executes(cs -> SetLunarEventCommand.setLunarEvent((CommandSource)cs.getSource(), (String)cs.getArgument("lunarEvent", String.class))));
    }

    public static int setLunarEvent(CommandSource source, String lunarEventKey) {
        List<LunarEventInstance> forecast;
        LunarEventInstance commandInstance;
        ServerWorld world = source.func_197023_e();
        LunarContext lunarContext = ((EnhancedCelestialsWorldData)world).getLunarContext();
        if (lunarEventKey.equals(EC_NOT_ENABLED) || lunarContext == null) {
            source.func_197021_a((ITextComponent)new TranslationTextComponent("enhancedcelestials.commands.disabled"));
            return 0;
        }
        long dayLength = lunarContext.getLunarTimeSettings().getDayLength();
        long currentDay = world.func_72820_D() / dayLength;
        if (lunarContext.getLunarEvents().containsKey(lunarEventKey)) {
            if (!world.func_226690_K_()) {
                world.func_241114_a_(currentDay * dayLength + 13000L);
            }
            commandInstance = new LunarEventInstance(lunarEventKey, currentDay);
            forecast = lunarContext.getLunarForecast().getForecast();
            if (!forecast.isEmpty() && forecast.get(0).active(currentDay)) {
                forecast.remove(0);
            }
        } else {
            source.func_197021_a((ITextComponent)new TranslationTextComponent("enhancedcelestials.commands.lunarevent_missing", new Object[]{lunarEventKey}));
            return 0;
        }
        forecast.add(0, commandInstance);
        LunarEventSavedData.get((IWorld)world).setForecast(lunarContext.getLunarForecast());
        return 1;
    }
}

