/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.block;

import com.minecraftabnormals.abnormals_core.core.util.item.filling.TargetedItemGroupFiller;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class LargeLilyPadBlock
extends BushBlock
implements IPlantable {
    protected static final VoxelShape GIANT_LILY_PAD_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.5, (double)16.0);
    public static final EnumProperty<LilyPadPosition> POSITION = EnumProperty.func_177709_a((String)"position", LilyPadPosition.class);
    private static final TargetedItemGroupFiller FILLER = new TargetedItemGroupFiller(() -> Items.field_221816_dr);

    public LargeLilyPadBlock(AbstractBlock.Properties builder) {
        super(builder);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{POSITION});
    }

    public static void placeAt(World world, BlockPos pos, BlockState state, int flags) {
        world.func_180501_a(pos, (BlockState)state.func_206870_a(POSITION, (Comparable)((Object)LilyPadPosition.SOUTHWEST)), flags);
        world.func_180501_a(pos.func_177972_a(Direction.EAST), (BlockState)state.func_206870_a(POSITION, (Comparable)((Object)LilyPadPosition.SOUTHEAST)), flags);
        world.func_180501_a(pos.func_177972_a(Direction.NORTH), (BlockState)state.func_206870_a(POSITION, (Comparable)((Object)LilyPadPosition.NORTHWEST)), flags);
        world.func_180501_a(pos.func_177972_a(Direction.NORTH).func_177972_a(Direction.EAST), (BlockState)state.func_206870_a(POSITION, (Comparable)((Object)LilyPadPosition.NORTHEAST)), flags);
    }

    public static boolean checkPositions(World world, BlockPos pos, BlockState state) {
        if (!LargeLilyPadBlock.isValidPosAndAir((BlockState)state.func_206870_a(POSITION, (Comparable)((Object)LilyPadPosition.NORTHEAST)), world, pos.func_177972_a(Direction.NORTH).func_177972_a(Direction.EAST))) {
            return false;
        }
        if (!LargeLilyPadBlock.isValidPosAndAir((BlockState)state.func_206870_a(POSITION, (Comparable)((Object)LilyPadPosition.SOUTHEAST)), world, pos.func_177972_a(Direction.EAST))) {
            return false;
        }
        return LargeLilyPadBlock.isValidPosAndAir((BlockState)state.func_206870_a(POSITION, (Comparable)((Object)LilyPadPosition.NORTHWEST)), world, pos.func_177972_a(Direction.NORTH));
    }

    public static boolean isValidPosAndAir(BlockState state, World world, BlockPos pos) {
        return state.func_196955_c((IWorldReader)world, pos) && world.func_180495_p(pos).func_196958_f();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return GIANT_LILY_PAD_AABB;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        super.func_180658_a(worldIn, pos, entityIn, fallDistance * 0.25f);
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        if (entityIn.func_226272_bl_()) {
            super.func_176216_a(worldIn, entityIn);
        } else {
            this.bounce(entityIn);
        }
    }

    private void bounce(Entity entity) {
        Vector3d vector3d = entity.func_213322_ci();
        if (vector3d.field_72448_b < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.5 : 1.2;
            entity.func_213293_j(vector3d.field_72450_a, -vector3d.field_72448_b * d0, vector3d.field_72449_c);
        }
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        FluidState fluidstate = worldIn.func_204610_c(pos);
        FluidState fluidstate1 = worldIn.func_204610_c(pos.func_177984_a());
        return (fluidstate.func_206886_c() == Fluids.field_204546_a || state.func_185904_a() == Material.field_151588_w) && fluidstate1.func_206886_c() == Fluids.field_204541_a;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        if (state.func_177230_c() == this) {
            return worldIn.func_180495_p(blockpos).canSustainPlant((IBlockReader)worldIn, blockpos, Direction.UP, (IPlantable)this);
        }
        return this.func_200014_a_(worldIn.func_180495_p(blockpos), (IBlockReader)worldIn, blockpos);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) || !this.isConnected(stateIn, (IBlockReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean isConnected(BlockState state, IBlockReader worldIn, BlockPos pos) {
        LilyPadPosition position = (LilyPadPosition)((Object)state.func_177229_b(POSITION));
        pos = LargeLilyPadBlock.posToBlockPos(position, pos, true);
        for (LilyPadPosition newPosition : LilyPadPosition.values()) {
            if (worldIn.func_180495_p(LargeLilyPadBlock.posToBlockPos(newPosition, pos, false)).func_203425_a(this.getBlock()) && worldIn.func_180495_p(LargeLilyPadBlock.posToBlockPos(newPosition, pos, false)).func_177229_b(POSITION) == newPosition) continue;
            return false;
        }
        return true;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!worldIn.field_72995_K) {
            if (player.func_184812_l_()) {
                LargeLilyPadBlock.removeEachBlock(worldIn, pos, state, player);
            } else {
                LargeLilyPadBlock.func_220054_a((BlockState)state, (World)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)player.func_184614_ca());
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    private static void removeEachBlock(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        LilyPadPosition position = (LilyPadPosition)((Object)state.func_177229_b(POSITION));
        pos = LargeLilyPadBlock.posToBlockPos(position, pos, true);
        for (LilyPadPosition lilyPadPos : LilyPadPosition.values()) {
            LargeLilyPadBlock.removeBlock(lilyPadPos, world, pos, state, player);
        }
    }

    private static void removeBlock(LilyPadPosition position, World world, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockPos blockpos = LargeLilyPadBlock.posToBlockPos(position, pos, false);
        BlockState blockstate = world.func_180495_p(blockpos);
        if (blockstate.func_177230_c() == state.func_177230_c() && blockstate.func_177229_b(POSITION) == position) {
            world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 51);
            world.func_217378_a(player, 2001, blockpos, Block.func_196246_j((BlockState)blockstate));
        }
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, Blocks.field_150350_a.func_176223_P(), te, stack);
    }

    public static BlockPos posToBlockPos(LilyPadPosition position, BlockPos pos, boolean revert) {
        if (!revert) {
            switch (position) {
                case NORTHEAST: {
                    return pos.func_177972_a(Direction.NORTH).func_177972_a(Direction.EAST);
                }
                case NORTHWEST: {
                    return pos.func_177972_a(Direction.NORTH);
                }
                case SOUTHEAST: {
                    return pos.func_177972_a(Direction.EAST);
                }
            }
            return pos;
        }
        switch (position) {
            case NORTHEAST: {
                return pos.func_177972_a(Direction.SOUTH).func_177972_a(Direction.WEST);
            }
            case NORTHWEST: {
                return pos.func_177972_a(Direction.SOUTH);
            }
            case SOUTHEAST: {
                return pos.func_177972_a(Direction.WEST);
            }
        }
        return pos;
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return PlantType.WATER;
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        FILLER.fillItem(this.func_199767_j(), group, items);
    }

    public static enum LilyPadPosition implements IStringSerializable
    {
        NORTHEAST("northeast"),
        SOUTHEAST("southeast"),
        SOUTHWEST("southwest"),
        NORTHWEST("northwest");

        private final String heightName;

        private LilyPadPosition(String nameIn) {
            this.heightName = nameIn;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this.heightName;
        }
    }
}

