/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.entity;

import com.minecraftabnormals.environmental.common.item.YakPantsItem;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalEntities;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalItems;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalSounds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.IShearable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.EatGrassGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.DrinkHelper;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IForgeShearable;

public class YakEntity
extends AnimalEntity
implements IForgeShearable,
IShearable,
IAngerable {
    private static final DataParameter<Boolean> SHEARED = EntityDataManager.func_187226_a(YakEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ANGER_TIME = EntityDataManager.func_187226_a(YakEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final RangedInteger ANGER_RANGE = TickRangeConverter.func_233037_a_((int)20, (int)39);
    private static final UUID SPEED_UUID = UUID.fromString("49455A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier ATTACKING_SPEED_BOOST = new AttributeModifier(SPEED_UUID, "Attacking speed boost", 0.05, AttributeModifier.Operation.ADDITION);
    private EatGrassGoal eatGrassGoal;
    private UUID lastHurtBy;
    private int grassEatTimer;

    public YakEntity(EntityType<? extends YakEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.eatGrassGoal = new EatGrassGoal((MobEntity)this);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151015_O}), false));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (Goal)this.eatGrassGoal);
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, arg_0 -> ((YakEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new ResetAngerGoal((MobEntity)this, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SHEARED, (Object)false);
        this.field_70180_af.func_187214_a(ANGER_TIME, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Sheared", this.getSheared());
        this.func_233682_c_(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSheared(compound.func_74767_n("Sheared"));
        this.func_241358_a_((ServerWorld)this.field_70170_p, compound);
    }

    protected void func_70619_bc() {
        this.grassEatTimer = this.eatGrassGoal.func_151499_f();
        ModifiableAttributeInstance modifiableattributeinstance = this.func_110148_a(Attributes.field_233821_d_);
        if (this.func_233678_J__()) {
            if (!this.func_70631_g_() && !modifiableattributeinstance.func_180374_a(ATTACKING_SPEED_BOOST)) {
                modifiableattributeinstance.func_233767_b_(ATTACKING_SPEED_BOOST);
            }
        } else if (modifiableattributeinstance.func_180374_a(ATTACKING_SPEED_BOOST)) {
            modifiableattributeinstance.func_111124_b(ATTACKING_SPEED_BOOST);
        }
        this.func_241359_a_((ServerWorld)this.field_70170_p, true);
        if (this.func_233678_J__()) {
            this.field_70718_bc = this.field_70173_aa;
        }
        super.func_70619_bc();
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K && this.grassEatTimer > 0) {
            --this.grassEatTimer;
        }
        super.func_70636_d();
    }

    public void func_70103_a(byte id) {
        if (id == 10) {
            this.grassEatTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        if (itemstack.func_77973_b() == Items.field_151133_ar && !this.func_70631_g_()) {
            p_230254_1_.func_184185_a((SoundEvent)EnvironmentalSounds.YAK_MILK.get(), 1.0f, 1.0f);
            ItemStack itemstack1 = DrinkHelper.func_242398_a((ItemStack)itemstack, (PlayerEntity)p_230254_1_, (ItemStack)Items.field_151117_aB.func_190903_i());
            p_230254_1_.func_184611_a(p_230254_2_, itemstack1);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    public float getHeadEatingOffset(float partialTicks) {
        if (this.grassEatTimer <= 0) {
            return 0.0f;
        }
        if (this.grassEatTimer >= 4 && this.grassEatTimer <= 36) {
            return 1.0f;
        }
        return this.grassEatTimer < 4 ? ((float)this.grassEatTimer - partialTicks) / 4.0f : -((float)(this.grassEatTimer - 40) - partialTicks) / 4.0f;
    }

    public float getHeadPitch(float partialTicks) {
        if (this.grassEatTimer > 4 && this.grassEatTimer <= 36) {
            return 0.62831855f + 0.22f * MathHelper.func_76126_a((float)(((float)(this.grassEatTimer - 4) - partialTicks) / 32.0f * 28.7f));
        }
        return this.grassEatTimer > 0 ? 0.62831855f : MathHelper.func_219799_g((float)partialTicks, (float)this.field_70127_C, (float)this.field_70125_A) * ((float)Math.PI / 180);
    }

    public void func_70615_aA() {
        this.setSheared(false);
        if (this.func_70631_g_()) {
            this.func_110195_a(60);
        }
    }

    public boolean getSheared() {
        return (Boolean)this.field_70180_af.func_187225_a(SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.field_70180_af.func_187227_b(SHEARED, (Object)sheared);
    }

    public boolean func_230262_K__() {
        return this.func_70089_S() && !this.getSheared() && !this.func_70631_g_();
    }

    public boolean isShearable(ItemStack item, World world, BlockPos pos) {
        return this.func_230262_K__();
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return AnimalEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 25.0).func_233815_a_(Attributes.field_233821_d_, (double)0.2f).func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233824_g_, (double)1.2f);
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)EnvironmentalSounds.YAK_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)EnvironmentalSounds.YAK_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)EnvironmentalSounds.YAK_DEATH.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187566_ao, 0.15f, 1.0f);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected float func_70647_i() {
        return 0.8f;
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable PlayerEntity player, @Nonnull ItemStack item, World world, BlockPos pos, int fortune) {
        world.func_217384_a(null, (Entity)this, SoundEvents.field_187763_eJ, player == null ? SoundCategory.BLOCKS : SoundCategory.PLAYERS, 1.0f, 1.0f);
        if (!world.field_72995_K) {
            this.setSheared(true);
            if (!(player.func_184582_a(EquipmentSlotType.LEGS).func_77973_b() instanceof YakPantsItem)) {
                this.func_70624_b((LivingEntity)player);
            }
            int i = 4 + this.field_70146_Z.nextInt(12);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int j = 0; j < i; ++j) {
                items.add(new ItemStack((IItemProvider)EnvironmentalItems.YAK_HAIR.get()));
            }
            return items;
        }
        return Collections.emptyList();
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity ageable) {
        return (AgeableEntity)((EntityType)EnvironmentalEntities.YAK.get()).func_200721_a((World)world);
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return this.func_70631_g_() ? size.field_220316_b * 0.95f : 1.3f;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)EnvironmentalItems.YAK_SPAWN_EGG.get());
    }

    public void func_230263_a_(SoundCategory category) {
        this.field_70170_p.func_217384_a(null, (Entity)this, SoundEvents.field_187763_eJ, category, 1.0f, 1.0f);
        this.setSheared(true);
        int i = 4 + this.field_70146_Z.nextInt(12);
        for (int j = 0; j < i; ++j) {
            ItemEntity itementity = this.func_199702_a((IItemProvider)EnvironmentalItems.YAK_HAIR.get(), 1);
            if (itementity == null) continue;
            itementity.func_213317_d(itementity.func_213322_ci().func_72441_c((double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f), (double)(this.field_70146_Z.nextFloat() * 0.05f), (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f)));
        }
    }

    public int func_230256_F__() {
        return (Integer)this.field_70180_af.func_187225_a(ANGER_TIME);
    }

    public void func_230260_a__(int time) {
        this.field_70180_af.func_187227_b(ANGER_TIME, (Object)time);
    }

    public UUID func_230257_G__() {
        return this.lastHurtBy;
    }

    public void func_230259_a_(UUID target) {
        this.lastHurtBy = target;
    }

    public void func_230258_H__() {
        this.func_230260_a__(ANGER_RANGE.func_233018_a_(this.field_70146_Z));
    }

    public boolean isPreventingPlayerRest(PlayerEntity p_230292_1_) {
        return this.func_233680_b_((LivingEntity)p_230292_1_);
    }
}

