/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.item.explorer;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.minecraftabnormals.environmental.client.model.WandererBootsModel;
import com.minecraftabnormals.environmental.common.item.explorer.ExplorerArmorItem;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalItems;
import java.util.UUID;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="environmental")
public class WandererBootsItem
extends ExplorerArmorItem {
    public static final String NBT_TAG = "WandererBootsUses";

    public WandererBootsItem(Item.Properties properties) {
        super(EquipmentSlotType.FEET, properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack stack, EquipmentSlotType armorSlot, A _default) {
        return WandererBootsModel.get(1.0f);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(super.func_111205_h(this.func_185083_B_()));
        UUID uuid = UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B");
        int uses = Math.round(stack.func_196082_o().func_74760_g(NBT_TAG));
        double increase = 0.15f + 0.05f * (float)this.getIncreaseForUses(uses);
        builder.put((Object)Attributes.field_233821_d_, (Object)new AttributeModifier(uuid, "Speed modifier", increase, AttributeModifier.Operation.MULTIPLY_BASE));
        return slot == this.field_77881_a ? builder.build() : super.func_111205_h(slot);
    }

    @SubscribeEvent
    public static void onFallEvent(LivingFallEvent event) {
        if (event.getEntityLiving().func_184582_a(EquipmentSlotType.FEET).func_77973_b() == EnvironmentalItems.WANDERER_BOOTS.get() && event.getEntityLiving().field_70143_R < 6.0f) {
            event.setDamageMultiplier(0.0f);
        }
    }

    public float getIncreaseForUses(float uses) {
        int increase = 0;
        for (int level : this.getLevelCaps()) {
            if (!(uses >= (float)level)) continue;
            ++increase;
        }
        return increase;
    }

    @Override
    public String getUsesTag() {
        return NBT_TAG;
    }

    @Override
    public int[] getLevelCaps() {
        return new int[]{0, 1000, 5000, 10000, 50000};
    }

    public float levelUp(ItemStack stack, LivingEntity entity, float increase) {
        CompoundNBT tag = stack.func_196082_o();
        float uses = tag.func_74760_g(this.getUsesTag());
        float level = this.getIncreaseForUses(uses);
        tag.func_74776_a(this.getUsesTag(), uses + increase);
        float newLevel = this.getIncreaseForUses(uses + increase);
        if (newLevel > level) {
            this.playEffects(newLevel, entity);
        }
        return newLevel;
    }
}

