/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.network.message;

import com.minecraftabnormals.environmental.common.entity.SlabfishEntity;
import com.minecraftabnormals.environmental.common.network.ClientNetworkHandler;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class SOpenSlabfishInventoryMessage {
    private final int entityId;
    private final int windowId;

    private SOpenSlabfishInventoryMessage(int entityId, int windowId) {
        this.entityId = entityId;
        this.windowId = windowId;
    }

    public SOpenSlabfishInventoryMessage(SlabfishEntity slabfishEntity, int windowId) {
        this(slabfishEntity.func_145782_y(), windowId);
    }

    public static void serialize(SOpenSlabfishInventoryMessage message, PacketBuffer buffer) {
        buffer.func_150787_b(message.entityId);
        buffer.func_150787_b(message.windowId);
    }

    public static SOpenSlabfishInventoryMessage deserialize(PacketBuffer buffer) {
        return new SOpenSlabfishInventoryMessage(buffer.func_150792_a(), buffer.func_150792_a());
    }

    public static void handle(SOpenSlabfishInventoryMessage message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> ClientNetworkHandler.handleOpenSlabfishInventory(message));
        supplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getEntityId() {
        return this.entityId;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getWindowId() {
        return this.windowId;
    }
}

