/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.common.world.gen.feature;

import com.minecraftabnormals.abnormals_core.core.util.TreeUtil;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;

public class CherryTreeFeature
extends Feature<BaseTreeFeatureConfig> {
    public CherryTreeFeature(Codec<BaseTreeFeatureConfig> config) {
        super(config);
    }

    public boolean place(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos position, BaseTreeFeatureConfig config) {
        int height = 5 + rand.nextInt(3) + rand.nextInt(3) + rand.nextInt(3);
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= worldIn.func_217301_I()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + height; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.func_217301_I()) {
                            if (TreeUtil.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (CherryTreeFeature.func_236293_a_((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177977_b()) && position.func_177956_o() < worldIn.func_217301_I()) {
                TreeUtil.setDirtAt((IWorld)worldIn, (BlockPos)position.func_177977_b());
                int logX = position.func_177958_n();
                int logZ = position.func_177952_p();
                for (int k1 = 0; k1 < height; ++k1) {
                    int logY = position.func_177956_o() + k1;
                    BlockPos blockpos = new BlockPos(logX, logY, logZ);
                    if (!TreeUtil.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos)) continue;
                    this.placeLogAt((IWorldWriter)worldIn, blockpos, Direction.UP, rand, config);
                }
                Direction.Plane.HORIZONTAL.func_239636_a_().forEach(direction -> {
                    BlockPos stumpPos = position.func_177972_a(direction);
                    if (TreeUtil.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, (BlockPos)stumpPos) && CherryTreeFeature.func_236293_a_((IWorldGenerationBaseReader)worldIn, (BlockPos)stumpPos.func_177977_b())) {
                        this.placeLogAt((IWorldWriter)worldIn, stumpPos, Direction.UP, rand, config);
                        TreeUtil.setDirtAt((IWorld)worldIn, (BlockPos)stumpPos.func_177977_b());
                        BlockPos sideStumpPos = stumpPos.func_177972_a(direction.func_176746_e());
                        if (rand.nextBoolean() && CherryTreeFeature.func_236293_a_((IWorldGenerationBaseReader)worldIn, (BlockPos)sideStumpPos.func_177977_b()) && TreeUtil.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, (BlockPos)sideStumpPos)) {
                            this.placeLogAt((IWorldWriter)worldIn, sideStumpPos, Direction.UP, rand, config);
                            TreeUtil.setDirtAt((IWorld)worldIn, (BlockPos)sideStumpPos.func_177977_b());
                        }
                        if (rand.nextBoolean() && TreeUtil.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, (BlockPos)stumpPos.func_177984_a())) {
                            this.placeLogAt((IWorldWriter)worldIn, stumpPos.func_177984_a(), Direction.UP, rand, config);
                        }
                    }
                });
                Direction.Plane.HORIZONTAL.func_239636_a_().forEach(direction -> {
                    int newHeight = rand.nextBoolean() ? height + rand.nextInt(2) : height - rand.nextInt(2);
                    BlockPos newPos = this.createCherryBranch(newHeight, (IWorldGenerationReader)worldIn, position, (Direction)direction, rand, config);
                    for (int i = 0; i < 5; ++i) {
                        this.createCherryLeaves((IWorldGenerationReader)worldIn, newPos.func_177981_b(2).func_177979_c(i), rand, i, config);
                    }
                });
                return true;
            }
            return false;
        }
        return false;
    }

    private void createCherryLeaves(IWorldGenerationReader worldIn, BlockPos newPos, Random rand, int level, BaseTreeFeatureConfig config) {
        int leafSize = 2;
        for (int k3 = -leafSize; k3 <= leafSize; ++k3) {
            for (int j4 = -leafSize; j4 <= leafSize; ++j4) {
                if (level == 2) {
                    this.placeLeafAt(worldIn, newPos.func_177982_a(k3, 0, j4), rand, config);
                    continue;
                }
                if (level > 0 && level < 4 && (Math.abs(k3) != leafSize || Math.abs(j4) != leafSize)) {
                    this.placeLeafAt(worldIn, newPos.func_177982_a(k3, 0, j4), rand, config);
                    continue;
                }
                if (rand.nextInt(4) != 0) continue;
                this.placeLeafAt(worldIn, newPos.func_177982_a(k3, 0, j4), rand, config);
            }
        }
    }

    private BlockPos createCherryBranch(int height, IWorldGenerationReader worldIn, BlockPos pos, Direction direction, Random rand, BaseTreeFeatureConfig config) {
        int logX = pos.func_177958_n();
        int logZ = pos.func_177952_p();
        int logY = pos.func_177956_o() + height - 1;
        int length = 4 + rand.nextInt(3) + rand.nextInt(3);
        BlockPos blockpos = new BlockPos(logX, logY, logZ);
        for (int i = 0; i < length; ++i) {
            blockpos = new BlockPos(logX, logY, logZ);
            this.createHorizontalLog(worldIn, blockpos, direction, rand, config);
            if (direction == Direction.EAST || direction == Direction.WEST) {
                logX = direction == Direction.EAST ? (logX += rand.nextInt(2)) : (logX -= rand.nextInt(2));
            } else {
                logZ = direction == Direction.SOUTH ? (logZ += rand.nextInt(2)) : (logZ -= rand.nextInt(2));
            }
            ++logY;
        }
        return blockpos.func_177972_a(direction);
    }

    private void createHorizontalLog(IWorldGenerationReader worldIn, BlockPos pos, Direction direction, Random rand, BaseTreeFeatureConfig config) {
        int logX = pos.func_177958_n();
        int logY = pos.func_177956_o();
        int logZ = pos.func_177952_p();
        for (int k3 = 0; k3 < 1; ++k3) {
            BlockPos blockpos1 = new BlockPos(logX += direction.func_82601_c(), logY, logZ += direction.func_82599_e());
            if (!TreeUtil.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos1)) continue;
            this.placeLogAt((IWorldWriter)worldIn, blockpos1, Direction.UP, rand, config);
        }
    }

    private void placeLogAt(IWorldWriter worldIn, BlockPos pos, Direction direction, Random rand, BaseTreeFeatureConfig config) {
        BlockState logState = (BlockState)config.field_227368_m_.func_225574_a_(rand, pos).func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)direction.func_176740_k());
        TreeUtil.setForcedState((IWorldWriter)worldIn, (BlockPos)pos, (BlockState)logState);
    }

    private void placeLeafAt(IWorldGenerationReader world, BlockPos pos, Random rand, BaseTreeFeatureConfig config) {
        if (TreeUtil.isAirOrLeaves((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
            BlockState state = config.field_227369_n_.func_225574_a_(rand, pos);
            TreeUtil.setForcedState((IWorldWriter)world, (BlockPos)pos, (BlockState)state);
            if (state.func_235901_b_((Property)LeavesBlock.field_208494_a)) {
                LeavesBlock.func_208493_b((BlockState)state, (IWorld)((IWorld)world), (BlockPos)pos);
            }
        }
    }
}

