/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.core.mixin;

import com.minecraftabnormals.environmental.core.EnvironmentalConfig;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalItems;
import java.util.List;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MobEntity.class})
public abstract class MobEntityMixin
extends LivingEntity {
    @Shadow
    @Final
    protected float[] field_184655_bs;

    protected MobEntityMixin(EntityType<? extends LivingEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Inject(method={"populateDefaultEquipmentSlots"}, at={@At(value="TAIL")})
    private void setEquipmentBasedOnDifficulty(DifficultyInstance difficulty, CallbackInfo info) {
        int difficultyChance = difficulty.func_203095_a().func_151525_a() + 1;
        if (this.func_130014_f_() instanceof ServerWorld) {
            ServerWorld world = (ServerWorld)this.func_130014_f_();
            boolean isValid = false;
            for (String structureName : (List)EnvironmentalConfig.COMMON.healerPouchStructures.get()) {
                Structure structure = (Structure)ForgeRegistries.STRUCTURE_FEATURES.getValue(new ResourceLocation(structureName));
                if (structure == null || !world.func_241112_a_().func_235010_a_(this.func_233580_cy_(), true, structure).func_75069_d()) continue;
                isValid = true;
                break;
            }
            if (isValid && Math.random() < (double)((float)difficultyChance * 0.01f)) {
                this.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)EnvironmentalItems.HEALER_POUCH.get()));
                this.field_184655_bs[EquipmentSlotType.CHEST.func_188454_b()] = 1.0f;
            }
        }
    }
}

