/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.environmental.core.registry;

import com.google.common.collect.ImmutableSet;
import com.minecraftabnormals.abnormals_core.core.util.DataUtil;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalBiomes;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalBlocks;
import net.minecraft.block.Block;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.DesertVillagePools;
import net.minecraft.world.gen.feature.structure.PlainsVillagePools;
import net.minecraft.world.gen.feature.structure.SavannaVillagePools;
import net.minecraft.world.gen.feature.structure.SnowyVillagePools;
import net.minecraft.world.gen.feature.structure.TaigaVillagePools;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EnvironmentalVillagers {
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PROFESSIONS, (String)"environmental");
    public static final DeferredRegister<PointOfInterestType> POI_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"environmental");
    public static final RegistryObject<PointOfInterestType> KILN = POI_TYPES.register("kiln", () -> new PointOfInterestType("ceramist", PointOfInterestType.func_221042_a((Block)((Block)EnvironmentalBlocks.KILN.get())), 1, 1));
    public static final RegistryObject<PointOfInterestType> SAWMILL = POI_TYPES.register("sawmill", () -> new PointOfInterestType("carpenter", PointOfInterestType.func_221042_a((Block)((Block)EnvironmentalBlocks.SAWMILL.get())), 1, 1));
    public static final RegistryObject<VillagerProfession> CERAMIST = PROFESSIONS.register("ceramist", () -> new VillagerProfession("environmental:ceramist", (PointOfInterestType)KILN.get(), ImmutableSet.of(), ImmutableSet.of(), SoundEvents.field_219695_mC));
    public static final RegistryObject<VillagerProfession> CARPENTER = PROFESSIONS.register("carpenter", () -> new VillagerProfession("environmental:carpenter", (PointOfInterestType)SAWMILL.get(), ImmutableSet.of(), ImmutableSet.of(), SoundEvents.field_219703_mK));

    public static void registerVillagerTypes() {
        VillagerTrades.field_221239_a.isEmpty();
        EnvironmentalVillagers.registerVillagerType(EnvironmentalVillagers.createType("ice_spikes"), Biomes.field_185445_W);
        EnvironmentalVillagers.registerVillagerType(EnvironmentalVillagers.createType("flower_forest"), Biomes.field_185444_T);
        EnvironmentalVillagers.registerVillagerType(EnvironmentalVillagers.createType("blossom"), EnvironmentalBiomes.BLOSSOM_WOODS.getKey(), EnvironmentalBiomes.BLOSSOM_HILLS.getKey(), EnvironmentalBiomes.BLOSSOM_HIGHLANDS.getKey(), EnvironmentalBiomes.BLOSSOM_VALLEYS.getKey());
        EnvironmentalVillagers.registerVillagerType(EnvironmentalVillagers.createType("forest"), Biomes.field_76767_f, Biomes.field_76785_t, Biomes.field_150583_P, Biomes.field_150582_Q, Biomes.field_185448_Z, Biomes.field_185429_aa);
        EnvironmentalVillagers.registerVillagerType(EnvironmentalVillagers.createType("marsh"), EnvironmentalBiomes.MARSH.getKey(), EnvironmentalBiomes.MUSHROOM_MARSH.getKey());
        DataUtil.registerVillagerGift((VillagerProfession)((VillagerProfession)CERAMIST.get()));
        DataUtil.registerVillagerGift((VillagerProfession)((VillagerProfession)CARPENTER.get()));
        EnvironmentalVillagers.setupVillagerHouses();
    }

    private static VillagerType createType(String type) {
        return VillagerType.func_221171_a((String)("environmental:" + type));
    }

    @SafeVarargs
    private static void registerVillagerType(VillagerType type, RegistryKey<Biome> ... biomes) {
        for (RegistryKey<Biome> biome : biomes) {
            VillagerType.field_221180_h.put(biome, type);
        }
    }

    private static void setupVillagerHouses() {
        PlainsVillagePools.func_214744_a();
        SnowyVillagePools.func_214746_a();
        SavannaVillagePools.func_214745_a();
        DesertVillagePools.func_222739_a();
        TaigaVillagePools.func_214806_a();
        EnvironmentalVillagers.addVillagerHouse("ceramist", "plains", 2);
        EnvironmentalVillagers.addVillagerHouse("ceramist", "snowy", 4);
        EnvironmentalVillagers.addVillagerHouse("ceramist", "savanna", 6);
        EnvironmentalVillagers.addVillagerHouse("ceramist", "desert", 5);
        EnvironmentalVillagers.addVillagerHouse("ceramist", "taiga", 7);
        EnvironmentalVillagers.addVillagerHouse("carpenter", "plains", 10);
        EnvironmentalVillagers.addVillagerHouse("carpenter", "snowy", 11);
        EnvironmentalVillagers.addVillagerHouse("carpenter", "savanna", 7);
        EnvironmentalVillagers.addVillagerHouse("carpenter", "desert", 9);
        EnvironmentalVillagers.addVillagerHouse("carpenter", "taiga", 5);
    }

    private static void addVillagerHouse(String type, String biome, int weight) {
        DataUtil.addToJigsawPattern((ResourceLocation)new ResourceLocation("village/" + biome + "/houses"), (JigsawPiece)((JigsawPiece)JigsawPiece.func_242859_b((String)("environmental:village/" + type + "_house_" + biome + "_1")).apply(JigsawPattern.PlacementBehaviour.RIGID)), (int)weight);
    }
}

