/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.block.mushroomblocks;

import cech12.extendedmushrooms.block.mushroomblocks.AbstractEffectMushroomCap;
import cech12.extendedmushrooms.item.MushroomType;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PoisonousMushroomCap
extends AbstractEffectMushroomCap {
    public static final BooleanProperty TRIGGERED = BlockStateProperties.field_208197_x;
    private static final Direction[] DIRECTION_ORDER = new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.SOUTH};

    public PoisonousMushroomCap(MushroomType type, AbstractBlock.Properties properties) {
        super(type, properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean func_149653_t(BlockState state) {
        return super.func_149653_t(state) || (Boolean)state.func_177229_b((Property)TRIGGERED) == false;
    }

    @Override
    public void func_225542_b_(BlockState state, @Nonnull ServerWorld worldIn, @Nonnull BlockPos pos, @Nonnull Random random) {
        super.func_225542_b_(state, worldIn, pos, random);
        if (((Boolean)state.func_177229_b((Property)TRIGGERED)).booleanValue()) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{TRIGGERED});
    }

    @Override
    @Nonnull
    protected List<EffectInstance> getEffects(@Nonnull Random random) {
        int duration = 200 + random.nextInt(200);
        if (random.nextInt(100) == 0) {
            duration += 1200;
        }
        LinkedList<EffectInstance> effects = new LinkedList<EffectInstance>();
        effects.add(new EffectInstance(Effects.field_76436_u, duration));
        return effects;
    }

    private boolean isTriggeringEntity(Entity entity) {
        return entity instanceof LivingEntity && !(entity instanceof AnimalEntity);
    }

    private void generateEffectCloud(@Nonnull ServerWorld worldIn, @Nonnull BlockState state, BlockPos pos, @Nullable Direction face) {
        boolean posFound = false;
        BlockPos.Mutable effectPos = new BlockPos.Mutable();
        if (face != null) {
            LinkedList<Direction> directions = new LinkedList<Direction>(Arrays.asList(DIRECTION_ORDER));
            directions.remove(face);
            directions.addFirst(face);
            for (Direction direction : directions) {
                effectPos.func_189533_g((Vector3i)pos).func_189536_c(direction);
                if (worldIn.func_180495_p((BlockPos)effectPos).func_200132_m()) continue;
                posFound = true;
                break;
            }
        } else {
            effectPos.func_189533_g((Vector3i)pos);
            if (!worldIn.func_180495_p((BlockPos)effectPos).func_200132_m()) {
                posFound = true;
            }
        }
        if (posFound) {
            this.spawnEffectCloud(worldIn, (BlockPos)effectPos, worldIn.func_201674_k());
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn instanceof ServerWorld && !((Boolean)state.func_177229_b((Property)TRIGGERED)).booleanValue() && !((Boolean)state.func_177229_b((Property)AbstractEffectMushroomCap.PERSISTENT)).booleanValue()) {
            this.generateEffectCloud((ServerWorld)worldIn, state, pos, hit.func_216354_b());
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        if (worldIn instanceof ServerWorld && !((Boolean)state.func_177229_b((Property)TRIGGERED)).booleanValue() && !((Boolean)state.func_177229_b((Property)AbstractEffectMushroomCap.PERSISTENT)).booleanValue()) {
            this.generateEffectCloud((ServerWorld)worldIn, state, pos, Direction.UP);
        }
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        BlockState state = worldIn.func_180495_p(pos);
        if (worldIn instanceof ServerWorld && !((Boolean)state.func_177229_b((Property)TRIGGERED)).booleanValue() && !((Boolean)state.func_177229_b((Property)AbstractEffectMushroomCap.PERSISTENT)).booleanValue() && this.isTriggeringEntity(entityIn)) {
            this.generateEffectCloud((ServerWorld)worldIn, state, pos, Direction.UP);
        }
    }

    public void func_176208_a(World worldIn, @Nonnull BlockPos pos, BlockState state, @Nonnull PlayerEntity player) {
        super.func_176208_a(worldIn, pos, state, player);
        if (worldIn instanceof ServerWorld && !((Boolean)state.func_177229_b((Property)TRIGGERED)).booleanValue() && !((Boolean)state.func_177229_b((Property)AbstractEffectMushroomCap.PERSISTENT)).booleanValue()) {
            this.generateEffectCloud((ServerWorld)worldIn, state, pos, null);
        }
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        super.func_180658_a(worldIn, pos, entityIn, fallDistance);
        BlockState state = worldIn.func_180495_p(pos);
        if (worldIn instanceof ServerWorld && fallDistance >= 1.0f && !((Boolean)state.func_177229_b((Property)TRIGGERED)).booleanValue() && this.isTriggeringEntity(entityIn)) {
            this.generateEffectCloud((ServerWorld)worldIn, state, pos, Direction.UP);
        }
    }
}

