/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.data;

import cech12.extendedmushrooms.block.BookshelfBlock;
import cech12.extendedmushrooms.block.EMMushroomBlock;
import cech12.extendedmushrooms.block.MushroomCapButtonBlock;
import cech12.extendedmushrooms.block.MushroomCapPressurePlateBlock;
import cech12.extendedmushrooms.block.MushroomLadderBlock;
import cech12.extendedmushrooms.block.MushroomWoodButtonBlock;
import cech12.extendedmushrooms.block.VariantChestBlock;
import cech12.extendedmushrooms.block.VariantTrappedChestBlock;
import cech12.extendedmushrooms.block.VerticalPlanksBlock;
import cech12.extendedmushrooms.block.VerticalSlabBlock;
import cech12.extendedmushrooms.block.mushroomblocks.MushroomCapBlock;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BushBlock;
import net.minecraft.block.CarpetBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.StandingSignBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WallSignBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockModelProvider
extends net.minecraftforge.client.model.generators.BlockModelProvider {
    public BlockModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "extendedmushrooms", existingFileHelper);
    }

    @Nonnull
    public String func_200397_b() {
        return "Extended Mushrooms Block Models";
    }

    private static ResourceLocation getResourceLocation(String path) {
        return new ResourceLocation("extendedmushrooms", path);
    }

    private static ResourceLocation getBlockResourceLocation(String name) {
        return BlockModelProvider.getResourceLocation("block/" + name);
    }

    private static ResourceLocation getBlockResourceLocation(String name, String removeSuffix, String addSuffix) {
        return BlockModelProvider.getBlockResourceLocation(name.substring(0, name.length() - removeSuffix.length()) + addSuffix);
    }

    private static ResourceLocation getCapResourceLocation(String name, String removeSuffix) {
        if (name.startsWith("brown_mushroom_")) {
            return new ResourceLocation("block/brown_mushroom_block");
        }
        if (name.startsWith("red_mushroom_")) {
            return new ResourceLocation("block/red_mushroom_block");
        }
        return BlockModelProvider.getBlockResourceLocation(name, removeSuffix, "");
    }

    protected void registerModels() {
        ResourceLocation verticalPlanks = BlockModelProvider.getBlockResourceLocation("vertical_planks");
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(verticalPlanks.func_110623_a())).parent((ModelFile)this.getExistingFile(new ResourceLocation("block/block")))).texture("particle", "#all")).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).allFaces((direction, faceBuilder) -> faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#all").cullface(direction).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90));
        ResourceLocation verticalSlab = BlockModelProvider.getBlockResourceLocation("vertical_slab");
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(verticalSlab.func_110623_a())).parent((ModelFile)this.getExistingFile(new ResourceLocation("block/block")))).texture("particle", "#side")).element().from(0.0f, 0.0f, 8.0f).to(16.0f, 16.0f, 16.0f).allFaces((direction, faceBuilder) -> {
            String texture = "#side";
            if (direction == Direction.DOWN) {
                texture = "#bottom";
            } else if (direction == Direction.UP) {
                texture = "#top";
            }
            int u1 = direction == Direction.EAST || direction == Direction.WEST ? 8 : 0;
            int v1 = direction == Direction.DOWN || direction == Direction.UP ? 8 : 0;
            faceBuilder.uvs((float)u1, (float)v1, 16.0f, 16.0f).texture(texture);
        });
        for (Block block : ForgeRegistries.BLOCKS) {
            ResourceLocation texture;
            if (!"extendedmushrooms".equals(block.getRegistryName().func_110624_b())) continue;
            String name = block.getRegistryName().func_110623_a();
            if (block instanceof EMMushroomBlock) {
                ((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(name)).parent((ModelFile)this.getExistingFile(new ResourceLocation("block/cross")))).texture("cross", BlockModelProvider.getBlockResourceLocation(name));
                continue;
            }
            if (block instanceof BookshelfBlock) {
                ResourceLocation side = BlockModelProvider.getBlockResourceLocation(name);
                ResourceLocation end = BlockModelProvider.getBlockResourceLocation(name, "_bookshelf", "_planks");
                this.cubeColumn(name, side, end);
                continue;
            }
            if (block instanceof MushroomWoodButtonBlock) {
                this.buttonBlock(name, BlockModelProvider.getBlockResourceLocation(name, "_button", "_planks"));
                continue;
            }
            if (block instanceof MushroomCapBlock) {
                this.hugeMushroomBlock(name, BlockModelProvider.getBlockResourceLocation(name));
                texture = BlockModelProvider.getBlockResourceLocation(name, "_cap", "_inside");
                ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(texture.func_110623_a())).ao(false)).texture("texture", texture)).texture("particle", texture)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 0.0f).face(Direction.NORTH).texture("#texture").cullface(Direction.NORTH);
                continue;
            }
            if (block instanceof MushroomCapButtonBlock) {
                this.buttonBlock(name, BlockModelProvider.getCapResourceLocation(name, "_button"));
                continue;
            }
            if (block instanceof CarpetBlock) {
                texture = BlockModelProvider.getCapResourceLocation(name, "_carpet");
                ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(name)).parent((ModelFile)this.getExistingFile(new ResourceLocation("block/carpet")))).texture("particle", texture)).texture("wool", texture);
                continue;
            }
            if (block instanceof MushroomCapPressurePlateBlock) {
                this.pressurePlateBlock(name, BlockModelProvider.getCapResourceLocation(name, "_pressure_plate"));
                continue;
            }
            if (block instanceof VariantChestBlock) {
                ((BlockModelBuilder)this.getBuilder(name)).texture("particle", BlockModelProvider.getBlockResourceLocation(name, "_chest", "_planks"));
                continue;
            }
            if (block instanceof VariantTrappedChestBlock) continue;
            if (block instanceof DoorBlock) {
                ResourceLocation bottom = BlockModelProvider.getBlockResourceLocation(name + "_bottom");
                ResourceLocation top = BlockModelProvider.getBlockResourceLocation(name + "_top");
                ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(name + "_bottom")).parent((ModelFile)this.getExistingFile(new ResourceLocation("block/door_bottom")))).texture("bottom", bottom)).texture("top", top);
                ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(name + "_bottom_hinge")).parent((ModelFile)this.getExistingFile(new ResourceLocation("block/door_bottom_rh")))).texture("bottom", bottom)).texture("top", top);
                ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(name + "_top")).parent((ModelFile)this.getExistingFile(new ResourceLocation("block/door_top")))).texture("bottom", bottom)).texture("top", top);
                ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(name + "_top_hinge")).parent((ModelFile)this.getExistingFile(new ResourceLocation("block/door_top_rh")))).texture("bottom", bottom)).texture("top", top);
                continue;
            }
            if (block instanceof FenceGateBlock) {
                texture = BlockModelProvider.getBlockResourceLocation(name, "_fence_gate", "_planks");
                this.simpleTexturedBlock(name, "template_fence_gate", texture);
                this.simpleTexturedBlock(name + "_open", "template_fence_gate_open", texture);
                this.simpleTexturedBlock(name + "_wall", "template_fence_gate_wall", texture);
                this.simpleTexturedBlock(name + "_wall_open", "template_fence_gate_wall_open", texture);
                continue;
            }
            if (block instanceof FenceBlock) {
                texture = BlockModelProvider.getBlockResourceLocation(name, "_fence", "_planks");
                this.simpleTexturedBlock(name + "_inventory", "fence_inventory", texture);
                this.simpleTexturedBlock(name + "_post", "fence_post", texture);
                this.simpleTexturedBlock(name + "_side", "fence_side", texture);
                continue;
            }
            if (block instanceof FlowerPotBlock) {
                ((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(name)).parent((ModelFile)this.getExistingFile(new ResourceLocation("block/flower_pot_cross")))).texture("plant", BlockModelProvider.getBlockResourceLocation(name, "_potted", ""));
                continue;
            }
            if (block instanceof MushroomLadderBlock) {
                texture = BlockModelProvider.getBlockResourceLocation(name);
                ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(name)).parent((ModelFile)this.getExistingFile(new ResourceLocation("block/ladder")))).ao(false)).texture("particle", texture)).texture("texture", texture);
                continue;
            }
            if (block instanceof PressurePlateBlock) {
                this.pressurePlateBlock(name, BlockModelProvider.getBlockResourceLocation(name, "_pressure_plate", "_planks"));
                continue;
            }
            if (block instanceof SlabBlock) {
                texture = BlockModelProvider.getBlockResourceLocation(name, "_slab", "_planks");
                ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(name)).parent((ModelFile)this.getExistingFile(new ResourceLocation("block/slab")))).texture("bottom", texture)).texture("top", texture)).texture("side", texture);
                ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(name + "_top")).parent((ModelFile)this.getExistingFile(new ResourceLocation("block/slab_top")))).texture("bottom", texture)).texture("top", texture)).texture("side", texture);
                continue;
            }
            if (block instanceof StairsBlock) {
                texture = BlockModelProvider.getBlockResourceLocation(name, "_stairs", "_planks");
                ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(name)).parent((ModelFile)this.getExistingFile(new ResourceLocation("block/stairs")))).texture("bottom", texture)).texture("top", texture)).texture("side", texture);
                ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(name + "_inner")).parent((ModelFile)this.getExistingFile(new ResourceLocation("block/inner_stairs")))).texture("bottom", texture)).texture("top", texture)).texture("side", texture);
                ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(name + "_outer")).parent((ModelFile)this.getExistingFile(new ResourceLocation("block/outer_stairs")))).texture("bottom", texture)).texture("top", texture)).texture("side", texture);
                continue;
            }
            if (block instanceof StandingSignBlock || block instanceof WallSignBlock) {
                if (!(block instanceof StandingSignBlock)) continue;
                ((BlockModelBuilder)this.getBuilder(name)).texture("particle", BlockModelProvider.getBlockResourceLocation(name, "_sign", "_planks"));
                continue;
            }
            if (block instanceof HugeMushroomBlock) {
                this.hugeMushroomBlock(name, BlockModelProvider.getBlockResourceLocation(name));
                continue;
            }
            if (block instanceof TrapDoorBlock) {
                texture = BlockModelProvider.getBlockResourceLocation(name);
                this.simpleTexturedBlock(name + "_bottom", "template_orientable_trapdoor_bottom", texture);
                this.simpleTexturedBlock(name + "_open", "template_orientable_trapdoor_open", texture);
                this.simpleTexturedBlock(name + "_top", "template_orientable_trapdoor_top", texture);
                continue;
            }
            if (block instanceof VerticalPlanksBlock) {
                texture = BlockModelProvider.getBlockResourceLocation(name, "_vertical_planks", "_planks");
                ((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(name)).parent((ModelFile)this.getExistingFile(verticalPlanks))).texture("all", texture);
                continue;
            }
            if (block instanceof VerticalSlabBlock) {
                texture = BlockModelProvider.getBlockResourceLocation(name, "_vertical_slab", "_planks");
                ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(name)).parent((ModelFile)this.getExistingFile(verticalSlab))).texture("bottom", texture)).texture("top", texture)).texture("side", texture);
                continue;
            }
            if (block instanceof BushBlock) {
                ((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(name)).parent((ModelFile)this.getExistingFile(new ResourceLocation("block/tinted_cross")))).texture("cross", BlockModelProvider.getBlockResourceLocation(name));
                continue;
            }
            this.cubeBlock(name, BlockModelProvider.getBlockResourceLocation(name));
        }
        ResourceLocation triggeredPoisonousMushroom = BlockModelProvider.getBlockResourceLocation("poisonous_mushroom_triggered");
        ((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(triggeredPoisonousMushroom.func_110623_a())).parent((ModelFile)this.getExistingFile(new ResourceLocation("block/cross")))).texture("cross", triggeredPoisonousMushroom);
        ResourceLocation triggeredPoisonousMushroomCap = BlockModelProvider.getBlockResourceLocation("poisonous_mushroom_cap_triggered");
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(triggeredPoisonousMushroomCap.func_110623_a())).texture("texture", triggeredPoisonousMushroomCap)).texture("particle", triggeredPoisonousMushroomCap)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 0.0f).face(Direction.NORTH).texture("#texture").cullface(Direction.NORTH);
    }

    private void cubeBlock(String name, ResourceLocation texture) {
        ((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(name)).parent((ModelFile)this.getExistingFile(new ResourceLocation("block/cube_all")))).texture("all", texture);
    }

    private void simpleTexturedBlock(String name, String parent, ResourceLocation texture) {
        ((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(name)).parent((ModelFile)this.getExistingFile(new ResourceLocation("block/" + parent)))).texture("texture", texture);
    }

    private void buttonBlock(String name, ResourceLocation texture) {
        this.simpleTexturedBlock(name, "button", texture);
        this.simpleTexturedBlock(name + "_inventory", "button_inventory", texture);
        this.simpleTexturedBlock(name + "_pressed", "button_pressed", texture);
    }

    private void pressurePlateBlock(String name, ResourceLocation texture) {
        this.simpleTexturedBlock(name, "pressure_plate_up", texture);
        this.simpleTexturedBlock(name + "_down", "pressure_plate_down", texture);
    }

    private void hugeMushroomBlock(String name, ResourceLocation texture) {
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(name)).texture("texture", texture)).texture("particle", texture)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 0.0f).face(Direction.NORTH).texture("#texture").cullface(Direction.NORTH);
        this.cubeBlock(name + "_inventory", texture);
    }
}

