/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.data.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class WoodcutterRecipeBuilder {
    private final Item result;
    private final Ingredient ingredient;
    private final int count;
    private final List<JsonObject> conditions = new ArrayList<JsonObject>();

    public WoodcutterRecipeBuilder(IItemProvider resultIn, Ingredient ingredientIn, int countIn) {
        this.result = resultIn.func_199767_j();
        this.ingredient = ingredientIn;
        this.count = countIn;
        JsonObject object = new JsonObject();
        object.addProperty("type", ModLoadedCondition.Serializer.INSTANCE.getID().toString());
        ModLoadedCondition.Serializer.INSTANCE.write(object, new ModLoadedCondition("woodcutter"));
        this.addCondition(object);
    }

    public static WoodcutterRecipeBuilder woodcutterRecipe(IItemProvider resultIn, Ingredient ingredientIn, int countIn) {
        return new WoodcutterRecipeBuilder(resultIn, ingredientIn, countIn);
    }

    public static WoodcutterRecipeBuilder woodcutterRecipe(IItemProvider resultIn, Ingredient ingredientIn) {
        return new WoodcutterRecipeBuilder(resultIn, ingredientIn, 1);
    }

    public WoodcutterRecipeBuilder addCondition(JsonObject json) {
        this.conditions.add(json);
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        this.build(consumerIn, ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, String save) {
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result);
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Shapeless Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumerIn, new ResourceLocation(save));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id, this.result, this.ingredient, this.count, this.conditions));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final Ingredient ingredient;
        private final int count;
        private final List<JsonObject> conditions;

        public Result(ResourceLocation idIn, Item resultIn, Ingredient ingredientIn, int countIn, List<JsonObject> conditionsIn) {
            this.id = idIn;
            this.result = resultIn;
            this.ingredient = ingredientIn;
            this.count = countIn;
            this.conditions = conditionsIn;
        }

        public void func_218610_a(JsonObject json) {
            json.addProperty("type", "woodcutter:woodcutting");
            JsonArray conditionArray = new JsonArray();
            for (JsonObject jsonObject : this.conditions) {
                conditionArray.add((JsonElement)jsonObject);
            }
            json.add("conditions", (JsonElement)conditionArray);
            json.add("ingredient", this.ingredient.func_200304_c());
            json.addProperty("result", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result).toString());
            json.addProperty("count", (Number)this.count);
        }

        @Nonnull
        public IRecipeSerializer<?> func_218609_c() {
            return IRecipeSerializer.field_222158_b;
        }

        @Nonnull
        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

