/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.init;

import cech12.extendedmushrooms.api.entity.ExtendedMushroomsEntityTypes;
import cech12.extendedmushrooms.client.renderer.entity.MushroomBoatRenderer;
import cech12.extendedmushrooms.client.renderer.entity.MushroomSheepRenderer;
import cech12.extendedmushrooms.config.Config;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="extendedmushrooms", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEntities {
    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        ModEntities.registerEntity("mushroom_sheep", ExtendedMushroomsEntityTypes.MUSHROOM_SHEEP);
        ModEntities.registerEntity("mushroom_boat", ExtendedMushroomsEntityTypes.MUSHROOM_BOAT);
    }

    private static <T extends Entity> void registerEntity(String key, EntityType<T> entityType) {
        entityType.setRegistryName(new ResourceLocation("extendedmushrooms", key));
        ForgeRegistries.ENTITIES.register(entityType);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put(ExtendedMushroomsEntityTypes.MUSHROOM_SHEEP, SheepEntity.func_234225_eI_().func_233813_a_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setupRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(ExtendedMushroomsEntityTypes.MUSHROOM_SHEEP, MushroomSheepRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ExtendedMushroomsEntityTypes.MUSHROOM_BOAT, MushroomBoatRenderer::new);
    }

    public static void addEntitiesToBiomes(BiomeLoadingEvent event) {
        if (event.getCategory().equals((Object)Biome.Category.MUSHROOM) && ((Boolean)Config.MUSHROOM_SHEEP_ENABLED.get()).booleanValue()) {
            event.getSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(ExtendedMushroomsEntityTypes.MUSHROOM_SHEEP, ((Integer)Config.MUSHROOM_SHEEP_SPAWN_WEIGHT.get()).intValue(), ((Integer)Config.MUSHROOM_SHEEP_SPAWN_MIN_GROUP_COUNT.get()).intValue(), ((Integer)Config.MUSHROOM_SHEEP_SPAWN_MAX_GROUP_COUNT.get()).intValue()));
        }
    }
}

