/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.mixin;

import cech12.extendedmushrooms.MushroomUtils;
import cech12.extendedmushrooms.block.mushrooms.BrownMushroom;
import cech12.extendedmushrooms.block.mushrooms.RedMushroom;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.MushroomBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MushroomBlock.class})
public class MixinMushroomBlock {
    @Inject(at={@At(value="HEAD")}, method={"randomTick"}, cancellable=true)
    public void tickProxy(BlockState state, ServerWorld world, BlockPos pos, Random random, CallbackInfo ci) {
        if (world.isAreaLoaded(pos, 7) && random.nextInt(25) == 0 && state.func_177230_c() instanceof MushroomBlock) {
            ((MushroomBlock)state.func_177230_c()).func_225535_a_(world, random, pos, state);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"grow"}, cancellable=true)
    public void growProxy(ServerWorld world, BlockPos pos, BlockState state, Random random, CallbackInfoReturnable<Boolean> cir) {
        if (!MushroomUtils.isValidMushroomPosition((IWorldReader)world, pos)) {
            cir.setReturnValue((Object)false);
        } else if (state.func_177230_c() == Blocks.field_150338_P) {
            new BrownMushroom().growMushroom(world, world.func_72863_F().func_201711_g(), pos, state, random);
            cir.setReturnValue((Object)true);
        } else if (state.func_177230_c() == Blocks.field_150337_Q) {
            new RedMushroom().growMushroom(world, world.func_72863_F().func_201711_g(), pos, state, random);
            cir.setReturnValue((Object)true);
        } else {
            cir.setReturnValue((Object)false);
        }
        cir.cancel();
    }
}

