/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.trades.type;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrcrayfish.goblintraders.trades.GoblinTrade;
import com.mrcrayfish.goblintraders.trades.TradeSerializer;
import com.mrcrayfish.goblintraders.trades.type.ITradeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class BasicTrade
implements ITradeType<GoblinTrade> {
    public static final Serializer SERIALIZER = new Serializer();
    private final ItemStack offerStack;
    private final ItemStack paymentStack;
    private final ItemStack secondaryPaymentStack;
    private final float priceMultiplier;
    private final int maxTrades;
    private final int experience;
    private final EnchantmentData[] enchantments;
    private final Collection<EffectInstance> potionEffects;

    public BasicTrade(ItemStack offerStack, ItemStack paymentStack, ItemStack secondaryPaymentStack, float priceMultiplier, int maxTrades, int experience, EnchantmentData[] enchantments, Collection<EffectInstance> potionEffects) {
        this.offerStack = offerStack;
        this.paymentStack = paymentStack;
        this.secondaryPaymentStack = secondaryPaymentStack;
        this.priceMultiplier = priceMultiplier;
        this.maxTrades = maxTrades;
        this.experience = experience;
        this.enchantments = enchantments;
        this.potionEffects = potionEffects;
    }

    @Override
    public GoblinTrade createVillagerTrade() {
        ItemStack offerStack = this.offerStack.func_77946_l();
        if (this.enchantments.length > 0) {
            if (offerStack.func_77973_b() == Items.field_151134_bR) {
                EnchantmentHelper.func_82782_a(Stream.of(this.enchantments).collect(Collectors.toMap(o -> o.field_76302_b, e -> e.field_76303_c)), (ItemStack)offerStack);
            } else {
                for (EnchantmentData data : this.enchantments) {
                    offerStack.func_77966_a(data.field_76302_b, data.field_76303_c);
                }
            }
        }
        if (this.potionEffects.size() > 0) {
            PotionUtils.func_185184_a((ItemStack)offerStack, this.potionEffects);
        }
        return new GoblinTrade(offerStack, this.paymentStack.func_77946_l(), this.secondaryPaymentStack.func_77946_l(), this.maxTrades, this.experience, this.priceMultiplier);
    }

    @Override
    public JsonObject serialize() {
        return SERIALIZER.serialize(this);
    }

    public static class Builder {
        private ItemStack offerStack;
        private ItemStack paymentStack;
        private ItemStack secondaryPaymentStack = ItemStack.field_190927_a;
        private float priceMultiplier = 0.0f;
        private int maxTrades = 12;
        private int experience = 10;
        private List<EnchantmentData> enchantments = new ArrayList<EnchantmentData>();
        private List<EffectInstance> potionEffects = new ArrayList<EffectInstance>();

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public BasicTrade build() {
            return new BasicTrade(this.offerStack, this.paymentStack, this.secondaryPaymentStack, this.priceMultiplier, this.maxTrades, this.experience, this.enchantments.toArray(new EnchantmentData[0]), this.potionEffects);
        }

        public Builder setOfferStack(ItemStack offerStack) {
            this.offerStack = offerStack;
            return this;
        }

        public Builder setPaymentStack(ItemStack paymentStack) {
            this.paymentStack = paymentStack;
            return this;
        }

        public Builder setSecondaryPaymentStack(ItemStack secondaryPaymentStack) {
            this.secondaryPaymentStack = secondaryPaymentStack;
            return this;
        }

        public Builder setPriceMultiplier(float priceMultiplier) {
            this.priceMultiplier = priceMultiplier;
            return this;
        }

        public Builder setMaxTrades(int maxTrades) {
            this.maxTrades = maxTrades;
            return this;
        }

        public Builder setExperience(int experience) {
            this.experience = experience;
            return this;
        }

        public Builder addEnchantment(EnchantmentData enchantment) {
            this.enchantments.add(enchantment);
            return this;
        }

        public Builder addPotionEffect(EffectInstance effect) {
            this.potionEffects.add(effect);
            return this;
        }
    }

    public static class Serializer
    extends TradeSerializer<BasicTrade> {
        Serializer() {
            super(new ResourceLocation("goblintraders", "basic"));
        }

        @Override
        public BasicTrade deserialize(JsonObject object) {
            Builder builder = Builder.create();
            builder.setOfferStack(CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)object, (String)"offer_item"), (boolean)true));
            builder.setPaymentStack(CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)object, (String)"payment_item"), (boolean)true));
            if (JSONUtils.func_151204_g((JsonObject)object, (String)"secondary_payment_item")) {
                builder.setSecondaryPaymentStack(CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)object, (String)"secondary_payment_item"), (boolean)true));
            }
            builder.setPriceMultiplier(JSONUtils.func_151221_a((JsonObject)object, (String)"price_multiplier", (float)0.05f));
            builder.setMaxTrades(JSONUtils.func_151208_a((JsonObject)object, (String)"max_trades", (int)12));
            builder.setExperience(JSONUtils.func_151208_a((JsonObject)object, (String)"experience", (int)0));
            if (JSONUtils.func_151204_g((JsonObject)object, (String)"enchantments")) {
                Collection<EnchantmentData> enchantments = this.getEnchantments(JSONUtils.func_151214_t((JsonObject)object, (String)"enchantments"));
                for (EnchantmentData enchantment : enchantments) {
                    builder.addEnchantment(enchantment);
                }
            }
            if (JSONUtils.func_151204_g((JsonObject)object, (String)"potion_effects")) {
                Collection<EffectInstance> effects = this.getPotionEffects(JSONUtils.func_151214_t((JsonObject)object, (String)"potion_effects"));
                for (EffectInstance effect : effects) {
                    builder.addPotionEffect(effect);
                }
            }
            return builder.build();
        }

        @Override
        public JsonObject serialize(BasicTrade trade) {
            JsonObject object = super.serialize(trade);
            object.add("offer_item", (JsonElement)this.serializeItemStack(trade.offerStack));
            object.add("payment_item", (JsonElement)this.serializeItemStack(trade.paymentStack));
            if (!trade.secondaryPaymentStack.func_190926_b()) {
                object.add("secondary_payment_item", (JsonElement)this.serializeItemStack(trade.secondaryPaymentStack));
            }
            if (trade.priceMultiplier != 0.05f) {
                object.addProperty("price_multiplier", (Number)Float.valueOf(trade.priceMultiplier));
            }
            if (trade.maxTrades != 12) {
                object.addProperty("max_trades", (Number)trade.maxTrades);
            }
            if (trade.experience != 0) {
                object.addProperty("experience", (Number)trade.experience);
            }
            if (trade.enchantments.length > 0) {
                JsonArray enchantmentArray = new JsonArray();
                for (EnchantmentData enchantment : trade.enchantments) {
                    enchantmentArray.add((JsonElement)this.serializeEnchantment(enchantment));
                }
                object.add("enchantments", (JsonElement)enchantmentArray);
            }
            if (trade.potionEffects.size() > 0) {
                JsonArray effectArray = new JsonArray();
                for (EffectInstance effect : trade.potionEffects) {
                    effectArray.add((JsonElement)this.serializePotionEffect(effect));
                }
                object.add("potion_effects", (JsonElement)effectArray);
            }
            return object;
        }

        private JsonObject serializeItemStack(ItemStack stack) {
            JsonObject object = new JsonObject();
            object.addProperty("item", Objects.requireNonNull(stack.func_77973_b().getRegistryName()).toString());
            object.addProperty("count", (Number)stack.func_190916_E());
            if (stack.func_77942_o()) {
                object.addProperty("nbt", Objects.requireNonNull(stack.func_77978_p()).toString());
            }
            return object;
        }

        private JsonObject serializeEnchantment(EnchantmentData enchantment) {
            JsonObject object = new JsonObject();
            object.addProperty("id", Objects.requireNonNull(enchantment.field_76302_b.getRegistryName()).toString());
            object.addProperty("level", (Number)enchantment.field_76303_c);
            return object;
        }

        private JsonObject serializePotionEffect(EffectInstance effect) {
            JsonObject object = new JsonObject();
            object.addProperty("id", Objects.requireNonNull(effect.func_188419_a().getRegistryName()).toString());
            object.addProperty("duration", (Number)effect.func_76459_b());
            object.addProperty("amplifier", (Number)effect.func_76458_c());
            object.addProperty("show_particles", Boolean.valueOf(effect.func_188418_e()));
            return object;
        }

        private Collection<EnchantmentData> getEnchantments(JsonArray enchantmentArray) {
            ArrayList<EnchantmentData> enchantments = new ArrayList<EnchantmentData>();
            for (JsonElement enchantmentElement : enchantmentArray) {
                JsonObject enchantmentObject = enchantmentElement.getAsJsonObject();
                String id = JSONUtils.func_151200_h((JsonObject)enchantmentObject, (String)"id");
                Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(id));
                if (enchantment == null) continue;
                int level = JSONUtils.func_151208_a((JsonObject)enchantmentObject, (String)"level", (int)1);
                enchantments.add(new EnchantmentData(enchantment, level));
            }
            return enchantments;
        }

        private Collection<EffectInstance> getPotionEffects(JsonArray effectsArray) {
            ArrayList<EffectInstance> effects = new ArrayList<EffectInstance>();
            for (JsonElement effectElement : effectsArray) {
                JsonObject effectObject = effectElement.getAsJsonObject();
                String id = JSONUtils.func_151200_h((JsonObject)effectObject, (String)"id");
                Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(id));
                if (effect == null) continue;
                int duration = JSONUtils.func_151208_a((JsonObject)effectObject, (String)"duration", (int)1);
                int amplifier = JSONUtils.func_151208_a((JsonObject)effectObject, (String)"amplifier", (int)1);
                boolean showParticles = JSONUtils.func_151209_a((JsonObject)effectObject, (String)"show_particles", (boolean)true);
                effects.add(new EffectInstance(effect, duration, amplifier, false, showParticles));
            }
            return effects;
        }
    }
}

