/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.block;

import com.github.alexthe666.iceandfire.entity.tile.TileEntityPixieHouse;
import com.github.alexthe666.iceandfire.item.ICustomRendered;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockPixieHouse
extends ContainerBlock
implements ICustomRendered {
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);

    public BlockPixieHouse(String type) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_226896_b_().func_208770_d().func_200948_a(2.0f, 5.0f).func_200944_c());
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
        this.setRegistryName("iceandfire", "pixie_house_" + type);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        this.dropPixie(worldIn, pos);
        BlockPixieHouse.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)this, 0));
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public void neighborChanged(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
    }

    public void updateTick(World worldIn, BlockPos pos, BlockState state, Random rand) {
        this.checkFall(worldIn, pos);
    }

    private boolean checkFall(World worldIn, BlockPos pos) {
        if (!this.canPlaceBlockAt(worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
            this.dropPixie(worldIn, pos);
            return false;
        }
        return true;
    }

    private boolean canPlaceBlockAt(World worldIn, BlockPos pos) {
        return true;
    }

    public void dropPixie(World world, BlockPos pos) {
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileEntityPixieHouse && ((TileEntityPixieHouse)world.func_175625_s((BlockPos)pos)).hasPixie) {
            ((TileEntityPixieHouse)world.func_175625_s(pos)).releasePixie();
        }
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityPixieHouse();
    }
}

