/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.server.entity.datatracker.EntityPropertiesHandler;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityGorgon;
import com.github.alexthe666.iceandfire.entity.ai.AquaticAIGetInWater;
import com.github.alexthe666.iceandfire.entity.ai.AquaticAIGetOutOfWater;
import com.github.alexthe666.iceandfire.entity.ai.SirenAIFindWaterTarget;
import com.github.alexthe666.iceandfire.entity.ai.SirenAIWander;
import com.github.alexthe666.iceandfire.entity.props.SirenEntityProperties;
import com.github.alexthe666.iceandfire.entity.util.ChainBuffer;
import com.github.alexthe666.iceandfire.entity.util.IHearsSiren;
import com.github.alexthe666.iceandfire.entity.util.IVillagerFear;
import com.github.alexthe666.iceandfire.event.ServerEvents;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.message.MessageSirenSong;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.github.alexthe666.iceandfire.pathfinding.PathNavigateAmphibious;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntitySiren
extends MonsterEntity
implements IAnimatedEntity,
IVillagerFear {
    public static final int SEARCH_RANGE = 32;
    public static final com.google.common.base.Predicate<Entity> SIREN_PREY = new com.google.common.base.Predicate<Entity>(){

        public boolean apply(@Nullable Entity p_apply_1_) {
            return p_apply_1_ instanceof PlayerEntity && !((PlayerEntity)p_apply_1_).func_184812_l_() && !p_apply_1_.func_175149_v() || p_apply_1_ instanceof AbstractVillagerEntity || p_apply_1_ instanceof IHearsSiren;
        }
    };
    private static final DataParameter<Integer> HAIR_COLOR = EntityDataManager.func_187226_a(EntitySiren.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> AGGRESSIVE = EntityDataManager.func_187226_a(EntitySiren.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> SING_POSE = EntityDataManager.func_187226_a(EntitySiren.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SINGING = EntityDataManager.func_187226_a(EntitySiren.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SWIMMING = EntityDataManager.func_187226_a(EntitySiren.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> CHARMED = EntityDataManager.func_187226_a(EntitySiren.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntitySiren.class, (IDataSerializer)DataSerializers.field_187191_a);
    public static Animation ANIMATION_BITE = Animation.create((int)20);
    public static Animation ANIMATION_PULL = Animation.create((int)20);
    @OnlyIn(value=Dist.CLIENT)
    public ChainBuffer tail_buffer;
    public float singProgress;
    public float swimProgress;
    public int singCooldown;
    private int animationTick;
    private Animation currentAnimation;
    private boolean isSinging;
    private boolean isSwimming;
    private boolean isLandNavigator;
    private int ticksAgressive;

    public EntitySiren(EntityType t, World worldIn) {
        super(t, worldIn);
        this.switchNavigator(true);
        this.field_70138_W = 2.0f;
        this.field_70714_bg.func_75776_a(0, (Goal)new SirenAIFindWaterTarget(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AquaticAIGetInWater((MobEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new AquaticAIGetOutOfWater((MobEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new SirenAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f, 1.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 0, true, false, (Predicate)new com.google.common.base.Predicate<PlayerEntity>(){

            public boolean apply(@Nullable PlayerEntity entity) {
                return EntitySiren.this.isAgressive() && !entity.func_184812_l_() && !entity.func_175149_v();
            }
        }));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, 0, true, false, (Predicate)new com.google.common.base.Predicate<AbstractVillagerEntity>(){

            public boolean apply(@Nullable AbstractVillagerEntity entity) {
                return EntitySiren.this.isAgressive();
            }
        }));
        if (worldIn.field_72995_K) {
            this.tail_buffer = new ChainBuffer();
        }
    }

    public static boolean isWearingEarplugs(LivingEntity entity) {
        ItemStack helmet = entity.func_184582_a(EquipmentSlotType.HEAD);
        return helmet.func_77973_b() == IafItemRegistry.EARPLUGS || helmet != ItemStack.field_190927_a && helmet.func_77973_b().func_77658_a().contains("earmuff");
    }

    public static boolean isDrawnToSong(Entity entity) {
        return entity instanceof PlayerEntity && !((PlayerEntity)entity).func_184812_l_() || entity instanceof AbstractVillagerEntity || entity instanceof IHearsSiren;
    }

    protected int func_70693_a(PlayerEntity player) {
        return 8;
    }

    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h ? 10.0f : super.func_180484_a(pos);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.func_70681_au().nextInt(2) == 0) {
            if (this.getAnimation() != ANIMATION_PULL) {
                this.setAnimation(ANIMATION_PULL);
                this.func_184185_a(IafSoundRegistry.NAGA_ATTACK, 1.0f, 1.0f);
            }
        } else if (this.getAnimation() != ANIMATION_BITE) {
            this.setAnimation(ANIMATION_BITE);
            this.func_184185_a(IafSoundRegistry.NAGA_ATTACK, 1.0f, 1.0f);
        }
        return true;
    }

    public boolean isDirectPathBetweenPoints(Vector3d vec1, Vector3d pos) {
        Vector3d Vector3d1 = new Vector3d(pos.func_82615_a() + 0.5, pos.func_82617_b() + 0.5, pos.func_82616_c() + 0.5);
        return this.field_70170_p.func_217299_a(new RayTraceContext(vec1, Vector3d1, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)).func_216346_c() == RayTraceResult.Type.MISS;
    }

    public float func_184643_a(PathNodeType nodeType) {
        return nodeType == PathNodeType.WATER ? 0.0f : super.func_184643_a(nodeType);
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = new PathNavigateAmphibious((CreatureEntity)this, this.field_70170_p);
            this.isLandNavigator = true;
        } else {
            this.field_70765_h = new SwimmingMoveHelper();
            this.field_70699_by = new SwimmerPathNavigator((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = false;
        }
    }

    private boolean isPathOnHighGround() {
        if (this.field_70699_by != null && this.field_70699_by.func_75505_d() != null && this.field_70699_by.func_75505_d().func_75870_c() != null) {
            BlockPos target = new BlockPos(this.field_70699_by.func_75505_d().func_75870_c().field_75839_a, this.field_70699_by.func_75505_d().func_75870_c().field_75837_b, this.field_70699_by.func_75505_d().func_75870_c().field_75838_c);
            BlockPos siren = this.func_233580_cy_();
            return this.field_70170_p.func_175623_d(siren.func_177984_a()) && this.field_70170_p.func_175623_d(target.func_177984_a()) && target.func_177956_o() >= siren.func_177956_o();
        }
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public void func_70636_d() {
        boolean singing;
        boolean pathOnHighGround;
        super.func_70636_d();
        this.field_70761_aq = this.field_70177_z;
        if (this.singCooldown > 0) {
            --this.singCooldown;
            this.setSinging(false);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null && !this.isAgressive()) {
            this.setSinging(true);
        }
        if (this.getAnimation() == ANIMATION_BITE && this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 7.0 && this.getAnimationTick() == 5) {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e());
        }
        if (this.getAnimation() == ANIMATION_PULL && this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 16.0 && this.getAnimationTick() == 5) {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e());
            double attackmotionX = (Math.signum(this.func_226277_ct_() - this.func_70638_az().func_226277_ct_()) * 0.5 - this.func_70638_az().func_213322_ci().field_72449_c) * 0.100000000372529 * 5.0;
            double attackmotionY = (Math.signum(this.func_226278_cu_() - this.func_70638_az().func_226278_cu_() + 1.0) * 0.5 - this.func_70638_az().func_213322_ci().field_72448_b) * 0.100000000372529 * 5.0;
            double attackmotionZ = (Math.signum(this.func_226281_cx_() - this.func_70638_az().func_226281_cx_()) * 0.5 - this.func_70638_az().func_213322_ci().field_72449_c) * 0.100000000372529 * 5.0;
            this.func_70638_az().func_213317_d(this.func_70638_az().func_213322_ci().func_72441_c(attackmotionX, attackmotionY, attackmotionZ));
            float angle = (float)(Math.atan2(this.func_70638_az().func_213322_ci().field_72449_c, this.func_70638_az().func_213322_ci().field_72450_a) * 180.0 / Math.PI) - 90.0f;
            double d0 = this.func_226277_ct_() - this.func_70638_az().func_226277_ct_();
            double d2 = this.func_226281_cx_() - this.func_70638_az().func_226281_cx_();
            double d1 = this.func_226278_cu_() - 1.0 - this.func_70638_az().func_226278_cu_();
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
            float f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
            this.func_70638_az().field_70125_A = ServerEvents.updateRotation(this.func_70638_az().field_70125_A, f1, 30.0f);
            this.func_70638_az().field_70177_z = ServerEvents.updateRotation(this.func_70638_az().field_70177_z, f, 30.0f);
        }
        if (this.field_70170_p.field_72995_K) {
            this.tail_buffer.calculateChainSwingBuffer(40.0f, 10, 2.5f, (LivingEntity)this);
        }
        this.ticksAgressive = this.isAgressive() ? ++this.ticksAgressive : 0;
        if (this.ticksAgressive > 300 && this.isAgressive() && this.func_70638_az() == null && !this.field_70170_p.field_72995_K) {
            this.setAggressive(false);
            this.ticksAgressive = 0;
            this.setSinging(false);
        }
        if (this.func_70090_H() && !this.func_203007_ba()) {
            this.func_204711_a(true);
        }
        if (!this.func_70090_H() && this.func_203007_ba()) {
            this.func_204711_a(false);
        }
        boolean bl = pathOnHighGround = this.isPathOnHighGround() || this.func_70638_az() != null && !this.func_70638_az().func_70090_H() && !this.func_70638_az().func_70090_H();
        if ((this.func_70638_az() == null || !this.func_70638_az().func_70090_H() && !this.func_70638_az().func_70090_H()) && pathOnHighGround && this.func_70090_H()) {
            this.func_70664_aZ();
            this.func_71061_d_();
        }
        if (this.func_70090_H() && !pathOnHighGround && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (!(this.func_70090_H() && !pathOnHighGround || this.isLandNavigator)) {
            this.switchNavigator(true);
        }
        if (this.func_70638_az() != null && this.func_70638_az() instanceof PlayerEntity && ((PlayerEntity)this.func_70638_az()).func_184812_l_()) {
            this.func_70624_b(null);
            this.setAggressive(false);
        }
        if (this.func_70638_az() != null && !this.isAgressive()) {
            this.setAggressive(true);
        }
        boolean bl2 = singing = this.isActuallySinging() && !this.isAgressive() && !this.func_70090_H() && this.field_70122_E;
        if (singing && this.singProgress < 20.0f) {
            this.singProgress += 1.0f;
        } else if (!singing && this.singProgress > 0.0f) {
            this.singProgress -= 1.0f;
        }
        boolean swimming = this.func_203007_ba();
        if (swimming && this.swimProgress < 20.0f) {
            this.swimProgress += 1.0f;
        } else if (!swimming && this.swimProgress > 0.0f) {
            this.swimProgress -= 0.5f;
        }
        if (!this.field_70170_p.field_72995_K && !EntityGorgon.isStoneMob((LivingEntity)this) && this.isActuallySinging()) {
            this.checkForPrey();
            this.updateLure();
        }
        if (!this.field_70170_p.field_72995_K && EntityGorgon.isStoneMob((LivingEntity)this) && this.isSinging()) {
            this.setSinging(false);
        }
        if (this.isActuallySinging() && !this.func_70090_H() && this.func_70681_au().nextInt(3) == 0) {
            this.field_70761_aq = this.field_70177_z;
            if (this.field_70170_p.field_72995_K) {
                float radius = -0.9f;
                float angle = (float)Math.PI / 180 * this.field_70761_aq - 3.0f;
                double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                double extraY = 1.2f;
                double extraZ = radius * MathHelper.func_76134_b((float)angle);
                IceAndFire.PROXY.spawnParticle("siren_music", this.func_226277_ct_() + extraX + (double)this.field_70146_Z.nextFloat() - 0.5, this.func_226278_cu_() + extraY + (double)this.field_70146_Z.nextFloat() - 0.5, this.func_226281_cx_() + extraZ + (double)this.field_70146_Z.nextFloat() - 0.5, 0.0, 0.0, 0.0);
            }
        }
        if (this.isActuallySinging() && !this.func_70090_H() && this.field_70173_aa % 200 == 0) {
            this.func_184185_a(IafSoundRegistry.SIREN_SONG, 2.0f, 1.0f);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    private void checkForPrey() {
        this.setSinging(true);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() != null && source.func_76346_g() instanceof LivingEntity) {
            this.triggerOtherSirens((LivingEntity)source.func_76346_g());
        }
        return super.func_70097_a(source, amount);
    }

    public void triggerOtherSirens(LivingEntity aggressor) {
        List entities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(12.0, 12.0, 12.0));
        for (Entity entity : entities) {
            if (!(entity instanceof EntitySiren)) continue;
            ((EntitySiren)entity).func_70624_b(aggressor);
            ((EntitySiren)entity).setAggressive(true);
            ((EntitySiren)entity).setSinging(false);
        }
    }

    public void updateLure() {
        if (this.field_70173_aa % 20 == 0) {
            List entities = this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(50.0, 12.0, 50.0), SIREN_PREY);
            for (LivingEntity entity : entities) {
                SirenEntityProperties sirenProps = (SirenEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)entity, SirenEntityProperties.class);
                if (EntitySiren.isWearingEarplugs(entity) || sirenProps == null || sirenProps.isCharmed && sirenProps.getSiren(this.field_70170_p) != null) continue;
                sirenProps.isCharmed = true;
                sirenProps.sirenID = this.func_145782_y();
            }
        }
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74768_a("HairColor", this.getHairColor());
        tag.func_74757_a("Aggressive", this.isAgressive());
        tag.func_74768_a("SingingPose", this.getSingingPose());
        tag.func_74757_a("Singing", this.isSinging());
        tag.func_74757_a("Swimming", this.func_203007_ba());
        tag.func_74757_a("Passive", this.isCharmed());
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.setHairColor(tag.func_74762_e("HairColor"));
        this.setAggressive(tag.func_74767_n("Aggressive"));
        this.setSingingPose(tag.func_74762_e("SingingPose"));
        this.setSinging(tag.func_74767_n("Singing"));
        this.func_204711_a(tag.func_74767_n("Swimming"));
        this.setCharmed(tag.func_74767_n("Passive"));
    }

    public boolean isSinging() {
        if (this.field_70170_p.field_72995_K) {
            this.isSinging = (Boolean)this.field_70180_af.func_187225_a(SINGING);
            return this.isSinging;
        }
        return this.isSinging;
    }

    public void setSinging(boolean singing) {
        if (this.singCooldown > 0) {
            singing = false;
        }
        this.field_70180_af.func_187227_b(SINGING, (Object)singing);
        if (!this.field_70170_p.field_72995_K) {
            this.isSinging = singing;
            IceAndFire.sendMSGToAll(new MessageSirenSong(this.func_145782_y(), singing));
        }
    }

    public boolean wantsToSing() {
        return this.isSinging() && this.func_70090_H() && !this.isAgressive();
    }

    public boolean isActuallySinging() {
        return this.isSinging() && !this.wantsToSing();
    }

    public boolean func_203007_ba() {
        if (this.field_70170_p.field_72995_K) {
            this.isSwimming = (Boolean)this.field_70180_af.func_187225_a(SWIMMING);
            return this.isSwimming;
        }
        return this.isSwimming;
    }

    public void func_204711_a(boolean swimming) {
        this.field_70180_af.func_187227_b(SWIMMING, (Object)swimming);
        if (!this.field_70170_p.field_72995_K) {
            this.isSwimming = swimming;
        }
    }

    public void setAggressive(boolean aggressive) {
        this.field_70180_af.func_187227_b(AGGRESSIVE, (Object)aggressive);
    }

    public boolean isAgressive() {
        return (Boolean)this.field_70180_af.func_187225_a(AGGRESSIVE);
    }

    public boolean isCharmed() {
        return (Boolean)this.field_70180_af.func_187225_a(CHARMED);
    }

    public void setCharmed(boolean aggressive) {
        this.field_70180_af.func_187227_b(CHARMED, (Object)aggressive);
    }

    public int getHairColor() {
        return (Integer)this.field_70180_af.func_187225_a(HAIR_COLOR);
    }

    public void setHairColor(int hairColor) {
        this.field_70180_af.func_187227_b(HAIR_COLOR, (Object)hairColor);
    }

    public int getSingingPose() {
        return (Integer)this.field_70180_af.func_187225_a(SING_POSE);
    }

    public void setSingingPose(int pose) {
        this.field_70180_af.func_187227_b(SING_POSE, (Object)MathHelper.func_76125_a((int)pose, (int)0, (int)2));
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, IafConfig.sirenMaxHealth).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 6.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAIR_COLOR, (Object)0);
        this.field_70180_af.func_187214_a(SING_POSE, (Object)0);
        this.field_70180_af.func_187214_a(AGGRESSIVE, (Object)false);
        this.field_70180_af.func_187214_a(SINGING, (Object)false);
        this.field_70180_af.func_187214_a(SWIMMING, (Object)false);
        this.field_70180_af.func_187214_a(CHARMED, (Object)false);
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setHairColor(this.func_70681_au().nextInt(3));
        this.setSingingPose(this.func_70681_au().nextInt(3));
        return spawnDataIn;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ANIMATION_BITE, ANIMATION_PULL};
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return this.isAgressive() ? IafSoundRegistry.NAGA_IDLE : IafSoundRegistry.MERMAID_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.isAgressive() ? IafSoundRegistry.NAGA_HURT : IafSoundRegistry.MERMAID_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return this.isAgressive() ? IafSoundRegistry.NAGA_DIE : IafSoundRegistry.MERMAID_DIE;
    }

    public void func_213352_e(Vector3d motion) {
        super.func_213352_e(motion);
    }

    public boolean func_104002_bU() {
        return true;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    public boolean shouldFear() {
        return this.isAgressive();
    }

    class SwimmingMoveHelper
    extends MovementController {
        private EntitySiren siren;

        public SwimmingMoveHelper() {
            super((MobEntity)EntitySiren.this);
            this.siren = EntitySiren.this;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                double distanceX = this.field_75646_b - this.siren.func_226277_ct_();
                double distanceY = this.field_75647_c - this.siren.func_226278_cu_();
                double distanceZ = this.field_75644_d - this.siren.func_226281_cx_();
                double distance = Math.abs(distanceX * distanceX + distanceZ * distanceZ);
                double distanceWithY = MathHelper.func_76133_a((double)(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ));
                distanceY /= distanceWithY;
                float angle = (float)(Math.atan2(distanceZ, distanceX) * 180.0 / Math.PI) - 90.0f;
                this.siren.field_70177_z = this.func_75639_a(this.siren.field_70177_z, angle, 30.0f);
                this.siren.func_70659_e(1.0f);
                float f1 = 0.0f;
                float f2 = 0.0f;
                if (distance < (double)Math.max(1.0f, this.siren.func_213311_cf())) {
                    float f = this.siren.field_70177_z * ((float)Math.PI / 180);
                    f1 = (float)((double)f1 - (double)(MathHelper.func_76126_a((float)f) * 0.35f));
                    f2 = (float)((double)f2 + (double)(MathHelper.func_76134_b((float)f) * 0.35f));
                }
                this.siren.func_213317_d(this.siren.func_213322_ci().func_72441_c((double)f1, (double)this.siren.func_70689_ay() * distanceY * 0.1, (double)f2));
            } else if (this.field_188491_h == MovementController.Action.JUMPING) {
                this.siren.func_70659_e((float)(this.field_75645_e * this.siren.func_110148_a(Attributes.field_233821_d_).func_111126_e()));
                if (this.siren.field_70122_E) {
                    this.field_188491_h = MovementController.Action.WAIT;
                }
            } else {
                this.siren.func_70659_e(0.0f);
            }
        }
    }
}

