/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.feature;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.entity.EntitySeaSerpent;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.world.IafWorldRegistry;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class SpawnSeaSerpent
extends Feature<NoFeatureConfig> {
    public SpawnSeaSerpent(Codec<NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator p_230362_3_, Random rand, BlockPos position, NoFeatureConfig p_230362_6_) {
        BlockPos pos;
        if (!IafWorldRegistry.isDimensionListedForMobs((IServerWorld)worldIn)) {
            return false;
        }
        position = worldIn.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, position.func_177982_a(8, 0, 8));
        BlockPos oceanPos = worldIn.func_205770_a(Heightmap.Type.OCEAN_FLOOR_WG, position.func_177982_a(8, 0, 8));
        if (IafConfig.spawnSeaSerpents && IafWorldRegistry.isFarEnoughFromSpawn((IWorld)worldIn, position) && rand.nextInt(IafConfig.seaSerpentSpawnChance + 1) == 0 && worldIn.func_204610_c(pos = oceanPos.func_177982_a(rand.nextInt(10) - 5, rand.nextInt(30), rand.nextInt(10) - 5)).func_206886_c() == Fluids.field_204546_a) {
            EntitySeaSerpent serpent = (EntitySeaSerpent)IafEntityRegistry.SEA_SERPENT.func_200721_a((World)worldIn.func_201672_e());
            serpent.onWorldSpawn(rand);
            serpent.func_70012_b((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f, 0.0f, 0.0f);
            worldIn.func_217376_c((Entity)serpent);
        }
        return false;
    }
}

