/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.block.BlockGoldPile;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityCyclops;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.world.IafWorldRegistry;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.AbstractChestBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class WorldGenCyclopsCave
extends Feature<NoFeatureConfig> {
    public static final ResourceLocation CYCLOPS_CHEST = new ResourceLocation("iceandfire", "chest/cyclops_cave");
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public WorldGenCyclopsCave(Codec<NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    private void genSheepPen(IServerWorld worldIn, BlockPos blockpos, Random rand, BlockPos origin, float radius) {
        int side;
        int sideCount;
        int width = 5 + rand.nextInt(3);
        int sheeps = 2 + rand.nextInt(3);
        int sheepsSpawned = 0;
        Direction direction = Direction.NORTH;
        BlockPos end = blockpos;
        for (sideCount = 0; sideCount < 4; ++sideCount) {
            for (side = 0; side < width; ++side) {
                if (!(origin.func_177951_i((Vector3i)end.func_177967_a(direction, side)) <= (double)(radius * radius))) continue;
                worldIn.func_180501_a(end.func_177967_a(direction, side), this.getFenceState((IWorld)worldIn, end.func_177967_a(direction, side)), 3);
                if (!worldIn.func_175623_d(end.func_177967_a(direction, side).func_177972_a(direction.func_176746_e())) || sheepsSpawned >= sheeps) continue;
                BlockPos sheepPos = end.func_177967_a(direction, side).func_177972_a(direction.func_176746_e());
                SheepEntity entitySheep = new SheepEntity(EntityType.field_200737_ac, (World)worldIn.func_201672_e());
                entitySheep.func_70107_b((double)((float)sheepPos.func_177958_n() + 0.5f), (double)((float)sheepPos.func_177956_o() + 0.5f), (double)((float)sheepPos.func_177952_p() + 0.5f));
                entitySheep.func_175512_b(rand.nextInt(4) == 0 ? DyeColor.YELLOW : DyeColor.WHITE);
                worldIn.func_217376_c((Entity)entitySheep);
                ++sheepsSpawned;
            }
            end = end.func_177967_a(direction, width);
            direction = direction.func_176746_e();
        }
        for (sideCount = 0; sideCount < 4; ++sideCount) {
            for (side = 0; side < width; ++side) {
                if (!(origin.func_177951_i((Vector3i)end.func_177967_a(direction, side)) <= (double)(radius * radius))) continue;
                worldIn.func_180501_a(end.func_177967_a(direction, side), this.getFenceState((IWorld)worldIn, end.func_177967_a(direction, side)), 3);
            }
            end = end.func_177967_a(direction, width);
            direction = direction.func_176746_e();
        }
        for (int x = 1; x < width - 1; ++x) {
            for (int z = 1; z < width - 1; ++z) {
                if (!(origin.func_177951_i((Vector3i)end.func_177982_a(x, 0, z)) <= (double)(radius * radius))) continue;
                worldIn.func_180501_a(end.func_177982_a(x, 0, z), Blocks.field_150350_a.func_176223_P(), 2);
            }
        }
    }

    private boolean isTouchingAir(IWorld worldIn, BlockPos pos) {
        boolean isTouchingAir = true;
        for (Direction direction : HORIZONTALS) {
            if (worldIn.func_175623_d(pos.func_177972_a(direction))) continue;
            isTouchingAir = false;
        }
        return isTouchingAir;
    }

    private void genSkeleton(IWorld worldIn, BlockPos blockpos, Random rand, BlockPos origin, float radius) {
        Direction direction = HORIZONTALS[new Random().nextInt(3)];
        Direction.Axis oppositeAxis = direction.func_176740_k() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        int maxRibHeight = rand.nextInt(2);
        for (int spine = 0; spine < 5 + rand.nextInt(2) * 2; ++spine) {
            BlockPos segment = blockpos.func_177967_a(direction, spine);
            if (origin.func_177951_i((Vector3i)segment) <= (double)(radius * radius)) {
                worldIn.func_180501_a(segment, (BlockState)Blocks.field_189880_di.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)direction.func_176740_k()), 2);
            }
            if (spine % 2 == 0) continue;
            BlockPos rightRib = segment.func_177972_a(direction.func_176735_f());
            BlockPos leftRib = segment.func_177972_a(direction.func_176746_e());
            if (origin.func_177951_i((Vector3i)rightRib) <= (double)(radius * radius)) {
                worldIn.func_180501_a(rightRib, (BlockState)Blocks.field_189880_di.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)oppositeAxis), 2);
            }
            if (origin.func_177951_i((Vector3i)leftRib) <= (double)(radius * radius)) {
                worldIn.func_180501_a(leftRib, (BlockState)Blocks.field_189880_di.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)oppositeAxis), 2);
            }
            for (int ribHeight = 1; ribHeight < maxRibHeight + 2; ++ribHeight) {
                if (origin.func_177951_i((Vector3i)rightRib.func_177981_b(ribHeight).func_177972_a(direction.func_176735_f())) <= (double)(radius * radius)) {
                    worldIn.func_180501_a(rightRib.func_177981_b(ribHeight).func_177972_a(direction.func_176735_f()), (BlockState)Blocks.field_189880_di.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y), 2);
                }
                if (!(origin.func_177951_i((Vector3i)leftRib.func_177981_b(ribHeight).func_177972_a(direction.func_176746_e())) <= (double)(radius * radius))) continue;
                worldIn.func_180501_a(leftRib.func_177981_b(ribHeight).func_177972_a(direction.func_176746_e()), (BlockState)Blocks.field_189880_di.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y), 2);
            }
            if (origin.func_177951_i((Vector3i)rightRib.func_177981_b(maxRibHeight + 2)) <= (double)(radius * radius)) {
                worldIn.func_180501_a(rightRib.func_177981_b(maxRibHeight + 2), (BlockState)Blocks.field_189880_di.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)oppositeAxis), 2);
            }
            if (!(origin.func_177951_i((Vector3i)leftRib.func_177981_b(maxRibHeight + 2)) <= (double)(radius * radius))) continue;
            worldIn.func_180501_a(leftRib.func_177981_b(maxRibHeight + 2), (BlockState)Blocks.field_189880_di.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)oppositeAxis), 2);
        }
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator p_230362_3_, Random rand, BlockPos position, NoFeatureConfig p_230362_6_) {
        if (!IafWorldRegistry.isDimensionListedForFeatures((IServerWorld)worldIn)) {
            return false;
        }
        if (!IafConfig.generateCyclopsCaves || rand.nextInt(IafConfig.spawnCyclopsCaveChance) != 0 || !IafWorldRegistry.isFarEnoughFromSpawn((IWorld)worldIn, position)) {
            return false;
        }
        if (!worldIn.func_204610_c((position = worldIn.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, position)).func_177977_b()).func_206888_e()) {
            return false;
        }
        int i1 = 16;
        int i2 = i1 - 2;
        int sheepPenCount = 0;
        int dist = 6;
        if (worldIn.func_175623_d(position.func_177982_a(i1 - dist, -3, -i1 + dist)) || worldIn.func_175623_d(position.func_177982_a(i1 - dist, -3, i1 - dist)) || worldIn.func_175623_d(position.func_177982_a(-i1 + dist, -3, -i1 + dist)) || worldIn.func_175623_d(position.func_177982_a(-i1 + dist, -3, i1 - dist))) {
            return false;
        }
        int ySize = rand.nextInt(2);
        int j = i1 + rand.nextInt(2);
        int k = 12 + ySize;
        int l = i1 + rand.nextInt(2);
        float f = (float)(j + k + l) * 0.333f + 0.5f;
        for (BlockPos blockpos : BlockPos.func_218281_b((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
            boolean isNotInDoorway;
            boolean doorwayX = blockpos.func_177958_n() >= position.func_177958_n() - 2 + rand.nextInt(2) && blockpos.func_177958_n() <= position.func_177958_n() + 2 + rand.nextInt(2);
            boolean doorwayZ = blockpos.func_177952_p() >= position.func_177952_p() - 2 + rand.nextInt(2) && blockpos.func_177952_p() <= position.func_177952_p() + 2 + rand.nextInt(2);
            boolean bl = isNotInDoorway = !doorwayX && !doorwayZ && blockpos.func_177956_o() > position.func_177956_o() || blockpos.func_177956_o() > position.func_177956_o() + k - (3 + rand.nextInt(2));
            if (!(blockpos.func_177951_i((Vector3i)position) <= (double)(f * f))) continue;
            if (!(worldIn.func_180495_p(position).func_177230_c() instanceof AbstractChestBlock) && worldIn.func_180495_p(position).func_185887_b((IBlockReader)worldIn, position) >= 0.0f && isNotInDoorway) {
                worldIn.func_180501_a(blockpos, Blocks.field_150348_b.func_176223_P(), 3);
            }
            if (blockpos.func_177956_o() == position.func_177956_o()) {
                worldIn.func_180501_a(blockpos, Blocks.field_150341_Y.func_176223_P(), 3);
            }
            if (blockpos.func_177956_o() > position.func_177956_o() - 1 || worldIn.func_180495_p(blockpos).func_200132_m()) continue;
            worldIn.func_180501_a(blockpos, Blocks.field_150347_e.func_176223_P(), 3);
        }
        ySize = rand.nextInt(2);
        j = i2 + rand.nextInt(2);
        k = 10 + ySize;
        l = i2 + rand.nextInt(2);
        f = (float)(j + k + l) * 0.333f + 0.5f;
        for (BlockPos blockpos : BlockPos.func_218281_b((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
            if (!(blockpos.func_177951_i((Vector3i)position) <= (double)(f * f)) || blockpos.func_177956_o() <= position.func_177956_o() || worldIn.func_180495_p(position).func_177230_c() instanceof AbstractChestBlock) continue;
            worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 3);
        }
        for (BlockPos blockpos : BlockPos.func_218281_b((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
            if (!(blockpos.func_177951_i((Vector3i)position) <= (double)(f * f)) || blockpos.func_177956_o() != position.func_177956_o()) continue;
            if (rand.nextInt(130) == 0 && this.isTouchingAir((IWorld)worldIn, blockpos.func_177984_a())) {
                this.genSkeleton((IWorld)worldIn, blockpos.func_177984_a(), rand, position, f);
            }
            if (rand.nextInt(130) == 0 && blockpos.func_177951_i((Vector3i)position) <= (double)(f * f) * (double)0.8f && sheepPenCount < 2) {
                this.genSheepPen((IServerWorld)worldIn, blockpos.func_177984_a(), rand, position, f);
                ++sheepPenCount;
            }
            if (rand.nextInt(80) == 0 && this.isTouchingAir((IWorld)worldIn, blockpos.func_177984_a())) {
                TileEntity tileentity1;
                worldIn.func_180501_a(blockpos.func_177984_a(), (BlockState)IafBlockRegistry.GOLD_PILE.func_176223_P().func_206870_a((Property)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(8)), 3);
                worldIn.func_180501_a(blockpos.func_177984_a().func_177978_c(), (BlockState)IafBlockRegistry.GOLD_PILE.func_176223_P().func_206870_a((Property)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
                worldIn.func_180501_a(blockpos.func_177984_a().func_177968_d(), (BlockState)IafBlockRegistry.GOLD_PILE.func_176223_P().func_206870_a((Property)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
                worldIn.func_180501_a(blockpos.func_177984_a().func_177976_e(), (BlockState)IafBlockRegistry.GOLD_PILE.func_176223_P().func_206870_a((Property)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
                worldIn.func_180501_a(blockpos.func_177984_a().func_177974_f(), (BlockState)IafBlockRegistry.GOLD_PILE.func_176223_P().func_206870_a((Property)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
                worldIn.func_180501_a(blockpos.func_177981_b(2), (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((Property)ChestBlock.field_176459_a, (Comparable)HORIZONTALS[new Random().nextInt(3)]), 2);
                if (worldIn.func_180495_p(blockpos.func_177981_b(2)).func_177230_c() instanceof AbstractChestBlock && (tileentity1 = worldIn.func_175625_s(blockpos.func_177981_b(2))) instanceof ChestTileEntity) {
                    ((ChestTileEntity)tileentity1).func_189404_a(CYCLOPS_CHEST, rand.nextLong());
                }
            }
            if (rand.nextInt(50) != 0 || !this.isTouchingAir((IWorld)worldIn, blockpos.func_177984_a())) continue;
            int torchHeight = rand.nextInt(2) + 1;
            for (int fence = 0; fence < torchHeight; ++fence) {
                worldIn.func_180501_a(blockpos.func_177981_b(1 + fence), this.getFenceState((IWorld)worldIn, blockpos.func_177981_b(1 + fence)), 3);
            }
            worldIn.func_180501_a(blockpos.func_177981_b(1 + torchHeight), Blocks.field_150478_aa.func_176223_P(), 2);
        }
        EntityCyclops cyclops = new EntityCyclops(IafEntityRegistry.CYCLOPS, (World)worldIn.func_201672_e());
        cyclops.setVariant(rand.nextInt(3));
        cyclops.func_70080_a((double)position.func_177958_n() + 0.5, (double)position.func_177956_o() + 1.5, (double)position.func_177952_p() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
        worldIn.func_217376_c((Entity)cyclops);
        return true;
    }

    public BlockState getFenceState(IWorld world, BlockPos pos) {
        boolean east = world.func_180495_p(pos.func_177974_f()).func_177230_c() == Blocks.field_180407_aO;
        boolean west = world.func_180495_p(pos.func_177976_e()).func_177230_c() == Blocks.field_180407_aO;
        boolean north = world.func_180495_p(pos.func_177978_c()).func_177230_c() == Blocks.field_180407_aO;
        boolean south = world.func_180495_p(pos.func_177968_d()).func_177230_c() == Blocks.field_180407_aO;
        return (BlockState)((BlockState)((BlockState)((BlockState)Blocks.field_180407_aO.func_176223_P().func_206870_a((Property)FenceBlock.field_196411_b, (Comparable)Boolean.valueOf(east))).func_206870_a((Property)FenceBlock.field_196414_y, (Comparable)Boolean.valueOf(west))).func_206870_a((Property)FenceBlock.field_196409_a, (Comparable)Boolean.valueOf(north))).func_206870_a((Property)FenceBlock.field_196413_c, (Comparable)Boolean.valueOf(south));
    }
}

