/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client;

import com.bobmowzie.mowziesmobs.client.model.entity.ModelGeckoPlayerFirstPerson;
import com.bobmowzie.mowziesmobs.client.model.entity.ModelGeckoPlayerThirdPerson;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoFirstPersonRenderer;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoPlayer;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoRenderPlayer;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.AbilityCapability;
import com.bobmowzie.mowziesmobs.server.capability.CapabilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.FrozenCapability;
import com.bobmowzie.mowziesmobs.server.capability.PlayerCapability;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityCameraShake;
import com.bobmowzie.mowziesmobs.server.entity.frostmaw.EntityFrozenController;
import com.bobmowzie.mowziesmobs.server.item.ItemBlowgun;
import com.bobmowzie.mowziesmobs.server.potion.EffectHandler;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

@OnlyIn(value=Dist.CLIENT)
public enum ClientEventHandler {
    INSTANCE;

    private static final ResourceLocation FROZEN_BLUR;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onHandRender(RenderHandEvent event) {
        GeckoPlayer.GeckoPlayerFirstPerson geckoPlayer;
        PlayerCapability.IPlayerCapability playerCapability;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        boolean shouldAnimate = false;
        AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)player);
        if (abilityCapability != null) {
            boolean bl = shouldAnimate = abilityCapability.getActiveAbility() != null;
        }
        if (shouldAnimate && (playerCapability = CapabilityHandler.getCapability((Entity)player, PlayerCapability.PlayerProvider.PLAYER_CAPABILITY)) != null && (geckoPlayer = GeckoFirstPersonRenderer.GECKO_PLAYER_FIRST_PERSON) != null) {
            ModelGeckoPlayerFirstPerson geckoFirstPersonModel = (ModelGeckoPlayerFirstPerson)geckoPlayer.getModel();
            GeckoFirstPersonRenderer firstPersonRenderer = (GeckoFirstPersonRenderer)geckoPlayer.getPlayerRenderer();
            if (geckoFirstPersonModel != null && firstPersonRenderer != null) {
                firstPersonRenderer.setSmallArms();
                event.setCanceled(geckoFirstPersonModel.resourceForModelId((AbstractClientPlayerEntity)player));
                if (event.isCanceled()) {
                    float delta = event.getPartialTicks();
                    float f1 = MathHelper.func_219799_g((float)delta, (float)player.field_70127_C, (float)player.field_70125_A);
                    firstPersonRenderer.renderItemInFirstPerson((AbstractClientPlayerEntity)player, f1, delta, event.getHand(), event.getSwingProgress(), event.getItemStack(), event.getEquipProgress(), event.getMatrixStack(), event.getBuffers(), event.getLight(), geckoPlayer);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void renderLivingEvent(RenderLivingEvent.Pre<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> event) {
        if (event.getEntity() instanceof PlayerEntity) {
            GeckoPlayer.GeckoPlayerThirdPerson geckoPlayer;
            PlayerCapability.IPlayerCapability playerCapability;
            PlayerEntity player = (PlayerEntity)event.getEntity();
            if (player == null) {
                return;
            }
            float delta = event.getPartialRenderTick();
            boolean shouldAnimate = player.func_70644_a((Effect)EffectHandler.FROZEN);
            AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)player);
            if (abilityCapability != null) {
                boolean bl = shouldAnimate = shouldAnimate || abilityCapability.getActiveAbility() != null;
            }
            if (shouldAnimate && (playerCapability = CapabilityHandler.getCapability((Entity)event.getEntity(), PlayerCapability.PlayerProvider.PLAYER_CAPABILITY)) != null && (geckoPlayer = playerCapability.getGeckoPlayer()) != null) {
                ModelGeckoPlayerThirdPerson geckoPlayerModel = (ModelGeckoPlayerThirdPerson)geckoPlayer.getModel();
                GeckoRenderPlayer animatedPlayerRenderer = (GeckoRenderPlayer)geckoPlayer.getPlayerRenderer();
                if (geckoPlayerModel != null && animatedPlayerRenderer != null) {
                    if (!geckoPlayerModel.isUsingSmallArms() && ((AbstractClientPlayerEntity)player).func_175154_l().equals("slim")) {
                        animatedPlayerRenderer.setSmallArms();
                    }
                    event.setCanceled(geckoPlayerModel.resourceForModelId((AbstractClientPlayerEntity)player));
                    if (event.isCanceled()) {
                        animatedPlayerRenderer.render((AbstractClientPlayerEntity)event.getEntity(), event.getEntity().field_70177_z, delta, event.getMatrixStack(), event.getBuffers(), event.getLight(), geckoPlayer);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
    }

    @SubscribeEvent
    public void onRenderLiving(RenderLivingEvent.Pre event) {
        LivingEntity entity = event.getEntity();
        FrozenCapability.IFrozenCapability frozenCapability = CapabilityHandler.getCapability((Entity)entity, FrozenCapability.FrozenProvider.FROZEN_CAPABILITY);
        if (frozenCapability != null && entity.func_70644_a((Effect)EffectHandler.FROZEN) && frozenCapability.getPrevFrozen()) {
            entity.field_70177_z = entity.field_70126_B = frozenCapability.getFrozenYaw();
            entity.field_70125_A = entity.field_70127_C = frozenCapability.getFrozenPitch();
            entity.field_70759_as = entity.field_70758_at = frozenCapability.getFrozenYawHead();
            entity.field_70761_aq = entity.field_70760_ar = frozenCapability.getFrozenRenderYawOffset();
            entity.field_70733_aJ = entity.field_70732_aI = frozenCapability.getFrozenSwingProgress();
            entity.field_70721_aZ = entity.field_184618_aE = frozenCapability.getFrozenLimbSwingAmount();
            entity.func_226284_e_(false);
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post e) {
        int startTime = 210;
        int pointStart = 1200;
        int timePerMillis = 22;
        if (e.getType() == RenderGameOverlayEvent.ElementType.POTION_ICONS && Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_70644_a((Effect)EffectHandler.FROZEN) && Minecraft.func_71410_x().field_71474_y.func_243230_g() == PointOfView.FIRST_PERSON) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(FROZEN_BLUR);
            MainWindow res = e.getWindow();
            AbstractGui.func_238463_a_((MatrixStack)e.getMatrixStack(), (int)0, (int)0, (float)0.0f, (float)0.0f, (int)res.func_198107_o(), (int)res.func_198087_p(), (int)res.func_198107_o(), (int)res.func_198087_p());
        }
    }

    @SubscribeEvent
    public void onRenderHUD(RenderGameOverlayEvent.Pre event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.func_184218_aH() && player.func_184187_bx() instanceof EntityFrozenController) {
            if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.HEALTHMOUNT)) {
                event.setCanceled(true);
            }
            if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.ALL)) {
                Minecraft.func_71410_x().field_71456_v.func_175188_a((ITextComponent)new TranslationTextComponent(""), false);
            }
        }
    }

    @SubscribeEvent
    public void updateFOV(FOVUpdateEvent event) {
        PlayerEntity player = event.getEntity();
        if (player.func_184587_cr() && player.func_184607_cu().func_77973_b() instanceof ItemBlowgun) {
            int i = player.func_184612_cw();
            float f1 = (float)i / 5.0f;
            f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
            event.setNewfov(1.0f - f1 * 0.15f);
        }
    }

    @SubscribeEvent
    public void onSetupCamera(EntityViewRenderEvent.CameraSetup event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        float delta = Minecraft.func_71410_x().func_184121_ak();
        float ticksExistedDelta = (float)player.field_70173_aa + delta;
        if (player != null) {
            FrozenCapability.IFrozenCapability frozenCapability;
            PlayerCapability.IPlayerCapability playerCapability = CapabilityHandler.getCapability((Entity)player, PlayerCapability.PlayerProvider.PLAYER_CAPABILITY);
            if (playerCapability != null && playerCapability.getGeomancy().canUse((PlayerEntity)player) && playerCapability.getGeomancy().isSpawningBoulder() && playerCapability.getGeomancy().getSpawnBoulderCharge() > 2) {
                Vector3d lookPos = playerCapability.getGeomancy().getLookPos();
                Vector3d playerEyes = player.func_174824_e(delta);
                Vector3d vec = playerEyes.func_178788_d(lookPos).func_72432_b();
                float yaw = (float)Math.atan2(vec.field_72449_c, vec.field_72450_a);
                float pitch = (float)Math.asin(vec.field_72448_b);
                player.field_70177_z = (float)((double)(yaw * 180.0f) / Math.PI + 90.0);
                player.field_70125_A = (float)((double)(pitch * 180.0f) / Math.PI);
                player.field_70759_as = player.field_70177_z;
                player.field_70126_B = player.field_70177_z;
                player.field_70127_C = player.field_70125_A;
                player.field_70758_at = player.field_70759_as;
                event.setPitch(pitch);
                event.setYaw(yaw);
            }
            if ((frozenCapability = CapabilityHandler.getCapability((Entity)player, FrozenCapability.FrozenProvider.FROZEN_CAPABILITY)) != null && player.func_70644_a((Effect)EffectHandler.FROZEN) && frozenCapability.getPrevFrozen()) {
                player.field_70177_z = frozenCapability.getFrozenYaw();
                player.field_70125_A = frozenCapability.getFrozenPitch();
                player.field_70759_as = frozenCapability.getFrozenYawHead();
                player.field_70126_B = player.field_70177_z;
                player.field_70127_C = player.field_70125_A;
                player.field_70758_at = player.field_70759_as;
                event.setPitch(frozenCapability.getFrozenPitch());
                event.setYaw(frozenCapability.getFrozenYaw());
            }
            if (((Boolean)ConfigHandler.CLIENT.doCameraShakes.get()).booleanValue()) {
                float shakeAmplitude = 0.0f;
                for (EntityCameraShake cameraShake : player.field_70170_p.func_217357_a(EntityCameraShake.class, player.func_174813_aQ().func_72314_b(20.0, 20.0, 20.0))) {
                    if (!(cameraShake.func_70032_d((Entity)player) < cameraShake.getRadius())) continue;
                    shakeAmplitude += cameraShake.getShakeAmount((PlayerEntity)player, delta);
                }
                if (shakeAmplitude > 1.0f) {
                    shakeAmplitude = 1.0f;
                }
                event.setPitch((float)((double)event.getPitch() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 3.0f + 2.0f) * 25.0));
                event.setYaw((float)((double)event.getYaw() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 5.0f + 1.0f) * 25.0));
                event.setRoll((float)((double)event.getRoll() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 4.0f) * 25.0));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.player == null) {
            return;
        }
        PlayerEntity player = event.player;
        PlayerCapability.IPlayerCapability playerCapability = CapabilityHandler.getCapability((Entity)player, PlayerCapability.PlayerProvider.PLAYER_CAPABILITY);
        if (playerCapability != null && event.side == LogicalSide.CLIENT) {
            GeckoPlayer.GeckoPlayerThirdPerson geckoPlayer = playerCapability.getGeckoPlayer();
            if (geckoPlayer != null) {
                geckoPlayer.tick();
            }
            if (player == Minecraft.func_71410_x().field_71439_g) {
                GeckoFirstPersonRenderer.GECKO_PLAYER_FIRST_PERSON.tick();
            }
        }
    }

    static {
        FROZEN_BLUR = new ResourceLocation("mowziesmobs", "textures/gui/frozenblur.png");
    }
}

