/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity;

import com.bobmowzie.mowziesmobs.client.model.entity.ModelBarako;
import com.bobmowzie.mowziesmobs.client.render.MMRenderType;
import com.bobmowzie.mowziesmobs.client.render.RenderUtils;
import com.bobmowzie.mowziesmobs.client.render.entity.RenderSunstrike;
import com.bobmowzie.mowziesmobs.client.render.entity.layer.SunblockLayer;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarako;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderBarako
extends MobRenderer<EntityBarako, ModelBarako<EntityBarako>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("mowziesmobs", "textures/entity/barako.png");
    private static final ResourceLocation TEXTURE_OLD = new ResourceLocation("mowziesmobs", "textures/entity/barako_old.png");
    private static final float BURST_RADIUS = 3.5f;
    private static final int BURST_FRAME_COUNT = 10;
    private static final int BURST_START_FRAME = 12;

    public RenderBarako(EntityRendererManager mgr) {
        super(mgr, new ModelBarako(), 1.0f);
        this.func_177094_a(new SunblockLayer(this));
    }

    protected float getDeathMaxRotation(EntityBarako entity) {
        return 0.0f;
    }

    public ResourceLocation getEntityTexture(EntityBarako entity) {
        return (Boolean)ConfigHandler.CLIENT.oldBarakoaTextures.get() != false ? TEXTURE_OLD : TEXTURE;
    }

    public void render(EntityBarako barako, float entityYaw, float delta, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (!barako.func_82150_aj() && barako.getAnimation() == EntityBarako.ATTACK_ANIMATION && barako.getAnimationTick() > 12 && barako.getAnimationTick() < 21) {
            matrixStackIn.func_227860_a_();
            Quaternion quat = this.field_76990_c.func_229098_b_();
            matrixStackIn.func_227863_a_(quat);
            matrixStackIn.func_227861_a_(0.0, 1.0, 0.0);
            matrixStackIn.func_227862_a_(0.8f, 0.8f, 0.8f);
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(MMRenderType.getSolarFlare(RenderSunstrike.TEXTURE));
            MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
            Matrix4f matrix4f = matrixstack$entry.func_227870_a_();
            Matrix3f matrix3f = matrixstack$entry.func_227872_b_();
            this.drawBurst(matrix4f, matrix3f, ivertexbuilder, (float)(barako.getAnimationTick() - 12) + delta, packedLightIn);
            matrixStackIn.func_227865_b_();
        }
        super.func_225623_a_((MobEntity)barako, entityYaw, delta, matrixStackIn, bufferIn, packedLightIn);
        if (barako.getAnimation() == EntityBarako.SUPERNOVA_ANIMATION && barako.betweenHandPos != null && barako.betweenHandPos.length > 0) {
            barako.betweenHandPos[0] = RenderUtils.getWorldPosFromModel((Entity)barako, entityYaw, ((ModelBarako)this.func_217764_d()).betweenHands);
        }
    }

    private void drawBurst(Matrix4f matrix4f, Matrix3f matrix3f, IVertexBuilder builder, float tick, int packedLightIn) {
        int frame;
        int dissapateFrame = 6;
        float firstSpeed = 2.0f;
        float secondSpeed = 1.0f;
        int n = frame = (int)(tick * firstSpeed) <= dissapateFrame ? (int)(tick * firstSpeed) : (int)((float)dissapateFrame + (tick - (float)dissapateFrame / firstSpeed) * secondSpeed);
        if (frame > 10) {
            frame = 10;
        }
        float minU = 0.0625f * (float)frame;
        float maxU = minU + 0.0625f;
        float minV = 0.5f;
        float maxV = minV + 0.5f;
        float offset = 0.219f * (float)(frame % 2);
        float opacity = tick < 8.0f ? 0.8f : 0.4f;
        this.drawVertex(matrix4f, matrix3f, builder, -3.5f + offset, -3.5f + offset, 0.0f, minU, minV, opacity, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, -3.5f + offset, 3.5f + offset, 0.0f, minU, maxV, opacity, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 3.5f + offset, 3.5f + offset, 0.0f, maxU, maxV, opacity, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 3.5f + offset, -3.5f + offset, 0.0f, maxU, minV, opacity, packedLightIn);
    }

    public void drawVertex(Matrix4f matrix, Matrix3f normals, IVertexBuilder vertexBuilder, float offsetX, float offsetY, float offsetZ, float textureX, float textureY, float alpha, int packedLightIn) {
        vertexBuilder.func_227888_a_(matrix, offsetX, offsetY, offsetZ).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f * alpha).func_225583_a_(textureX, textureY).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLightIn).func_227887_a_(normals, 0.0f, 1.0f, 0.0f).func_181675_d();
    }
}

