/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity;

import com.bobmowzie.mowziesmobs.client.render.MMRenderType;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySunstrike;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderSunstrike
extends EntityRenderer<EntitySunstrike> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("mowziesmobs", "textures/effects/sunstrike.png");
    private static final Random RANDOMIZER = new Random(0L);
    private static final float TEXTURE_WIDTH = 256.0f;
    private static final float TEXTURE_HEIGHT = 32.0f;
    private static final float BEAM_MIN_U = 0.875f;
    private static final float BEAM_MAX_U = 1.0f;
    private static final float PIXEL_SCALE = 0.0625f;
    private static final int MAX_HEIGHT = 256;
    private static final float DRAW_FADE_IN_RATE = 2.0f;
    private static final float DRAW_FADE_IN_POINT = 0.5f;
    private static final float DRAW_OPACITY_MULTIPLER = 0.7f;
    private static final float RING_RADIUS = 1.6f;
    private static final int RING_FRAME_SIZE = 16;
    private static final int RING_FRAME_COUNT = 10;
    private static final int BREAM_FRAME_COUNT = 31;
    private static final float BEAM_DRAW_START_RADIUS = 2.0f;
    private static final float BEAM_DRAW_END_RADIUS = 0.25f;
    private static final float BEAM_STRIKE_RADIUS = 1.0f;
    private static final float LINGER_RADIUS = 1.2f;
    private static final float SCORCH_MIN_U = 0.75f;
    private static final float SCORCH_MAX_U = 0.8125f;
    private static final float SCORCH_MIN_V = 0.5f;
    private static final float SCORCH_MAX_V = 1.0f;

    public RenderSunstrike(EntityRendererManager mgr) {
        super(mgr);
    }

    public ResourceLocation getEntityTexture(EntitySunstrike entity) {
        return TEXTURE;
    }

    public void render(EntitySunstrike sunstrike, float entityYaw, float delta, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        float maxY = (float)(256.0 - sunstrike.func_226278_cu_());
        if (maxY < 0.0f) {
            return;
        }
        RANDOMIZER.setSeed(sunstrike.getVariant());
        boolean isLingering = sunstrike.isLingering(delta);
        boolean isStriking = sunstrike.isStriking(delta);
        matrixStackIn.func_227860_a_();
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(MMRenderType.getGlowingEffect(TEXTURE));
        if (isLingering) {
            this.drawScorch(sunstrike, delta, matrixStackIn, ivertexbuilder, packedLightIn);
        } else if (isStriking) {
            this.drawStrike(sunstrike, maxY, delta, matrixStackIn, ivertexbuilder, packedLightIn);
        }
        matrixStackIn.func_227865_b_();
    }

    private void drawScorch(EntitySunstrike sunstrike, float delta, MatrixStack matrixStack, IVertexBuilder builder, int packedLightIn) {
        World world = sunstrike.func_130014_f_();
        double ex = sunstrike.field_70142_S + (sunstrike.func_226277_ct_() - sunstrike.field_70142_S) * (double)delta;
        double ey = sunstrike.field_70137_T + (sunstrike.func_226278_cu_() - sunstrike.field_70137_T) * (double)delta;
        double ez = sunstrike.field_70136_U + (sunstrike.func_226281_cx_() - sunstrike.field_70136_U) * (double)delta;
        int minX = MathHelper.func_76128_c((double)(ex - (double)1.2f));
        int maxX = MathHelper.func_76128_c((double)(ex + (double)1.2f));
        int minY = MathHelper.func_76128_c((double)(ey - (double)1.2f));
        int maxY = MathHelper.func_76128_c((double)ey);
        int minZ = MathHelper.func_76128_c((double)(ez - (double)1.2f));
        int maxZ = MathHelper.func_76128_c((double)(ez + (double)1.2f));
        float opacityMultiplier = (0.6f + RANDOMIZER.nextFloat() * 0.2f) * (float)world.func_201696_r(new BlockPos(ex, ey, ez));
        byte mirrorX = (byte)(RANDOMIZER.nextBoolean() ? -1 : 1);
        byte mirrorZ = (byte)(RANDOMIZER.nextBoolean() ? -1 : 1);
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)new BlockPos(minX, minY, minZ), (BlockPos)new BlockPos(maxX, maxY, maxZ))) {
            BlockState block = world.func_180495_p(pos.func_177977_b());
            if (block.func_185904_a() == Material.field_151579_a || world.func_201696_r(pos) <= 3) continue;
            this.drawScorchBlock(world, block, pos, ex, ey, ez, opacityMultiplier, mirrorX, mirrorZ, matrixStack, builder, packedLightIn);
        }
    }

    private void drawScorchBlock(World world, BlockState block, BlockPos pos, double ex, double ey, double ez, float opacityMultiplier, byte mirrorX, byte mirrorZ, MatrixStack matrixStack, IVertexBuilder builder, int packedLightIn) {
        MatrixStack.Entry matrixstack$entry = matrixStack.func_227866_c_();
        Matrix4f matrix4f = matrixstack$entry.func_227870_a_();
        Matrix3f matrix3f = matrixstack$entry.func_227872_b_();
        if (block.func_215686_e((IBlockReader)world, pos)) {
            int bx = pos.func_177958_n();
            int by = pos.func_177956_o();
            int bz = pos.func_177952_p();
            float opacity = (float)((1.0 - (ey - (double)by) / 2.0) * (double)opacityMultiplier);
            if (opacity >= 0.0f) {
                if (opacity > 1.0f) {
                    opacity = 1.0f;
                }
                AxisAlignedBB aabb = block.func_196951_e((IBlockReader)world, pos).func_197752_a();
                float minX = (float)((double)bx + aabb.field_72340_a - ex);
                float maxX = (float)((double)bx + aabb.field_72336_d - ex);
                float y = (float)((double)by + aabb.field_72338_b - ey + 0.015625);
                float minZ = (float)((double)bz + aabb.field_72339_c - ez);
                float maxZ = (float)((double)bz + aabb.field_72334_f - ez);
                float minU = ((float)mirrorX * minX / 2.0f / 1.2f + 0.5f) * 0.0625f + 0.75f;
                float maxU = ((float)mirrorX * maxX / 2.0f / 1.2f + 0.5f) * 0.0625f + 0.75f;
                float minV = ((float)mirrorZ * minZ / 2.0f / 1.2f + 0.5f) * 0.5f + 0.5f;
                float maxV = ((float)mirrorZ * maxZ / 2.0f / 1.2f + 0.5f) * 0.5f + 0.5f;
                this.drawVertex(matrix4f, matrix3f, builder, minX, y, minZ, minU, minV, opacity, packedLightIn);
                this.drawVertex(matrix4f, matrix3f, builder, minX, y, maxZ, minU, maxV, opacity, packedLightIn);
                this.drawVertex(matrix4f, matrix3f, builder, maxX, y, maxZ, maxU, maxV, opacity, packedLightIn);
                this.drawVertex(matrix4f, matrix3f, builder, maxX, y, minZ, maxU, minV, opacity, packedLightIn);
            }
        }
    }

    private void drawStrike(EntitySunstrike sunstrike, float maxY, float delta, MatrixStack matrixStack, IVertexBuilder builder, int packedLightIn) {
        float opacity;
        float drawTime = sunstrike.getStrikeDrawTime(delta);
        float strikeTime = sunstrike.getStrikeDamageTime(delta);
        boolean drawing = sunstrike.isStrikeDrawing(delta);
        float f = opacity = drawing && drawTime < 0.5f ? drawTime * 2.0f : 1.0f;
        if (drawing) {
            opacity *= 0.7f;
        }
        this.drawRing(drawing, drawTime, strikeTime, opacity, matrixStack, builder, packedLightIn);
        matrixStack.func_227863_a_(new Quaternion(0.0f, -Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216778_f(), 0.0f, true));
        this.drawBeam(drawing, drawTime, strikeTime, opacity, maxY, matrixStack, builder, packedLightIn);
    }

    private void drawRing(boolean drawing, float drawTime, float strikeTime, float opacity, MatrixStack matrixStack, IVertexBuilder builder, int packedLightIn) {
        int frame = (int)((drawing ? drawTime : strikeTime) * 11.0f);
        if (frame > 10) {
            frame = 10;
        }
        float minU = (float)(frame * 16) / 256.0f;
        float maxU = minU + 0.0625f;
        float minV = drawing ? 0.0f : 0.5f;
        float maxV = minV + 0.5f;
        float offset = 0.1f * (float)(frame % 2);
        MatrixStack.Entry matrixstack$entry = matrixStack.func_227866_c_();
        Matrix4f matrix4f = matrixstack$entry.func_227870_a_();
        Matrix3f matrix3f = matrixstack$entry.func_227872_b_();
        this.drawVertex(matrix4f, matrix3f, builder, -1.6f + offset, 0.0f, -1.6f + offset, minU, minV, opacity, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, -1.6f + offset, 0.0f, 1.6f + offset, minU, maxV, opacity, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 1.6f + offset, 0.0f, 1.6f + offset, maxU, maxV, opacity, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 1.6f + offset, 0.0f, -1.6f + offset, maxU, minV, opacity, packedLightIn);
    }

    private void drawBeam(boolean drawing, float drawTime, float strikeTime, float opacity, float maxY, MatrixStack matrixStack, IVertexBuilder builder, int packedLightIn) {
        int frame;
        int n = frame = drawing ? 0 : (int)(strikeTime * 32.0f);
        if (frame > 31) {
            frame = 31;
        }
        float radius = 1.0f;
        if (drawing) {
            radius = -1.75f * drawTime + 2.0f;
        }
        float minV = (float)frame / 32.0f;
        float maxV = (float)(frame + 1) / 32.0f;
        MatrixStack.Entry matrixstack$entry = matrixStack.func_227866_c_();
        Matrix4f matrix4f = matrixstack$entry.func_227870_a_();
        Matrix3f matrix3f = matrixstack$entry.func_227872_b_();
        this.drawVertex(matrix4f, matrix3f, builder, -radius, 0.0f, 0.0f, 0.875f, minV, opacity, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, -radius, maxY, 0.0f, 0.875f, maxV, opacity, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, radius, maxY, 0.0f, 1.0f, maxV, opacity, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, radius, 0.0f, 0.0f, 1.0f, minV, opacity, packedLightIn);
    }

    public void drawVertex(Matrix4f matrix, Matrix3f normals, IVertexBuilder vertexBuilder, float offsetX, float offsetY, float offsetZ, float textureX, float textureY, float alpha, int packedLightIn) {
        vertexBuilder.func_227888_a_(matrix, offsetX, offsetY, offsetZ).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f * alpha).func_225583_a_(textureX, textureY).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLightIn).func_227887_a_(normals, 0.0f, 1.0f, 0.0f).func_181675_d();
    }
}

