/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity.player;

import com.bobmowzie.mowziesmobs.client.model.entity.ModelGeckoPlayerFirstPerson;
import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieGeoBone;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoPlayer;
import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.capability.AbilityCapability;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib3.core.IAnimatableModel;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.geo.render.built.GeoCube;
import software.bernie.geckolib3.model.provider.GeoModelProvider;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;
import software.bernie.geckolib3.util.RenderUtils;

@OnlyIn(value=Dist.CLIENT)
public class GeckoFirstPersonRenderer
extends FirstPersonRenderer
implements IGeoRenderer<GeckoPlayer> {
    public static GeckoPlayer.GeckoPlayerFirstPerson GECKO_PLAYER_FIRST_PERSON;
    private static HashMap<Class<? extends GeckoPlayer>, GeckoFirstPersonRenderer> modelsToLoad;
    private ModelGeckoPlayerFirstPerson modelProvider;
    boolean mirror;

    public GeckoFirstPersonRenderer(Minecraft mcIn, ModelGeckoPlayerFirstPerson modelProvider) {
        super(mcIn);
        this.modelProvider = modelProvider;
    }

    public GeckoFirstPersonRenderer getModelProvider(Class<? extends GeckoPlayer> animatable) {
        return modelsToLoad.get(animatable);
    }

    public HashMap<Class<? extends GeckoPlayer>, GeckoFirstPersonRenderer> getModelsToLoad() {
        return modelsToLoad;
    }

    public void renderItemInFirstPerson(AbstractClientPlayerEntity player, float pitch, float partialTicks, Hand handIn, float swingProgress, ItemStack stack, float equippedProgress, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, GeckoPlayer geckoPlayer) {
        boolean flag = handIn == Hand.MAIN_HAND;
        HandSide handside = flag ? player.func_184591_cq() : player.func_184591_cq().func_188468_a();
        boolean bl = this.mirror = player.func_184591_cq() == HandSide.LEFT;
        if (flag) {
            this.modelProvider.setLivingAnimations(geckoPlayer, (Integer)player.func_110124_au().hashCode());
            RenderType rendertype = RenderType.func_239268_f_((ResourceLocation)this.getTextureLocation(geckoPlayer));
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(rendertype);
            matrixStackIn.func_227861_a_(0.0, -2.0, -1.0);
            this.render(this.getGeoModelProvider().getModel(this.getGeoModelProvider().getModelLocation((Object)geckoPlayer)), geckoPlayer, partialTicks, rendertype, matrixStackIn, bufferIn, ivertexbuilder, combinedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        Ability.HandDisplay handDisplay = Ability.HandDisplay.DEFAULT;
        float offHandEquipProgress = 0.0f;
        AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)player);
        if (abilityCapability != null && abilityCapability.getActiveAbility() != null) {
            ItemStack stackOverride;
            Ability ability = abilityCapability.getActiveAbility();
            ItemStack itemStack = stackOverride = flag ? ability.heldItemMainHandOverride() : ability.heldItemOffHandOverride();
            if (stackOverride != null) {
                stack = stackOverride;
            }
            Ability.HandDisplay handDisplay2 = handDisplay = flag ? ability.getFirstPersonMainHandDisplay() : ability.getFirstPersonOffHandDisplay();
            if (ability.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.STARTUP) {
                offHandEquipProgress = MathHelper.func_76131_a((float)(1.0f - ((float)ability.getTicksInSection() + partialTicks) / 5.0f), (float)0.0f, (float)1.0f);
            } else if (ability.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.RECOVERY && ability.getCurrentSection() instanceof AbilitySection.AbilitySectionDuration) {
                offHandEquipProgress = MathHelper.func_76131_a((float)(((float)ability.getTicksInSection() + partialTicks - (float)((AbilitySection.AbilitySectionDuration)ability.getCurrentSection()).duration + 5.0f) / 5.0f), (float)0.0f, (float)1.0f);
            }
        }
        if (handDisplay != Ability.HandDisplay.DONT_RENDER && this.modelProvider.isInitialized()) {
            int sideMult;
            int n = sideMult = handside == HandSide.RIGHT ? -1 : 1;
            if (this.mirror) {
                handside = handside.func_188468_a();
            }
            String sideName = handside == HandSide.RIGHT ? "Right" : "Left";
            String boneName = sideName + "Arm";
            MowzieGeoBone bone = this.modelProvider.getMowzieBone(boneName);
            MatrixStack newMatrixStack = new MatrixStack();
            float fixedPitchController = 1.0f - this.modelProvider.getControllerValue("FixedPitchController" + sideName);
            newMatrixStack.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, pitch * fixedPitchController, true));
            newMatrixStack.func_227866_c_().func_227872_b_().func_226118_b_(bone.getWorldSpaceNormal());
            newMatrixStack.func_227866_c_().func_227870_a_().func_226595_a_(bone.getWorldSpaceXform());
            newMatrixStack.func_227861_a_((double)sideMult * 0.547, 0.7655, 0.625);
            if (this.mirror) {
                handside = handside.func_188468_a();
            }
            if (stack.func_190926_b() && !flag && handDisplay == Ability.HandDisplay.FORCE_RENDER && !player.func_82150_aj()) {
                newMatrixStack.func_227861_a_(0.0, (double)(-1.0f * offHandEquipProgress), 0.0);
                super.func_228401_a_(newMatrixStack, bufferIn, combinedLightIn, 0.0f, 0.0f, handside);
            } else {
                super.func_228405_a_(player, partialTicks, pitch, handIn, 0.0f, stack, 0.0f, newMatrixStack, bufferIn, combinedLightIn);
            }
        }
    }

    public void setSmallArms() {
        this.modelProvider.setUseSmallArms(true);
    }

    public GeoModelProvider<GeckoPlayer> getGeoModelProvider() {
        return this.modelProvider;
    }

    public ModelGeckoPlayerFirstPerson getAnimatedPlayerModel() {
        return this.modelProvider;
    }

    public ResourceLocation getTextureLocation(GeckoPlayer geckoPlayer) {
        return ((AbstractClientPlayerEntity)geckoPlayer.getPlayer()).func_110306_p();
    }

    public void renderRecursively(GeoBone bone, MatrixStack matrixStack, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        matrixStack.func_227860_a_();
        if (this.mirror) {
            GeckoFirstPersonRenderer.translateMirror(bone, matrixStack);
            GeckoFirstPersonRenderer.moveToPivotMirror(bone, matrixStack);
            GeckoFirstPersonRenderer.rotateMirror(bone, matrixStack);
            RenderUtils.scale((GeoBone)bone, (MatrixStack)matrixStack);
        } else {
            RenderUtils.translate((GeoBone)bone, (MatrixStack)matrixStack);
            RenderUtils.moveToPivot((GeoBone)bone, (MatrixStack)matrixStack);
            RenderUtils.rotate((GeoBone)bone, (MatrixStack)matrixStack);
            RenderUtils.scale((GeoBone)bone, (MatrixStack)matrixStack);
        }
        if (bone instanceof MowzieGeoBone) {
            MowzieGeoBone mowzieBone = (MowzieGeoBone)bone;
            if (mowzieBone.name.equals("LeftArm") || mowzieBone.name.equals("RightArm")) {
                matrixStack.func_227860_a_();
                MatrixStack.Entry entry = matrixStack.func_227866_c_();
                mowzieBone.setWorldSpaceNormal(entry.func_227872_b_().func_226121_d_());
                mowzieBone.setWorldSpaceXform(entry.func_227870_a_().func_226601_d_());
                matrixStack.func_227865_b_();
            }
        }
        if (this.mirror) {
            GeckoFirstPersonRenderer.moveBackFromPivotMirror(bone, matrixStack);
        } else {
            RenderUtils.moveBackFromPivot((GeoBone)bone, (MatrixStack)matrixStack);
        }
        if (!bone.isHidden) {
            for (GeoCube cube : bone.childCubes) {
                matrixStack.func_227860_a_();
                this.renderCube(cube, matrixStack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
                matrixStack.func_227865_b_();
            }
            for (GeoBone childBone : bone.childBones) {
                this.renderRecursively(childBone, matrixStack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            }
        }
        matrixStack.func_227865_b_();
    }

    public static void moveToPivotMirror(GeoCube cube, MatrixStack stack) {
        Vector3f pivot = cube.pivot;
        stack.func_227861_a_((double)(-pivot.func_195899_a() / 16.0f), (double)(pivot.func_195900_b() / 16.0f), (double)(pivot.func_195902_c() / 16.0f));
    }

    public static void moveBackFromPivotMirror(GeoCube cube, MatrixStack stack) {
        Vector3f pivot = cube.pivot;
        stack.func_227861_a_((double)(pivot.func_195899_a() / 16.0f), (double)(-pivot.func_195900_b() / 16.0f), (double)(-pivot.func_195902_c() / 16.0f));
    }

    public static void moveToPivotMirror(GeoBone bone, MatrixStack stack) {
        stack.func_227861_a_((double)(-bone.rotationPointX / 16.0f), (double)(bone.rotationPointY / 16.0f), (double)(bone.rotationPointZ / 16.0f));
    }

    public static void moveBackFromPivotMirror(GeoBone bone, MatrixStack stack) {
        stack.func_227861_a_((double)(bone.rotationPointX / 16.0f), (double)(-bone.rotationPointY / 16.0f), (double)(-bone.rotationPointZ / 16.0f));
    }

    public static void translateMirror(GeoBone bone, MatrixStack stack) {
        stack.func_227861_a_((double)(bone.getPositionX() / 16.0f), (double)(bone.getPositionY() / 16.0f), (double)(bone.getPositionZ() / 16.0f));
    }

    public static void rotateMirror(GeoBone bone, MatrixStack stack) {
        if (bone.getRotationZ() != 0.0f) {
            stack.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(-bone.getRotationZ()));
        }
        if (bone.getRotationY() != 0.0f) {
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(-bone.getRotationY()));
        }
        if (bone.getRotationX() != 0.0f) {
            stack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(bone.getRotationX()));
        }
    }

    public static void rotateMirror(GeoCube bone, MatrixStack stack) {
        Vector3f rotation = bone.rotation;
        stack.func_227863_a_(new Quaternion(0.0f, 0.0f, -rotation.func_195902_c(), false));
        stack.func_227863_a_(new Quaternion(0.0f, -rotation.func_195900_b(), 0.0f, false));
        stack.func_227863_a_(new Quaternion(rotation.func_195899_a(), 0.0f, 0.0f, false));
    }

    static {
        modelsToLoad = new HashMap();
        AnimationController.addModelFetcher(object -> {
            if (object instanceof GeckoPlayer.GeckoPlayerFirstPerson) {
                GeckoFirstPersonRenderer render = modelsToLoad.get(object.getClass());
                return (IAnimatableModel)render.getGeoModelProvider();
            }
            return null;
        });
    }
}

