/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity.player;

import com.bobmowzie.mowziesmobs.client.model.entity.ModelGeckoPlayerFirstPerson;
import com.bobmowzie.mowziesmobs.client.model.entity.ModelGeckoPlayerThirdPerson;
import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieAnimatedGeoModel;
import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieAnimationController;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoFirstPersonRenderer;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoRenderPlayer;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.AbilityCapability;
import com.bobmowzie.mowziesmobs.server.capability.CapabilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.PlayerCapability;
import com.bobmowzie.mowziesmobs.server.entity.IAnimationTickable;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;
import software.bernie.geckolib3.util.GeckoLibUtil;

@OnlyIn(value=Dist.CLIENT)
public abstract class GeckoPlayer
implements IAnimatable,
IAnimationTickable {
    protected IGeoRenderer<GeckoPlayer> renderer;
    protected MowzieAnimatedGeoModel<GeckoPlayer> model;
    private int tickTimer = 0;
    private PlayerEntity player;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public static final String THIRD_PERSON_CONTROLLER_NAME = "thirdPersonAnimation";
    public static final String FIRST_PERSON_CONTROLLER_NAME = "firstPersonAnimation";

    public GeckoPlayer(PlayerEntity player) {
        this.player = player;
        this.setup(player);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new MowzieAnimationController<GeckoPlayer>(this, this.getControllerName(), 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public PlayerEntity getPlayer() {
        return this.player;
    }

    @Override
    public void tick() {
        ++this.tickTimer;
    }

    @Override
    public int tickTimer() {
        return this.tickTimer;
    }

    public <E extends IAnimatable> PlayState predicate(AnimationEvent<E> e) {
        e.getController().transitionLengthTicks = 0.0;
        PlayerEntity player = this.getPlayer();
        if (player == null) {
            return PlayState.STOP;
        }
        AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)player);
        if (abilityCapability == null) {
            return PlayState.STOP;
        }
        if (abilityCapability.getActiveAbility() != null) {
            return abilityCapability.animationPredicate(e, this.getPerspective());
        }
        e.getController().setAnimation(new AnimationBuilder().addAnimation("idle"));
        return PlayState.CONTINUE;
    }

    @Nullable
    public static GeckoPlayer getGeckoPlayer(PlayerEntity player, Perspective perspective) {
        if (perspective == Perspective.FIRST_PERSON) {
            return GeckoFirstPersonRenderer.GECKO_PLAYER_FIRST_PERSON;
        }
        PlayerCapability.IPlayerCapability playerCapability = CapabilityHandler.getCapability((Entity)player, PlayerCapability.PlayerProvider.PLAYER_CAPABILITY);
        if (playerCapability != null) {
            return playerCapability.getGeckoPlayer();
        }
        return null;
    }

    public static MowzieAnimationController<GeckoPlayer> getAnimationController(PlayerEntity player, Perspective perspective) {
        GeckoPlayer geckoPlayer;
        PlayerCapability.IPlayerCapability playerCapability = CapabilityHandler.getCapability((Entity)player, PlayerCapability.PlayerProvider.PLAYER_CAPABILITY);
        if (playerCapability != null && (geckoPlayer = perspective == Perspective.FIRST_PERSON ? GeckoFirstPersonRenderer.GECKO_PLAYER_FIRST_PERSON : playerCapability.getGeckoPlayer()) != null) {
            String name = perspective == Perspective.FIRST_PERSON ? FIRST_PERSON_CONTROLLER_NAME : THIRD_PERSON_CONTROLLER_NAME;
            return (MowzieAnimationController)GeckoLibUtil.getControllerForID((AnimationFactory)geckoPlayer.getFactory(), (Integer)player.func_110124_au().hashCode(), (String)name);
        }
        return null;
    }

    public IGeoRenderer<GeckoPlayer> getPlayerRenderer() {
        return this.renderer;
    }

    public MowzieAnimatedGeoModel<GeckoPlayer> getModel() {
        return this.model;
    }

    public abstract String getControllerName();

    public abstract Perspective getPerspective();

    public abstract void setup(PlayerEntity var1);

    public static class GeckoPlayerThirdPerson
    extends GeckoPlayer {
        public GeckoPlayerThirdPerson(PlayerEntity player) {
            super(player);
        }

        @Override
        public String getControllerName() {
            return GeckoPlayer.THIRD_PERSON_CONTROLLER_NAME;
        }

        @Override
        public Perspective getPerspective() {
            return Perspective.THIRD_PERSON;
        }

        @Override
        public void setup(PlayerEntity player) {
            ModelGeckoPlayerThirdPerson modelGeckoPlayer = new ModelGeckoPlayerThirdPerson();
            this.model = modelGeckoPlayer;
            this.model.resourceForModelId((AbstractClientPlayerEntity)player);
            GeckoRenderPlayer geckoRenderer = new GeckoRenderPlayer(Minecraft.func_71410_x().func_175598_ae(), modelGeckoPlayer);
            this.renderer = geckoRenderer;
            if (!geckoRenderer.getModelsToLoad().containsKey(this.getClass())) {
                geckoRenderer.getModelsToLoad().put(this.getClass(), geckoRenderer);
            }
        }
    }

    public static class GeckoPlayerFirstPerson
    extends GeckoPlayer {
        public GeckoPlayerFirstPerson(PlayerEntity player) {
            super(player);
        }

        @Override
        public String getControllerName() {
            return GeckoPlayer.FIRST_PERSON_CONTROLLER_NAME;
        }

        @Override
        public Perspective getPerspective() {
            return Perspective.FIRST_PERSON;
        }

        @Override
        public void setup(PlayerEntity player) {
            ModelGeckoPlayerFirstPerson modelGeckoPlayer = new ModelGeckoPlayerFirstPerson();
            this.model = modelGeckoPlayer;
            this.model.resourceForModelId((AbstractClientPlayerEntity)player);
            GeckoFirstPersonRenderer geckoRenderer = new GeckoFirstPersonRenderer(Minecraft.func_71410_x(), modelGeckoPlayer);
            this.renderer = geckoRenderer;
            if (!geckoRenderer.getModelsToLoad().containsKey(this.getClass())) {
                geckoRenderer.getModelsToLoad().put(this.getClass(), geckoRenderer);
            }
        }
    }

    public static enum Perspective {
        FIRST_PERSON,
        THIRD_PERSON;

    }
}

