/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ability;

import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieAnimatedGeoModel;
import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieAnimationController;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoPlayer;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.capability.AbilityCapability;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;

public class Ability {
    private final AbilitySection[] sectionTrack;
    private final int cooldownMax;
    private final AbilityType<? extends Ability> abilityType;
    private final LivingEntity user;
    private final AbilityCapability.IAbilityCapability abilityCapability;
    private int ticksInUse;
    private int ticksInSection;
    private int currentSectionIndex;
    private boolean isUsing;
    private int cooldownTimer;
    protected Random rand;
    protected AnimationBuilder activeThirdPersonAnimation;
    protected AnimationBuilder activeFirstPersonAnimation;
    protected ItemStack heldItemMainHandVisualOverride;
    protected ItemStack heldItemOffHandVisualOverride;
    protected HandDisplay firstPersonMainHandDisplay;
    protected HandDisplay firstPersonOffHandDisplay;

    public Ability(AbilityType<? extends Ability> abilityType, LivingEntity user, AbilitySection[] sectionTrack, int cooldownMax) {
        this.abilityType = abilityType;
        this.user = user;
        this.abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability(user);
        this.sectionTrack = sectionTrack;
        this.cooldownMax = cooldownMax;
        this.rand = new Random();
        if (user.field_70170_p.field_72995_K) {
            this.activeThirdPersonAnimation = new AnimationBuilder().addAnimation("idle");
            this.heldItemMainHandVisualOverride = null;
            this.heldItemOffHandVisualOverride = null;
            this.firstPersonMainHandDisplay = HandDisplay.DEFAULT;
            this.firstPersonOffHandDisplay = HandDisplay.DEFAULT;
        }
    }

    public Ability(AbilityType<? extends Ability> abilityType, LivingEntity user, AbilitySection[] sectionTrack) {
        this(abilityType, user, sectionTrack, 0);
    }

    public void start() {
        if (!this.runsInBackground()) {
            this.abilityCapability.setActiveAbility(this);
        }
        this.ticksInUse = 0;
        this.ticksInSection = 0;
        this.currentSectionIndex = 0;
        this.isUsing = true;
    }

    public void playAnimation(String animationName, GeckoPlayer.Perspective perspective, boolean shouldLoop) {
        if (this.getUser() instanceof PlayerEntity && this.getUser().field_70170_p.func_201670_d()) {
            AnimationBuilder newActiveAnimation = new AnimationBuilder().addAnimation(animationName, Boolean.valueOf(shouldLoop));
            if (perspective == GeckoPlayer.Perspective.FIRST_PERSON) {
                this.activeFirstPersonAnimation = newActiveAnimation;
            } else {
                this.activeThirdPersonAnimation = newActiveAnimation;
            }
            MowzieAnimationController<GeckoPlayer> controller = GeckoPlayer.getAnimationController((PlayerEntity)this.getUser(), perspective);
            GeckoPlayer geckoPlayer = GeckoPlayer.getGeckoPlayer((PlayerEntity)this.getUser(), perspective);
            if (controller != null && geckoPlayer != null) {
                controller.playAnimation(geckoPlayer, newActiveAnimation);
            }
        }
    }

    public void playAnimation(String animationName, boolean shouldLoop) {
        this.playAnimation(animationName, GeckoPlayer.Perspective.FIRST_PERSON, shouldLoop);
        this.playAnimation(animationName, GeckoPlayer.Perspective.THIRD_PERSON, shouldLoop);
    }

    public void tick() {
        if (this.isUsing()) {
            if (this.getUser().func_70613_aW() && !this.canContinueUsing()) {
                AbilityHandler.INSTANCE.sendInterruptAbilityMessage(this.getUser(), this.abilityType);
            }
            this.tickUsing();
            ++this.ticksInUse;
            ++this.ticksInSection;
            AbilitySection section = this.getCurrentSection();
            if (section instanceof AbilitySection.AbilitySectionInstant) {
                this.nextSection();
            } else if (section instanceof AbilitySection.AbilitySectionDuration) {
                AbilitySection.AbilitySectionDuration sectionDuration = (AbilitySection.AbilitySectionDuration)section;
                if (this.ticksInSection > sectionDuration.duration) {
                    this.nextSection();
                }
            }
        } else {
            this.tickNotUsing();
            if (this.getCooldownTimer() > 0) {
                --this.cooldownTimer;
            }
        }
    }

    public void tickUsing() {
    }

    public void tickNotUsing() {
    }

    public void end() {
        this.ticksInUse = 0;
        this.ticksInSection = 0;
        this.isUsing = false;
        this.cooldownTimer = this.getMaxCooldown();
        this.currentSectionIndex = 0;
        if (!this.runsInBackground()) {
            this.abilityCapability.setActiveAbility(null);
        }
        if (this.getUser().field_70170_p.field_72995_K) {
            this.heldItemMainHandVisualOverride = null;
            this.heldItemOffHandVisualOverride = null;
            this.firstPersonMainHandDisplay = HandDisplay.DEFAULT;
            this.firstPersonOffHandDisplay = HandDisplay.DEFAULT;
        }
    }

    public void interrupt() {
        this.end();
    }

    public void complete() {
        this.end();
    }

    public boolean canUse() {
        boolean nonBackgroundCheck = this.runsInBackground() || this.abilityCapability.getActiveAbility() == null || this.canCancelActiveAbility();
        return (!this.isUsing() || this.canCancelActiveAbility()) && this.cooldownTimer == 0 && nonBackgroundCheck;
    }

    public boolean tryAbility() {
        return true;
    }

    public boolean canCancelActiveAbility() {
        return false;
    }

    protected boolean canContinueUsing() {
        return true;
    }

    public boolean isUsing() {
        return this.isUsing;
    }

    public LivingEntity getUser() {
        return this.user;
    }

    public int getTicksInUse() {
        return this.ticksInUse;
    }

    public int getTicksInSection() {
        return this.ticksInSection;
    }

    public int getCooldownTimer() {
        return this.cooldownTimer;
    }

    public void nextSection() {
        this.jumpToSection(this.currentSectionIndex + 1);
    }

    public void jumpToSection(int sectionIndex) {
        this.currentSectionIndex = sectionIndex;
        this.ticksInSection = 0;
        if (this.currentSectionIndex >= this.getSectionTrack().length) {
            this.complete();
        } else {
            this.beginSection(this.getCurrentSection());
        }
    }

    protected void beginSection(AbilitySection section) {
    }

    public AbilitySection getCurrentSection() {
        if (this.currentSectionIndex >= this.getSectionTrack().length) {
            return null;
        }
        return this.getSectionTrack()[this.currentSectionIndex];
    }

    public boolean runsInBackground() {
        return false;
    }

    public boolean preventsAttacking() {
        return true;
    }

    public boolean preventsBlockBreakingBuilding() {
        return true;
    }

    public boolean preventsInteracting() {
        return true;
    }

    public AbilitySection[] getSectionTrack() {
        return this.sectionTrack;
    }

    public int getMaxCooldown() {
        return this.cooldownMax;
    }

    public AbilityCapability.IAbilityCapability getAbilityCapability() {
        return this.abilityCapability;
    }

    public <E extends IAnimatable> PlayState animationPredicate(AnimationEvent<E> e, GeckoPlayer.Perspective perspective) {
        AnimationBuilder whichAnimation = perspective == GeckoPlayer.Perspective.FIRST_PERSON ? this.activeFirstPersonAnimation : this.activeThirdPersonAnimation;
        if (whichAnimation == null || whichAnimation.getRawAnimationList().isEmpty()) {
            return PlayState.STOP;
        }
        e.getController().setAnimation(whichAnimation);
        return PlayState.CONTINUE;
    }

    public void codeAnimations(MowzieAnimatedGeoModel<? extends IAnimatable> model, float partialTick) {
    }

    public boolean isAnimating() {
        return this.isUsing();
    }

    public List<LivingEntity> getEntityLivingBaseNearby(LivingEntity player, double distanceX, double distanceY, double distanceZ, double radius) {
        return this.getEntitiesNearby(player, LivingEntity.class, distanceX, distanceY, distanceZ, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(LivingEntity player, Class<T> entityClass, double r) {
        return player.field_70170_p.func_175647_a(entityClass, player.func_174813_aQ().func_72314_b(r, r, r), e -> e != player && (double)player.func_70032_d(e) <= r);
    }

    public <T extends Entity> List<T> getEntitiesNearby(LivingEntity player, Class<T> entityClass, double dX, double dY, double dZ, double r) {
        return player.field_70170_p.func_175647_a(entityClass, player.func_174813_aQ().func_72314_b(dX, dY, dZ), e -> e != player && (double)player.func_70032_d(e) <= r);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack heldItemMainHandOverride() {
        return this.heldItemMainHandVisualOverride;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack heldItemOffHandOverride() {
        return this.heldItemOffHandVisualOverride;
    }

    @OnlyIn(value=Dist.CLIENT)
    public HandDisplay getFirstPersonMainHandDisplay() {
        return this.firstPersonMainHandDisplay;
    }

    @OnlyIn(value=Dist.CLIENT)
    public HandDisplay getFirstPersonOffHandDisplay() {
        return this.firstPersonOffHandDisplay;
    }

    public CompoundNBT writeNBT() {
        CompoundNBT compound = new CompoundNBT();
        if (this.isUsing()) {
            compound.func_74768_a("ticks_in_use", this.ticksInUse);
            compound.func_74768_a("ticks_in_section", this.ticksInSection);
            compound.func_74768_a("current_section", this.currentSectionIndex);
        } else if (this.cooldownTimer > 0) {
            compound.func_74768_a("cooldown_timer", this.cooldownTimer);
        }
        return compound;
    }

    public void readNBT(INBT nbt) {
        CompoundNBT compound = (CompoundNBT)nbt;
        this.isUsing = compound.func_74764_b("ticks_in_use");
        if (this.isUsing) {
            this.ticksInUse = compound.func_74762_e("ticks_in_use");
            this.ticksInSection = compound.func_74762_e("ticks_in_section");
            this.currentSectionIndex = compound.func_74762_e("current_section");
        } else {
            this.cooldownTimer = compound.func_74762_e("cooldown_timer");
        }
    }

    public void onRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
    }

    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
    }

    public void onRightClickWithItem(PlayerInteractEvent.RightClickItem event) {
    }

    public void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
    }

    public void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
    }

    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
    }

    public void onLeftClickEntity(AttackEntityEvent event) {
    }

    public void onTakeDamage(LivingHurtEvent event) {
    }

    public void onJump(LivingEvent.LivingJumpEvent event) {
    }

    public void onRightMouseDown(PlayerEntity player) {
    }

    public void onLeftMouseDown(PlayerEntity player) {
    }

    public void onRightMouseUp(PlayerEntity player) {
    }

    public void onLeftMouseUp(PlayerEntity player) {
    }

    public void onSneakDown(PlayerEntity player) {
    }

    public void onSneakUp(PlayerEntity player) {
    }

    public void onRenderTick(TickEvent.RenderTickEvent event) {
    }

    public static enum HandDisplay {
        DEFAULT,
        DONT_RENDER,
        FORCE_RENDER;

    }
}

