/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ability.abilities;

import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityIceBreath;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;

public class IceBreathAbility
extends Ability {
    protected EntityIceBreath iceBreath;

    public IceBreathAbility(AbilityType<IceBreathAbility> abilityType, LivingEntity user) {
        super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 6), new AbilitySection.AbilitySectionInfinite(AbilitySection.AbilitySectionType.ACTIVE), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 6)});
    }

    @Override
    public void start() {
        super.start();
        LivingEntity user = this.getUser();
        if (!this.getUser().field_70170_p.func_201670_d()) {
            EntityIceBreath iceBreath = new EntityIceBreath((EntityType<? extends EntityIceBreath>)((EntityType)EntityHandler.ICE_BREATH.get()), user.field_70170_p, user);
            iceBreath.func_70080_a(user.func_226277_ct_(), user.func_226278_cu_() + (double)user.func_70047_e() - 0.5, user.func_226281_cx_(), user.field_70177_z, user.field_70125_A);
            user.field_70170_p.func_217376_c((Entity)iceBreath);
            this.iceBreath = iceBreath;
        }
        this.playAnimation("ice_breath_start", false);
        if (this.getUser().func_184600_cs() == Hand.MAIN_HAND) {
            this.heldItemMainHandVisualOverride = this.getUser().func_184614_ca();
            this.heldItemOffHandVisualOverride = ItemStack.field_190927_a;
            this.firstPersonOffHandDisplay = Ability.HandDisplay.DONT_RENDER;
        } else {
            this.heldItemOffHandVisualOverride = this.getUser().func_184592_cb();
            this.heldItemMainHandVisualOverride = ItemStack.field_190927_a;
            this.firstPersonMainHandDisplay = Ability.HandDisplay.DONT_RENDER;
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getCurrentSection().sectionType != AbilitySection.AbilitySectionType.RECOVERY && !this.checkIceCrystal()) {
            this.jumpToSection(2);
        }
    }

    @Override
    public void end() {
        super.end();
        if (this.iceBreath != null) {
            this.iceBreath.func_70106_y();
        }
    }

    private boolean checkIceCrystal() {
        ItemStack stack = this.getUser().func_184607_cu();
        if (this.getTicksInUse() <= 1) {
            return true;
        }
        if (stack.func_77973_b() != ItemHandler.ICE_CRYSTAL) {
            return false;
        }
        return stack.func_77952_i() + 5 < stack.func_77958_k() || (Boolean)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.ICE_CRYSTAL.breakable.get() != false;
    }

    @Override
    public boolean canUse() {
        return this.checkIceCrystal() && super.canUse();
    }

    @Override
    protected void beginSection(AbilitySection section) {
        super.beginSection(section);
        if (section.sectionType == AbilitySection.AbilitySectionType.STARTUP) {
            this.playAnimation("ice_breath_start", false);
        } else if (section.sectionType == AbilitySection.AbilitySectionType.ACTIVE) {
            this.playAnimation("ice_breath_loop", true);
        } else if (section.sectionType == AbilitySection.AbilitySectionType.RECOVERY) {
            this.playAnimation("ice_breath_end", false);
        }
    }
}

