/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ability.abilities;

import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieAnimatedGeoModel;
import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieGeoBone;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleData;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoPlayer;
import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityBlockSwapper;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityFallingBlock;
import com.bobmowzie.mowziesmobs.server.potion.EffectGeomancy;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.google.common.base.Supplier;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;

public class TunnelingAbility
extends Ability {
    private int doubleTapTimer = 0;
    public boolean prevUnderground;
    public BlockState justDug = Blocks.field_150346_d.func_176223_P();
    boolean underground = false;
    private float spinAmount = 0.0f;
    private float pitch = 0.0f;
    private int timeUnderground = 0;

    public TunnelingAbility(AbilityType<? extends Ability> abilityType, LivingEntity user) {
        super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionInfinite(AbilitySection.AbilitySectionType.ACTIVE)});
    }

    @Override
    public void tickNotUsing() {
        super.tickNotUsing();
        if (this.doubleTapTimer > 0) {
            --this.doubleTapTimer;
        }
    }

    @Override
    public void start() {
        super.start();
        this.underground = false;
        this.prevUnderground = false;
        if (this.getUser().field_70170_p.func_201670_d()) {
            this.spinAmount = 0.0f;
            this.pitch = 0.0f;
        }
    }

    @Override
    public void tickUsing() {
        super.tickUsing();
        this.getUser().field_70143_R = 0.0f;
        if (this.getUser() instanceof PlayerEntity) {
            ((PlayerEntity)this.getUser()).field_71075_bZ.field_75100_b = false;
        }
        this.underground = !this.getUser().field_70170_p.func_217357_a(EntityBlockSwapper.class, this.getUser().func_174813_aQ().func_186662_g(0.5)).isEmpty();
        Vector3d lookVec = this.getUser().func_70040_Z();
        float tunnelSpeed = 0.3f;
        if (this.underground) {
            ++this.timeUnderground;
            if (this.getUser().func_225608_bj_()) {
                this.getUser().func_213317_d(lookVec.func_72432_b().func_186678_a((double)tunnelSpeed));
            } else {
                this.getUser().func_213317_d(lookVec.func_216372_d(0.3, 0.0, 0.3).func_72441_c(0.0, 1.0, 0.0).func_72432_b().func_186678_a((double)tunnelSpeed));
            }
            List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(this.getUser(), 2.0, 2.0, 2.0, 2.0);
            for (LivingEntity entityHit : entitiesHit) {
                DamageSource damageSource = DamageSource.func_76358_a((LivingEntity)this.getUser());
                if (this.getUser() instanceof PlayerEntity) {
                    damageSource = DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)this.getUser()));
                }
                entityHit.func_70097_a(damageSource, 6.0f * ((Double)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.geomancyAttackMultiplier.get()).floatValue());
            }
        } else {
            this.getUser().func_213317_d(this.getUser().func_213322_ci().func_178786_a(0.0, 0.07, 0.0));
            if (this.getUser().func_213322_ci().func_82617_b() < -1.3) {
                this.getUser().func_213293_j(this.getUser().func_213322_ci().func_82615_a(), -1.3, this.getUser().func_213322_ci().func_82616_c());
            }
        }
        if (this.getUser().func_225608_bj_() && lookVec.field_72448_b < 0.0 || this.underground) {
            if (this.getUser().field_70173_aa % 16 == 0) {
                this.getUser().func_184185_a((SoundEvent)((Supplier)MMSounds.EFFECT_GEOMANCY_RUMBLE.get(this.rand.nextInt(3))).get(), 0.6f, 0.5f + this.rand.nextFloat() * 0.2f);
            }
            Vector3d userCenter = this.getUser().func_213303_ch().func_72441_c(0.0, (double)(this.getUser().func_213302_cg() / 2.0f), 0.0);
            float radius = 2.0f;
            AxisAlignedBB aabb = new AxisAlignedBB((double)(-radius), (double)(-radius), (double)(-radius), (double)radius, (double)radius, (double)radius);
            aabb = aabb.func_191194_a(userCenter);
            int i = 0;
            while ((double)i < this.getUser().func_213322_ci().func_72433_c() * 4.0) {
                int x = (int)Math.floor(aabb.field_72340_a);
                while ((double)x <= Math.floor(aabb.field_72336_d)) {
                    int y = (int)Math.floor(aabb.field_72338_b);
                    while ((double)y <= Math.floor(aabb.field_72337_e)) {
                        int z = (int)Math.floor(aabb.field_72339_c);
                        while ((double)z <= Math.floor(aabb.field_72334_f)) {
                            Vector3d motionScaled;
                            BlockPos pos;
                            BlockState blockState;
                            Vector3d posVec = new Vector3d((double)x, (double)y, (double)z);
                            if (!(posVec.func_72441_c(0.5, 0.5, 0.5).func_178788_d(userCenter).func_189985_c() > (double)(radius * radius)) && EffectGeomancy.isBlockDiggable(blockState = this.getUser().field_70170_p.func_180495_p(pos = new BlockPos(posVec = posVec.func_178787_e(motionScaled = this.getUser().func_213322_ci().func_72432_b().func_186678_a((double)i))))) && blockState.func_177230_c() != Blocks.field_150357_h) {
                                this.justDug = blockState;
                                EntityBlockSwapper.swapBlock(this.getUser().field_70170_p, pos, Blocks.field_150350_a.func_176223_P(), 15, false, false);
                            }
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                ++i;
            }
        }
        if (!this.prevUnderground && this.underground) {
            this.timeUnderground = 0;
            this.getUser().func_184185_a((SoundEvent)((Supplier)MMSounds.EFFECT_GEOMANCY_BREAK_MEDIUM.get(this.rand.nextInt(3))).get(), 1.0f, 0.9f + this.rand.nextFloat() * 0.1f);
            if (this.getUser().field_70170_p.field_72995_K) {
                AdvancedParticleBase.spawnParticle(this.getUser().field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.RING2.get()), (float)this.getUser().func_226277_ct_(), (float)this.getUser().func_226278_cu_() + 0.02f, (float)this.getUser().func_226281_cx_(), 0.0, 0.0, 0.0, false, 0.0, 1.5707963267948966, 0.0, 0.0, 3.5, 0.83f, 1.0, 0.39f, 1.0, 1.0, 10.0, true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(10.0f, 30.0f), false)});
            }
        }
        if (this.prevUnderground && !this.underground) {
            this.getUser().func_184185_a((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK.get(), 1.0f, 0.9f + this.rand.nextFloat() * 0.1f);
            if (this.getUser().field_70170_p.field_72995_K) {
                AdvancedParticleBase.spawnParticle(this.getUser().field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.RING2.get()), (float)this.getUser().func_226277_ct_(), (float)this.getUser().func_226278_cu_() + 0.02f, (float)this.getUser().func_226281_cx_(), 0.0, 0.0, 0.0, false, 0.0, 1.5707963267948966, 0.0, 0.0, 3.5, 0.83f, 1.0, 0.39f, 1.0, 1.0, 10.0, true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(10.0f, 30.0f), false)});
            }
            if (this.timeUnderground > 10) {
                this.getUser().func_213317_d(this.getUser().func_213322_ci().func_186678_a(10.0));
            } else {
                this.getUser().func_213317_d(this.getUser().func_213322_ci().func_216372_d(3.0, 7.0, 3.0));
            }
            for (int i = 0; i < 6; ++i) {
                if (this.justDug == null) {
                    this.justDug = Blocks.field_150346_d.func_176223_P();
                }
                EntityFallingBlock fallingBlock = new EntityFallingBlock((EntityType)EntityHandler.FALLING_BLOCK.get(), this.getUser().field_70170_p, 80, this.justDug);
                fallingBlock.func_70107_b(this.getUser().func_226277_ct_(), this.getUser().func_226278_cu_() + 1.0, this.getUser().func_226281_cx_());
                fallingBlock.func_213293_j(this.getUser().func_70681_au().nextFloat() * 0.8f - 0.4f, 0.4f + this.getUser().func_70681_au().nextFloat() * 0.8f, this.getUser().func_70681_au().nextFloat() * 0.8f - 0.4f);
                this.getUser().field_70170_p.func_217376_c((Entity)fallingBlock);
            }
        }
        this.prevUnderground = this.underground;
    }

    @Override
    public boolean canUse() {
        return EffectGeomancy.canUse(this.getUser()) && super.canUse();
    }

    @Override
    protected boolean canContinueUsing() {
        boolean canContinueUsing = EffectGeomancy.canUse(this.getUser()) && (!this.getUser().func_233570_aj_() || this.underground) && super.canContinueUsing();
        return canContinueUsing;
    }

    @Override
    public void onSneakDown(PlayerEntity player) {
        super.onSneakDown(player);
        if (this.doubleTapTimer > 0 && !player.func_233570_aj_()) {
            AbilityHandler.INSTANCE.sendAbilityMessage(player, AbilityHandler.TUNNELING_ABILITY);
        }
        this.doubleTapTimer = 9;
    }

    @Override
    public <E extends IAnimatable> PlayState animationPredicate(AnimationEvent<E> e, GeckoPlayer.Perspective perspective) {
        e.getController().transitionLengthTicks = 4.0;
        if (perspective == GeckoPlayer.Perspective.THIRD_PERSON) {
            float yMotionThreshold;
            float f = yMotionThreshold = this.getUser() == Minecraft.func_71410_x().field_71439_g ? 1.0f : 2.0f;
            if (!this.underground && !this.getUser().func_225608_bj_() && this.getUser().func_213322_ci().func_82617_b() < (double)yMotionThreshold) {
                e.getController().setAnimation(new AnimationBuilder().addAnimation("tunneling_fall", Boolean.valueOf(false)));
            } else {
                e.getController().setAnimation(new AnimationBuilder().addAnimation("tunneling_drill", Boolean.valueOf(true)));
            }
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void codeAnimations(MowzieAnimatedGeoModel<? extends IAnimatable> model, float partialTick) {
        super.codeAnimations(model, partialTick);
        float faceMotionController = 1.0f - model.getControllerValue("FaceVelocityController");
        Vector3d moveVec = this.getUser().func_213322_ci().func_72432_b();
        this.pitch = (float)MathHelper.func_219803_d((double)(0.3 * (double)partialTick), (double)this.pitch, (double)moveVec.func_82617_b());
        MowzieGeoBone com = model.getMowzieBone("CenterOfMass");
        com.setRotationX((float)(-1.5707963267948966 + 1.5707963267948966 * (double)this.pitch) * faceMotionController);
        float spinSpeed = 0.35f;
        if (faceMotionController < 1.0f && (double)this.spinAmount < 6.2731853071795864 && (double)this.spinAmount > 0.01) {
            float f = (float)((Math.PI * 2 - (double)this.spinAmount) / (Math.PI * 2));
            f = (float)Math.pow(f, 0.5);
            this.spinAmount += partialTick * spinSpeed * f;
            if ((double)this.spinAmount > Math.PI * 2) {
                this.spinAmount = 0.0f;
            }
        } else {
            this.spinAmount += faceMotionController * partialTick * spinSpeed;
            this.spinAmount = (float)((double)this.spinAmount % (Math.PI * 2));
        }
        MowzieGeoBone waist = model.getMowzieBone("Waist");
        waist.addRotationY(-this.spinAmount);
    }
}

