/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ai;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;

public class AvoidProjectilesGoal
extends Goal {
    protected final CreatureEntity entity;
    private final double farSpeed;
    private final double nearSpeed;
    protected ProjectileEntity avoidTarget;
    protected final float avoidDistance;
    protected Path path;
    protected Vector3d dodgeVec;
    protected final PathNavigator navigation;
    protected final Class<ProjectileEntity> classToAvoid;
    protected final Predicate<ProjectileEntity> avoidTargetSelector;
    private int dodgeTimer = 0;

    public AvoidProjectilesGoal(CreatureEntity entityIn, Class<ProjectileEntity> classToAvoidIn, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn) {
        this(entityIn, classToAvoidIn, entity -> true, avoidDistanceIn, farSpeedIn, nearSpeedIn);
    }

    public AvoidProjectilesGoal(CreatureEntity entityIn, Class<ProjectileEntity> avoidClass, Predicate<ProjectileEntity> targetPredicate, float distance, double nearSpeedIn, double farSpeedIn) {
        this.entity = entityIn;
        this.classToAvoid = avoidClass;
        this.avoidTargetSelector = targetPredicate.and(target -> {
            Vector3d aActualMotion = new Vector3d(target.func_226277_ct_() - target.field_70169_q, target.func_226278_cu_() - target.field_70167_r, target.func_226281_cx_() - target.field_70166_s);
            if (aActualMotion.func_72433_c() < 0.1 || target.field_70173_aa < 0) {
                return false;
            }
            if (!this.entity.func_70635_at().func_75522_a((Entity)target)) {
                return false;
            }
            float dot = (float)target.func_213322_ci().func_72432_b().func_72430_b(this.entity.func_213303_ch().func_178788_d(target.func_213303_ch()).func_72432_b());
            return !((double)dot < 0.8);
        });
        this.avoidDistance = distance;
        this.farSpeed = nearSpeedIn;
        this.nearSpeed = farSpeedIn;
        this.navigation = entityIn.func_70661_as();
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        Vector3d dodgeDest;
        Vector3d vector3d;
        if (this.dodgeTimer > 0) {
            return false;
        }
        this.avoidTarget = this.getMostMovingTowardsMeEntity(this.classToAvoid, this.avoidTargetSelector, (LivingEntity)this.entity, this.entity.func_174813_aQ().func_72314_b((double)this.avoidDistance, 3.0, (double)this.avoidDistance));
        if (this.avoidTarget == null) {
            return false;
        }
        Vector3d projectilePos = this.guessProjectileDestination(this.avoidTarget);
        this.dodgeVec = this.avoidTarget.func_213322_ci().func_72431_c(new Vector3d(0.0, 1.0, 0.0)).func_72432_b().func_186678_a(1.0);
        Vector3d newPosLeft = this.entity.func_213303_ch().func_178787_e(this.dodgeVec);
        Vector3d newPosRight = this.entity.func_213303_ch().func_178787_e(this.dodgeVec.func_186678_a(-1.0));
        Vector3d diffLeft = newPosLeft.func_178788_d(projectilePos);
        Vector3d diffRight = newPosRight.func_178788_d(projectilePos);
        if (diffRight.func_189985_c() > diffLeft.func_189985_c()) {
            this.dodgeVec = this.dodgeVec.func_186678_a(-1.0);
        }
        if ((vector3d = RandomPositionGenerator.func_75464_a((CreatureEntity)this.entity, (int)5, (int)3, (Vector3d)(dodgeDest = diffRight.func_189985_c() > diffLeft.func_189985_c() ? newPosRight : newPosLeft))) == null) {
            this.path = null;
            return true;
        }
        if (projectilePos.func_178788_d(vector3d).func_189985_c() < projectilePos.func_178788_d(this.entity.func_213303_ch()).func_189985_c()) {
            return false;
        }
        this.path = this.navigation.func_225466_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, 0);
        return true;
    }

    public boolean func_75253_b() {
        return !this.navigation.func_75500_f() || this.dodgeTimer < 10;
    }

    public void func_75249_e() {
        if (this.path != null) {
            this.navigation.func_75484_a(this.path, this.farSpeed);
            this.dodgeVec = this.path.func_75878_a((Entity)this.entity).func_178788_d(this.entity.func_213303_ch()).func_72432_b().func_186678_a(1.0);
        }
        this.entity.func_213317_d(this.entity.func_213322_ci().func_178787_e(this.dodgeVec));
    }

    public void func_75251_c() {
        this.avoidTarget = null;
        this.dodgeTimer = 0;
    }

    public void func_75246_d() {
        if (this.entity.func_70068_e((Entity)this.avoidTarget) < 49.0) {
            this.entity.func_70661_as().func_75489_a(this.nearSpeed);
        } else {
            this.entity.func_70661_as().func_75489_a(this.farSpeed);
        }
        ++this.dodgeTimer;
    }

    private Vector3d guessProjectileDestination(ProjectileEntity projectile) {
        Vector3d vector3d = projectile.func_213303_ch();
        Vector3d vector3d1 = vector3d.func_178787_e(projectile.func_213322_ci().func_186678_a(50.0));
        return this.entity.field_70170_p.func_217299_a(new RayTraceContext(vector3d, vector3d1, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)projectile)).func_216347_e();
    }

    @Nullable
    private <T extends ProjectileEntity> T getMostMovingTowardsMeEntity(Class<? extends T> entityClazz, Predicate<? super T> predicate, LivingEntity entity, AxisAlignedBB p_225318_10_) {
        return this.getMostMovingTowardsMeEntityFromList(entity.field_70170_p.func_225316_b(entityClazz, p_225318_10_, predicate), entity);
    }

    private <T extends ProjectileEntity> T getMostMovingTowardsMeEntityFromList(List<? extends T> entities, LivingEntity target) {
        double d0 = -2.0;
        ProjectileEntity t = null;
        for (ProjectileEntity t1 : entities) {
            double d1 = t1.func_213322_ci().func_72432_b().func_72430_b(target.func_213303_ch().func_178788_d(t1.func_213303_ch()).func_72432_b());
            if (!(d1 > d0)) continue;
            d0 = d1;
            t = t1;
        }
        return (T)t;
    }
}

