/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.capability;

import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieAnimatedGeoModel;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoPlayer;
import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;

public class AbilityCapability {

    public static class AbilityProvider
    implements ICapabilitySerializable<INBT> {
        @CapabilityInject(value=IAbilityCapability.class)
        public static final Capability<IAbilityCapability> ABILITY_CAPABILITY = null;
        private final LazyOptional<IAbilityCapability> instance = LazyOptional.of(() -> ABILITY_CAPABILITY.getDefaultInstance());

        public INBT serializeNBT() {
            return ABILITY_CAPABILITY.getStorage().writeNBT(ABILITY_CAPABILITY, this.instance.orElseThrow(() -> new IllegalArgumentException("Lazy optional must not be empty")), null);
        }

        public void deserializeNBT(INBT nbt) {
            ABILITY_CAPABILITY.getStorage().readNBT(ABILITY_CAPABILITY, this.instance.orElseThrow(() -> new IllegalArgumentException("Lazy optional must not be empty")), null, nbt);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == ABILITY_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }
    }

    public static class AbilityStorage
    implements Capability.IStorage<IAbilityCapability> {
        public INBT writeNBT(Capability<IAbilityCapability> capability, IAbilityCapability instance, Direction side) {
            return instance.writeNBT();
        }

        public void readNBT(Capability<IAbilityCapability> capability, IAbilityCapability instance, Direction side, INBT nbt) {
            instance.readNBT(nbt);
        }
    }

    public static class AbilityCapabilityImp
    implements IAbilityCapability {
        SortedMap<AbilityType<?>, Ability> abilityInstances = new TreeMap();
        Ability activeAbility = null;
        Map<String, INBT> nbtMap = new HashMap<String, INBT>();

        @Override
        public void instanceAbilities(LivingEntity entity) {
            for (AbilityType<?> abilityType : this.getAbilityTypesOnEntity(entity)) {
                Object ability = abilityType.makeInstance(entity);
                this.abilityInstances.put(abilityType, (Ability)ability);
                if (!this.nbtMap.containsKey(abilityType.getName())) continue;
                ((Ability)ability).readNBT(this.nbtMap.get(abilityType.getName()));
            }
        }

        @Override
        public void activateAbility(LivingEntity entity, AbilityType<?> abilityType) {
            Ability ability = (Ability)this.abilityInstances.get(abilityType);
            if (ability != null) {
                boolean tryResult = ability.tryAbility();
                if (tryResult) {
                    ability.start();
                }
            } else {
                System.out.println("Ability " + abilityType.toString() + " does not exist on mob " + entity.getClass().getSimpleName());
            }
        }

        @Override
        public void tick(LivingEntity entity) {
            for (Ability ability : this.abilityInstances.values()) {
                ability.tick();
            }
        }

        @Override
        public AbilityType<?>[] getAbilityTypesOnEntity(LivingEntity entity) {
            if (entity instanceof PlayerEntity) {
                return AbilityHandler.PLAYER_ABILITIES;
            }
            return new AbilityType[0];
        }

        @Override
        public Map<AbilityType<?>, Ability> getAbilityMap() {
            return this.abilityInstances;
        }

        @Override
        public Ability getActiveAbility() {
            return this.activeAbility;
        }

        @Override
        public void setActiveAbility(Ability activeAbility) {
            if (this.getActiveAbility() != null && this.getActiveAbility().isUsing()) {
                this.getActiveAbility().interrupt();
            }
            this.activeAbility = activeAbility;
        }

        @Override
        public Collection<Ability> getAbilities() {
            return this.abilityInstances.values();
        }

        @Override
        public boolean attackingPrevented() {
            return this.getActiveAbility() != null && this.getActiveAbility().preventsAttacking();
        }

        @Override
        public boolean blockBreakingBuildingPrevented() {
            return this.getActiveAbility() != null && this.getActiveAbility().preventsBlockBreakingBuilding();
        }

        @Override
        public boolean interactingPrevented() {
            return this.getActiveAbility() != null && this.getActiveAbility().preventsInteracting();
        }

        @Override
        public <E extends IAnimatable> PlayState animationPredicate(AnimationEvent<E> e, GeckoPlayer.Perspective perspective) {
            return this.getActiveAbility().animationPredicate(e, perspective);
        }

        @Override
        public void codeAnimations(MowzieAnimatedGeoModel<? extends IAnimatable> model, float partialTick) {
            this.getActiveAbility().codeAnimations(model, partialTick);
        }

        @Override
        public INBT writeNBT() {
            CompoundNBT compound = new CompoundNBT();
            for (Map.Entry<AbilityType<?>, Ability> abilityEntry : this.getAbilityMap().entrySet()) {
                CompoundNBT nbt = abilityEntry.getValue().writeNBT();
                if (nbt.isEmpty()) continue;
                compound.func_218657_a(abilityEntry.getKey().getName(), (INBT)nbt);
            }
            return compound;
        }

        @Override
        public void readNBT(INBT nbt) {
            CompoundNBT compound = (CompoundNBT)nbt;
            Set keys = compound.func_150296_c();
            for (String abilityName : keys) {
                this.nbtMap.put(abilityName, compound.func_74781_a(abilityName));
            }
        }
    }

    public static interface IAbilityCapability {
        public void activateAbility(LivingEntity var1, AbilityType<?> var2);

        public void instanceAbilities(LivingEntity var1);

        public void tick(LivingEntity var1);

        public AbilityType<?>[] getAbilityTypesOnEntity(LivingEntity var1);

        public Map<AbilityType<?>, Ability> getAbilityMap();

        public Collection<Ability> getAbilities();

        public Ability getActiveAbility();

        public void setActiveAbility(Ability var1);

        public boolean attackingPrevented();

        public boolean blockBreakingBuildingPrevented();

        public boolean interactingPrevented();

        public <E extends IAnimatable> PlayState animationPredicate(AnimationEvent<E> var1, GeckoPlayer.Perspective var2);

        public void codeAnimations(MowzieAnimatedGeoModel<? extends IAnimatable> var1, float var2);

        public INBT writeNBT();

        public void readNBT(INBT var1);
    }
}

