/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.barakoa;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.server.ServerProxy;
import com.bobmowzie.mowziesmobs.server.ai.BarakoaHurtByTargetAI;
import com.bobmowzie.mowziesmobs.server.ai.EntityAIBarakoayaTrade;
import com.bobmowzie.mowziesmobs.server.ai.EntityAIBarakoayaTradeLook;
import com.bobmowzie.mowziesmobs.server.block.BlockHandler;
import com.bobmowzie.mowziesmobs.server.entity.LeaderSunstrikeImmune;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoa;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.trade.Trade;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.trade.TradeStore;
import com.bobmowzie.mowziesmobs.server.inventory.ContainerBarakoayaTrade;
import com.bobmowzie.mowziesmobs.server.item.BarakoaMask;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class EntityBarakoaVillager
extends EntityBarakoa
implements LeaderSunstrikeImmune,
IMob {
    private static final TradeStore DEFAULT = new TradeStore.Builder().addTrade(Items.field_151043_k, 2, (Item)ItemHandler.BLOWGUN, 1, 6).addTrade(Items.field_196130_bo, 10, (Item)ItemHandler.DART, 8, 6).addTrade(Items.field_151043_k, 3, (Item)ItemHandler.SPEAR, 1, 4).addTrade(Items.field_151074_bl, 5, ((Block)BlockHandler.PAINTED_ACACIA.get()).func_199767_j(), 2, 4).addTrade(Items.field_196130_bo, 16, ((Block)BlockHandler.PAINTED_ACACIA.get()).func_199767_j(), 1, 4).addTrade(Items.field_196130_bo, 10, Items.field_151077_bg, 2, 2).addTrade(Items.field_151074_bl, 8, Items.field_151077_bg, 1, 2).addTrade(Items.field_196130_bo, 14, Items.field_151157_am, 2, 2).addTrade(Items.field_151074_bl, 9, Items.field_151157_am, 1, 2).addTrade(Items.field_221794_dg, 3, Items.field_151074_bl, 5, 2).addTrade(Items.field_151076_bf, 1, Items.field_151074_bl, 3, 2).addTrade(Items.field_151040_l, 1, Items.field_151043_k, 2, 2).addTrade(Items.field_151028_Y, 1, Items.field_151043_k, 4, 2).build();
    private static final DataParameter<Optional<Trade>> TRADE = EntityDataManager.func_187226_a(EntityBarakoaVillager.class, ServerProxy.OPTIONAL_TRADE);
    private static final DataParameter<Optional<UUID>> MISBEHAVED_PLAYER = EntityDataManager.func_187226_a(EntityBarakoaVillager.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final int MIN_OFFER_TIME = 6000;
    private static final int MAX_OFFER_TIME = 24000;
    private TradeStore tradeStore = TradeStore.EMPTY;
    private int timeOffering;
    private PlayerEntity customer;

    public EntityBarakoaVillager(EntityType<? extends EntityBarakoaVillager> type, World world) {
        super((EntityType<? extends EntityBarakoa>)type, world);
        this.setWeapon(0);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new EntityAIBarakoayaTrade(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new EntityAIBarakoayaTradeLook(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 0.4));
    }

    @Override
    protected void registerTargetGoals() {
        this.field_70715_bh.func_75776_a(3, (Goal)new BarakoaHurtByTargetAI(this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal<PlayerEntity>((MobEntity)this, PlayerEntity.class, 0, true, true, target -> {
            if (target instanceof PlayerEntity) {
                if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
                    return false;
                }
                ItemStack headArmorStack = (ItemStack)((PlayerEntity)target).field_71071_by.field_70460_b.get(3);
                return !(headArmorStack.func_77973_b() instanceof BarakoaMask) || target == this.getMisbehavedPlayer();
            }
            return true;
        }){

            public void func_75251_c() {
                super.func_75251_c();
                EntityBarakoaVillager.this.setMisbehavedPlayerId(null);
            }
        });
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, ZombieEntity.class, 0, true, true, null));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractSkeletonEntity.class, 0, true, false, null));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(TRADE, Optional.empty());
        this.field_70180_af.func_187214_a(MISBEHAVED_PLAYER, Optional.empty());
    }

    public void setOfferingTrade(Trade trade) {
        this.func_184212_Q().func_187227_b(TRADE, Optional.ofNullable(trade));
    }

    public Trade getOfferingTrade() {
        return ((Optional)this.func_184212_Q().func_187225_a(TRADE)).orElse(null);
    }

    public boolean isOfferingTrade() {
        if (this.func_184212_Q().func_187225_a(TRADE) instanceof Optional) {
            return ((Optional)this.func_184212_Q().func_187225_a(TRADE)).isPresent();
        }
        return false;
    }

    public void setCustomer(PlayerEntity customer) {
        this.customer = customer;
    }

    public PlayerEntity getCustomer() {
        return this.customer;
    }

    public boolean isTrading() {
        return this.customer != null;
    }

    @Override
    protected boolean canHoldVaryingWeapons() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70638_az() instanceof PlayerEntity && (((PlayerEntity)this.func_70638_az()).func_184812_l_() || this.func_70638_az().func_175149_v())) {
            this.func_70624_b(null);
        }
        if ((!this.isOfferingTrade() || this.timeOffering <= 0) && this.tradeStore.hasStock()) {
            this.setOfferingTrade(this.tradeStore.get(this.field_70146_Z));
            this.timeOffering = this.field_70146_Z.nextInt(18001) + 6000;
        }
    }

    public void openGUI(PlayerEntity playerEntity) {
        this.setCustomer(playerEntity);
        MowziesMobs.PROXY.setReferencedMob((Entity)this);
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null && this.func_70089_S()) {
            playerEntity.func_213829_a(new INamedContainerProvider(){

                public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
                    return new ContainerBarakoayaTrade(id, EntityBarakoaVillager.this, playerInventory);
                }

                public ITextComponent func_145748_c_() {
                    return EntityBarakoaVillager.this.func_145748_c_();
                }
            });
        }
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (this.canTradeWith(player) && this.func_70638_az() == null && this.func_70089_S()) {
            this.openGUI(player);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean canTradeWith(PlayerEntity player) {
        if (this.isTrading()) {
            return false;
        }
        ItemStack headStack = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        return headStack.func_77973_b() instanceof BarakoaMask && this.isOfferingTrade();
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData livingData, @Nullable CompoundNBT compound) {
        this.tradeStore = DEFAULT;
        if (reason == SpawnReason.COMMAND) {
            this.func_213390_a(this.func_233580_cy_(), 25);
        }
        return super.func_213386_a(world, difficulty, reason, livingData, compound);
    }

    public boolean func_213392_I() {
        return true;
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("tradeStore", (INBT)this.tradeStore.serialize());
        if (this.isOfferingTrade()) {
            compound.func_218657_a("offeringTrade", (INBT)this.getOfferingTrade().serialize());
        }
        compound.func_74768_a("timeOffering", this.timeOffering);
        compound.func_74768_a("HomePosX", this.func_213384_dI().func_177958_n());
        compound.func_74768_a("HomePosY", this.func_213384_dI().func_177956_o());
        compound.func_74768_a("HomePosZ", this.func_213384_dI().func_177952_p());
        compound.func_74768_a("HomeDist", (int)this.func_213391_dJ());
        if (this.getMisbehavedPlayerId() != null) {
            compound.func_186854_a("MisbehavedPlayer", this.getMisbehavedPlayerId());
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        UUID uuid;
        super.func_70037_a(compound);
        this.tradeStore = TradeStore.deserialize(compound.func_74775_l("tradeStore"));
        this.setOfferingTrade(Trade.deserialize(compound.func_74775_l("offeringTrade")));
        this.timeOffering = compound.func_74762_e("timeOffering");
        int i = compound.func_74762_e("HomePosX");
        int j = compound.func_74762_e("HomePosY");
        int k = compound.func_74762_e("HomePosZ");
        int dist = compound.func_74762_e("HomeDist");
        this.func_213390_a(new BlockPos(i, j, k), dist);
        if (compound.func_186855_b("MisbehavedPlayer")) {
            uuid = compound.func_186857_a("MisbehavedPlayer");
        } else {
            String s = compound.func_74779_i("MisbehavedPlayer");
            uuid = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setMisbehavedPlayerId(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Nullable
    public UUID getMisbehavedPlayerId() {
        return ((Optional)this.field_70180_af.func_187225_a(MISBEHAVED_PLAYER)).orElse(null);
    }

    public void setMisbehavedPlayerId(@Nullable UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(MISBEHAVED_PLAYER, Optional.ofNullable(p_184754_1_));
    }

    @Nullable
    public LivingEntity getMisbehavedPlayer() {
        try {
            UUID uuid = this.getMisbehavedPlayerId();
            return uuid == null ? null : this.field_70170_p.func_217371_b(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }
}

